/*******************************************************************************
 * Copyright (c) 2006-2007 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Paul Trevithick - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard;


import java.util.List;

import org.eclipse.higgins.icard.ICard;

public interface IPolicy {
	/**
	 * Represents the type of this policy (e.g. "uri", "cardspace", "idemix",
	 * "openid", etc.)
	 */
	public String getType();

	/**
	 * Returns an array of <code>ICard</code> interfaces that could
	 * satisfy this policy.
	 */
	public Class[] getICardTypes();
	
	/**
	 * Gets short description of each claim in this policy;
	 */
	public String[] getSummary();
	
	/**
	 * This parameter specifies the types of claims that must be supplied by the
	 * identity. All claim's types are returned as <code>String</code>.
	 *
	 * @see IClaimType
	 */
	public List getRequiredClaims();

	/**
	 * Checks whether this policy could be satisfied with given
	 * <code>icard</code>.
	 */
	public boolean isSatisfiedBy(ICard icard);
}
