/*******************************************************************************
 * Copyright (c) 2007-2008 Parity Communications, Inc.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Valery Kokhan - Initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.icard.io;

import java.io.OutputStream;

import org.eclipse.higgins.icard.auth.ICredential;

public interface IOutputProcessor {
	/**
	 * Processes array of <code>IOElement</code>s and store them in the
	 * supplied <code>OutputStream</code>.
	 */
	public void process(IElement[] icards, OutputStream out, ICredential credential) throws CardIOException;
}
