/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.button;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class PopupButton extends SimpleButton {

	public static final String TOP_DIRECTION = "top";
	public static final String BOTTOM_DIRECTION = "bottom";

	/**
	 * @param text
	 * @param clickListener
	 */
	private PopupButton(final String text, final ClickListener clickListener) {
		super(text, clickListener);
		final Image image = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgMenuGrayWhite());
		getPanel().add(image);
		image.setStyleName("image_button");
		image.addMouseListener(getMouseListener());
		image.addClickListener(clickListener);
	}

	/**
	 * @param text
	 * @param w
	 * @param direction
	 */
	public PopupButton(final String text, final Widget w, final String direction) {
		this(text, new ClickListener() {
			public void onClick(final Widget owner) {
				final PopupPanel popupPanel = new PopupPanel(true);
				popupPanel.setWidget(w);
				popupPanel.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
					public void setPosition(int offsetWidth, int offsetHeight) {
						if (TOP_DIRECTION.equalsIgnoreCase(direction)) {
							popupPanel.setPopupPosition(10+owner.getParent().getAbsoluteLeft() + owner.getParent().getOffsetWidth() 
									- offsetWidth, owner.getParent().getAbsoluteTop() - offsetHeight - 1);
						} else {
							popupPanel.setPopupPosition(owner.getParent().getAbsoluteLeft(), owner.getParent().getAbsoluteTop()
									+ owner.getParent().getOffsetHeight() + 1);
						}
					}
				});
			}
		});

	}

}
