/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.button;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class SimpleButton extends Composite {

	private Image imageBorderRt;
	private Image imageBorderRtHover;
	private final HorizontalPanel panel = new HorizontalPanel();
	private final HorizontalPanel layoutPanel = new HorizontalPanel();
	private final HTML text = new HTML();
	
	//do not delete for a while
	/*private Widget tooltipWidget;
	private DialogBox tooltipDialog = new DialogBox();
	private int xTooltipCoord = (Utils.rootWidth - Utils.waitDialogBox.getOffsetWidth()) / 2;
	private int yTooltipCoord = (Utils.rootHeight -	Utils.waitDialogBox.getOffsetHeight()) / 2;
		
	private Timer tooltipShowTimer;*/

	private MouseListener mouseListener = new MouseListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.MouseListener#onMouseDown(com.google.gwt.user.client.ui.Widget, int, int)
		 */
		public void onMouseDown(Widget arg0, int arg1, int arg2) {
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.MouseListener#onMouseEnter(com.google.gwt.user.client.ui.Widget)
		 */
		public void onMouseEnter(Widget arg0) {
			SimpleButton.this.getLayoutPanel().remove(SimpleButton.this.getImageBorderRt());
			SimpleButton.this.getLayoutPanel().add(SimpleButton.this.getImageBorderRtHover());
			SimpleButton.this.getPanel().addStyleName(getStyleNameButtonActive());
			/*xTooltipCoord = SimpleButton.this.getAbsoluteLeft() + (SimpleButton.this.getOffsetWidth()/2);
			yTooltipCoord = SimpleButton.this.getAbsoluteTop() - 10;
			if (tooltipDialog != null) 
				tooltipShowTimer.schedule(700);*/
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.MouseListener#onMouseLeave(com.google.gwt.user.client.ui.Widget)
		 */
		public void onMouseLeave(Widget arg0) {
			SimpleButton.this.getLayoutPanel().remove(SimpleButton.this.getImageBorderRtHover());
			SimpleButton.this.getLayoutPanel().add(SimpleButton.this.getImageBorderRt());
			SimpleButton.this.getPanel().removeStyleName(getStyleNameButtonActive());
			/*if (tooltipDialog != null) {
				tooltipDialog.hide();
				tooltipShowTimer.cancel();
			}*/
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.MouseListener#onMouseMove(com.google.gwt.user.client.ui.Widget, int, int)
		 */
		public void onMouseMove(Widget arg0, int arg1, int arg2) {
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.MouseListener#onMouseUp(com.google.gwt.user.client.ui.Widget, int, int)
		 */
		public void onMouseUp(Widget arg0, int arg1, int arg2) {
		}

	};

	public SimpleButton(String text, ClickListener clickListener, Image imageBorderRt, Image imageBorderRtHover) {
		setImageBorderRt(imageBorderRt);
		setImageBorderRtHover(imageBorderRtHover);
		this.getText().setHTML(text);
		this.getText().addClickListener(clickListener);
		this.getPanel().setStyleName(getStyleNameButton());
		this.getPanel().setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.getPanel().add(this.getText());

		this.getText().addMouseListener(mouseListener);

		// getLayoutPanel().setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		getPanel().setHeight("17px");
		getText().setHeight("17px");
		getLayoutPanel().setHeight("17px");
		getLayoutPanel().add(getPanel());
		getLayoutPanel().add(getImageBorderRt());
		initWidget(getLayoutPanel());
	}

	/**
	 * 
	 */
	public SimpleButton(String text, ClickListener clickListener) {
		this(text, clickListener, new Image(Utils.getContextPath() + Utils.baseConstant.uriImgButtonToolbarRt()), new Image(Utils
				.getContextPath()
				+ Utils.baseConstant.uriImgButtonToolbarRtHover()));
	}
	
	/*public SimpleButton(String text, ClickListener clickListener, Widget tooltip) {
		this(text, clickListener, new Image(Utils.getContextPath() + Utils.baseConstant.uriImgButtonToolbarRt()), new Image(Utils
				.getContextPath()
				+ Utils.baseConstant.uriImgButtonToolbarRtHover()), tooltip);
	}*/

	/**
	 * @return the imageBorderRt
	 */
	public Image getImageBorderRt() {
		return this.imageBorderRt;
	}

	/**
	 * @return the imageBorderRtHover
	 */
	public Image getImageBorderRtHover() {
		return this.imageBorderRtHover;
	}

	/**
	 * @return the panel
	 */
	public HorizontalPanel getPanel() {
		return this.panel;
	}

	/**
	 * @return
	 */
	public String getStyleNameButton() {
		return "topPanel_button";
	}

	/**
	 * @return
	 */
	public String getStyleNameButtonActive() {
		return "topPanel_button_active";
	}

	/**
	 * @return the text
	 */
	public HTML getText() {
		return this.text;
	}

	/**
	 * @param imageBorderRt
	 *            the imageBorderRt to set
	 */
	public void setImageBorderRt(Image imageBorderRt) {
		this.imageBorderRt = imageBorderRt;
		// this.imageBorderRt.setSize("17px", "17px");
	}

	/**
	 * @param imageBorderRtHover
	 *            the imageBorderRtHover to set
	 */
	public void setImageBorderRtHover(Image imageBorderRtHover) {
		this.imageBorderRtHover = imageBorderRtHover;
		// this.imageBorderRtHover.setSize("14px", "17px");
	}

	/**
	 * @return the layoutPanel
	 */
	public HorizontalPanel getLayoutPanel() {
		return this.layoutPanel;
	}

	/**
	 * @return the mouseListener
	 */
	public MouseListener getMouseListener() {
		return this.mouseListener;
	}

	/**
	 * @param mouseListener
	 *            the mouseListener to set
	 */
	public void setMouseListener(MouseListener mouseListener) {
		this.mouseListener = mouseListener;
	}

	/**
	 * @param listener
	 * @see com.google.gwt.user.client.ui.Label#addClickListener(com.google.gwt.user.client.ui.ClickListener)
	 */
	public void addClickListener(ClickListener listener) {
		this.text.addClickListener(listener);
	}
	
	//	do not delete for a while
	/*public void setTooltip(Widget tip) {
		this.tooltipWidget = tip;
		this.tooltipShowTimer = new Timer(){
			public void run() {
				if (tooltipWidget != null) {
					tooltipDialog.setStyleName("gwt-WaitPanel");	
					tooltipDialog.setWidget(tooltipWidget);
					tooltipDialog.show();
					tooltipDialog.setPopupPosition(xTooltipCoord, yTooltipCoord);
				}
			}
		};
	}
	
	public Widget getTooltip() {
		return this.tooltipWidget;
	}*/
	
	public void setTooltip(String tip) {
		this.text.setTitle(tip);
	}
	
	public String getTooltip() {
		return this.text.getTitle();
	}
}
