/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Serhiy Plyhun - implementation
 */
package org.eclipse.higgins.ics.gwt.base.client.dialog;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class FadeoutDialogBox extends DialogBox {

	/**
	 * 
	 *//*
	// public static final int hideDelay = 1;
	*//**
	 * 
	 *//*
	public static final int showDelay = 2;

	*//**
	 * tier amount
	 *//*
	public static final int tierCount = 1;

	public static int zIndex = 99999;
	int currentElementZIndex = 0;
	int currentZIndex = 0;

	private Timer hideTimer = new Timer() {
		public void run() {
			if (getRootPanel().getWidgetCount() > 0) {
				for (int i = getRootPanel().getWidgetCount() - 1; i > -1; i--) {
					Widget widget = getRootPanel().getWidget(i);
					int idx = Utils.parseInt(DOM.getStyleAttribute(widget.getElement(), "zIndex"),
							FadeoutDialogBox.this.currentElementZIndex);
					if (idx >= FadeoutDialogBox.this.currentElementZIndex - 3) {
						getRootPanel().remove(widget);
					} else {

					}
				}
			}
			FadeoutDialogBox.super.hide();
		}
	};

	private RootPanel rootPanel = RootPanel.get("overlay");

	private Timer showTimer = new Timer() {
		public void run() {
			FadeoutDialogBox.this.currentZIndex += 1;
			SimplePanel panel = new SimplePanel();
			panel.setStyleName("glassy-layer");
			DOM.setIntStyleAttribute(panel.getElement(), "zIndex", FadeoutDialogBox.this.currentZIndex);
			if (FadeoutDialogBox.this.isVisible()) {
				getRootPanel().add(panel);
				if (FadeoutDialogBox.this.currentZIndex + 1 < FadeoutDialogBox.this.currentElementZIndex) {
					this.schedule(showDelay);
				}
			}
		}
	};

	*//**
	 * 
	 *//*
	public FadeoutDialogBox() {
		super();
	}

	*//**
	 * @param autoHide
	 *//*
	public FadeoutDialogBox(boolean autoHide) {
		super(autoHide);
	}

	*//**
	 * @param autoHide
	 * @param modal
	 *//*
	public FadeoutDialogBox(boolean autoHide, boolean modal) {
		super(autoHide, modal);
	}

	*//**
	 * @return the rootElement
	 *//*
	public Element getRootElement() {
		return this.getRootPanel().getElement();
	}

	*//**
	 * @return the rootPanel
	 *//*
	protected RootPanel getRootPanel() {
		return this.rootPanel;
	}

	
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.PopupPanel#hide()
	 
	public void hide() {
		if (getRootPanel().getWidgetCount() > 0) {
			for (int j = 0; j < tierCount; j++) {
				for (int i = getRootPanel().getWidgetCount() - 1; i > -1; i--) {
					Widget widget = getRootPanel().getWidget(i);
					int idx = Utils.parseInt(DOM.getStyleAttribute(widget.getElement(), "zIndex"),
							FadeoutDialogBox.this.currentElementZIndex);
					if (idx >= FadeoutDialogBox.this.currentElementZIndex - 2 - tierCount) {
						getRootPanel().remove(widget);
					}
				}
			}
		}
		super.hide();
	}

	
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.PopupPanel#show()
	 
	public void show() {
		zIndex = zIndex + 1000;
		this.currentZIndex = zIndex;
		this.currentElementZIndex = this.currentZIndex + tierCount + 2;
		DOM.setIntStyleAttribute(getElement(), "zIndex", this.currentElementZIndex);
		super.show();
		this.showTimer.schedule(showDelay);

	}*/
	protected class GlassyLayer extends SimplePanel {
		
		int deep;
		
		public GlassyLayer(){
			setElement(DOM.createDiv());
		}
		public void show(int deep) {
			this.deep = deep;
			zIndex += this.deep;
			setStyleName("glassy-layer");
	        DOM.setIntStyleAttribute(getElement(), "zIndex", zIndex);
	        DOM.setStyleAttribute(getElement(), "position", "absolute");
	        DOM.setStyleAttribute(getElement(), "left", "0px");
	        DOM.setStyleAttribute(getElement(), "top", "0px");
	        DOM.setStyleAttribute(getElement(), "width", "100%");
	        DOM.setStyleAttribute(getElement(), "height", "100%");
	        RootPanel.get().add(this);
	        setVisible(true);
	    }

	    public void hide() {
	        RootPanel.get().remove(this);
	        zIndex -= deep;
	    }

	}
	
	protected final GlassyLayer g1 = new GlassyLayer();

	protected final GlassyLayer g2 = new GlassyLayer();

	protected final GlassyLayer g3 = new GlassyLayer();
	
	private Timer timer1;
	
	private Timer timer2; 

	private Timer timer3;
	
	private Timer timer4; 

	private static int zIndex = 99999;	
	
	public FadeoutDialogBox()
	{
		super();
	}	
	
	public FadeoutDialogBox(boolean autoHide) {
		super(autoHide);
		zIndex = RootPanel.get().getWidgetCount()*1000;
		DOM.setIntStyleAttribute(this.getElement(), "zIndex", zIndex+100);
	}

	
	public FadeoutDialogBox(boolean autoHide, boolean modal) {
		super(autoHide, modal);
		zIndex = RootPanel.get().getWidgetCount()*1000;
		DOM.setIntStyleAttribute(this.getElement(), "zIndex", zIndex+100);
	}
	
	public void show(){
		zIndex += 1000;
		DOM.setIntStyleAttribute(this.getElement(), "zIndex", zIndex+100);
		makeGlassTimers();
		g1.show(10);
		timer1.schedule(4);
		super.show();		
	}
	
	public void hide()
	{	
		g1.hide();
		zIndex -= 1000;
		super.hide();
		timer3.schedule(4);
	}
	
	public void makeGlassTimers()
	{	timer2 = new Timer() {
			public void run() {
				g3.show(30);				
			}
		};
		timer1 = new Timer() {
			public void run() {
				g2.show(20);				
				timer2.schedule(4);
			}
		};
		timer3 = new Timer() {
			public void run() {
				g2.hide();				
				timer4.schedule(4);
			}
		};
		timer4 = new Timer() {
			public void run() {
				g3.hide();
			}
		};
	}
}
