/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.editor;

import java.util.ArrayList;

import org.eclipse.higgins.ics.gwt.base.client.util.RegExp;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
/**
 * @author Alexander Yuhimenko
 * 
 */
public abstract class BaseEditor extends HorizontalPanel {

	public static final String CHECH_BOX_EDITOR = "CheckBox";

	public static final String COMBO_BOX_EDITOR = "ComboBox";

	public static final String DATE_TEXT_BOX_EDITOR = "Date";

	public static final String HTML_AREA_EDITOR = "HTMLArea";

	public static final String PASSWORD_TEXT_BOX_EDITOR = "PasswordTextBox";

	/**
	 * 
	 */
	public static final String STYLE_EDITOR_LAYOUT = "editor_layout";

	/**
	 * 
	 */
	public static final String STYLE_EDITOR_REQUIRED = "editor_required";

	public static final String STYLE_TEXT_BOX_EDITOR = "editorTextBox";

	public static final String STYLE_EDITOR_ERROR_VALUE = "editor_errorValue";

	public static final String TEXT_AREA_EDITOR = "TextArea";

	public static final String TEXT_BOX_EDITOR = "TextBox";

	public static final String IMAGE_EDITOR = "Image";

	private ArrayList changeListenerList = new ArrayList();

	protected FocusWidget editor;

	private String inputRegExp;

	private String name;

	private String description;

	private String childWidth;
	
	private String childHeight;

	private boolean isCheckValueRunTime;

	private boolean isRequired;

	private boolean isReadOnly;

	private KeyboardListener checkRuntimeKeyboardListener = new KeyboardListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.KeyboardListener#onKeyDown(com.google.gwt.user.client.ui.Widget, char,
		 *      int)
		 */
		public void onKeyDown(Widget arg0, char arg1, int arg2) {
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.KeyboardListener#onKeyPress(com.google.gwt.user.client.ui.Widget, char,
		 *      int)
		 */
		public void onKeyPress(Widget arg0, char arg1, int arg2) {

		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.KeyboardListener#onKeyUp(com.google.gwt.user.client.ui.Widget, char, int)
		 */
		public void onKeyUp(Widget arg0, char arg1, int arg2) {
			if (!checkValueRuntime()) {
				BaseEditor.this.editor.addStyleName(STYLE_EDITOR_ERROR_VALUE);
			} else {
				BaseEditor.this.editor.removeStyleName(STYLE_EDITOR_ERROR_VALUE);
			}
		}

	};

	/**
	 * 
	 */
	public BaseEditor() {
		super();
		setStyleName(STYLE_EDITOR_LAYOUT);
		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
	}

	public void addChangeListener(ChangeListener listener) {
		this.changeListenerList.add(listener);
	}

	/**
	 * @param listener
	 * @see com.google.gwt.user.client.ui.FocusWidget#addKeyboardListener(com.google.gwt.user.client.ui.KeyboardListener)
	 */
	public void addKeyboardListener(KeyboardListener listener) {
		this.editor.addKeyboardListener(listener);
	}

	/**
	 * @return the changeListenerList
	 */
	public ArrayList getChangeListenerList() {
		return this.changeListenerList;
	}

	/**
	 * @return one from predefined editor type constant
	 */
	public abstract String getTypeEditor();

	/**
	 * @return current value
	 */
	public abstract String getValue();

	/**
	 * @return the isRequired
	 */
	public boolean isRequired() {
		return this.isRequired;
	}

	/**
	 * @param focused
	 * @see com.google.gwt.user.client.ui.FocusWidget#setFocus(boolean)
	 */
	public void setFocus(boolean focused) {
		this.editor.setFocus(focused);
	}

	/**
	 * @param isRequired
	 *            the isRequired to set
	 */
	public void setRequired(boolean isRequired) {
		this.isRequired = isRequired;
		if (this.isRequired) {
			editor.addStyleName(STYLE_EDITOR_REQUIRED);
		} else {
			editor.removeStyleName(STYLE_EDITOR_REQUIRED);
		}
	}

	/**
	 * @param val
	 *            current value
	 */
	public abstract void setValue(String val);

	/**
	 * @return
	 */
	public boolean checkValue() {
		if (isReadOnly())
			return true;

		if (isRequired()) {
			if (getValue() == null || getValue().trim().length() == 0)
				return false;
			if (getInputRegExp() != null && getInputRegExp().length() > 0) {
				return RegExp.create(getInputRegExp()).test(getValue());
			}
			return true;
		} else {
			if (getValue() != null && getValue().trim().length() > 0 && getInputRegExp() != null && getInputRegExp().length() > 0)
				return RegExp.create(getInputRegExp()).test(getValue());
			return true;
		}
	}

	public boolean checkValueRuntime() {
		if (isReadOnly())
			return true;

		if (getValue() != null && getValue().trim().length() > 0 && getInputRegExp() != null && getInputRegExp().length() > 0)
			return RegExp.create(getInputRegExp()).test(getValue());
		return true;
	}

	/**
	 * @return the inputRegExp
	 */
	public String getInputRegExp() {
		return this.inputRegExp;
	}

	/**
	 * @param inputRegExp
	 *            the inputRegExp to set
	 */
	public void setInputRegExp(String inputRegExp) {
		this.inputRegExp = inputRegExp;
	}

	/**
	 * @return the isCheckValueRunTime
	 */
	public boolean isCheckValueRunTime() {
		return this.isCheckValueRunTime;
	}

	/**
	 * @param isCheckValueRunTime
	 *            the isCheckValueRunTime to set
	 */
	public void setCheckValueRunTime(boolean isCheckValueRunTime) {
		this.isCheckValueRunTime = isCheckValueRunTime;
		try {
			if (isCheckValueRunTime) {
				this.editor.addKeyboardListener(this.checkRuntimeKeyboardListener);
			} else {
				this.editor.removeKeyboardListener(this.checkRuntimeKeyboardListener);
			}
		} catch (RuntimeException e) {
		}

	}

	/**
	 * @return the isReadOnly
	 */
	public boolean isReadOnly() {
		return this.isReadOnly;
	}

	/**
	 * @param isReadOnly
	 *            the isReadOnly to set
	 */
	public void setReadOnly(boolean isReadOnly) {
		this.isReadOnly = isReadOnly;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return this.description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the childWidth
	 */
	public String getChildWidth() {
		return this.childWidth;
	}

	/**
	 * @param childWidth the childWidth to set
	 */
	public void setChildWidth(String childWidth) {
		this.childWidth = childWidth;
	}

	/**
	 * @return the childHeight
	 */
	public String getChildHeight() {
		return this.childHeight;
	}

	/**
	 * @param childHeight the childHeight to set
	 */
	public void setChildHeight(String childHeight) {
		this.childHeight = childHeight;
	}

}
