/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.editor;

import org.eclipse.higgins.ics.gwt.base.client.BaseConstant;
import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.panel.RoundedPanelDialog;
import org.eclipse.higgins.ics.gwt.base.client.panel.WaitPanel;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.FormSubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormSubmitEvent;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ImageEditor extends BaseEditor {

	private String base64ImageData;

	private SimpleButton changeButton;

	private TextBox childHeightTextBox = new TextBox();

	private TextBox childWidthTextBox = new TextBox();

	private SimpleDialog choseFileDialog;

	private FormPanel form = new FormPanel();

	private HorizontalPanel formPanel = new HorizontalPanel();

	private Image image = new Image();

	private final WaitPanel wait = new WaitPanel(ICMEntryPoint.dictionary.get("UploadingFileLabel_HTML"));

	private DialogBox waitBox = new DialogBox();

	private FileUpload upload = new FileUpload();

	private final BaseConstant constant = (BaseConstant) GWT.create(BaseConstant.class);

	private final CardActionButton uploadImageButton = new CardActionButton(ICMEntryPoint.dictionary.get("UploadButton_HTML"),
			new ClickListener() {

				/*
				 * (non-Javadoc)
				 * 
				 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
				 */
				public void onClick(Widget arg0) {
					getForm().submit();
				}
			});

	/**
	 * 
	 */
	public ImageEditor() {
		super();
		try {
			buildForm();

			setChangeButton(new SimpleButton(ICMEntryPoint.dictionary.get("ChoosePictureButton_HTML"), new ClickListener() {
				/*
				 * (non-Javadoc)
				 * 
				 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
				 */
				public void onClick(Widget arg0) {
					setChoseFileDialog(new SimpleDialog(getForm()));
					getChoseFileDialog().setText(ICMEntryPoint.dictionary.get("ChoosePictureButton_HTML"));
					getChoseFileDialog().getButtonPanel().insert(uploadImageButton, 2);
					getChoseFileDialog().showDialog();

				}

			}));

			add(this.getChangeButton());
			this.editor = new TextBox();
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * 
	 */
	private void buildForm() {
		getForm().setAction(Utils.getContextPath() + "img2string");
		getForm().setEncoding(FormPanel.ENCODING_MULTIPART);
		getForm().setMethod(FormPanel.METHOD_POST);
		getUpload().setName("imageFile");
		DOM.setElementAttribute(getUpload().getElement(), "size", "45");
		getUpload().setStyleName("imageFile");
		formPanel.add(getUpload());
		getChildWidthTextBox().setName("childWidth");
		getChildWidthTextBox().setVisible(false);
		formPanel.add(getChildWidthTextBox());

		getChildHeightTextBox().setName("childHeight");
		getChildHeightTextBox().setText(getChildHeight());
		getChildHeightTextBox().setVisible(false);
		formPanel.add(getChildHeightTextBox());

		getForm().setWidget(formPanel);
		getForm().addFormHandler(new FormHandler() {
			public void onSubmit(FormSubmitEvent event) {
				if (getUpload().getFilename() != null
						&& (getUpload().getFilename().toLowerCase().endsWith("jpeg")
								|| getUpload().getFilename().toLowerCase().endsWith("jpg") || getUpload().getFilename().toLowerCase()
								.endsWith("gif"))) {
					if (!Utils.isIE())
						Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("UploadingFileLabel_HTML"));
					else
						showSafeProgressPopup();
					// image.setUrl(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());
				} else {
					event.setCancelled(true);
					Utils.showErrorMessage("Supported only <b>jpeg</b> and <b>gif</b> images. <br> Please, choose other file.");
				}
			}

			public void onSubmitComplete(FormSubmitCompleteEvent event) {
				if (!Utils.isIE())
					Utils.hideWaiteDialog();
				else
					hideSafeProgressPopup();
				String response = event.getResults();
				if (!Utils.isIE() && response != null && response.length() > 10) {
					response = response.substring(5, response.length() - 6);
				}
				if (response == null || response.startsWith("Error")) {
					Utils.showErrorMessage(response);
				} else {
					ImageEditor.this.setValue(response);
					getChoseFileDialog().hide();
				}
			}
		});
		getUpload().setVisible(true);
	}

	/**
	 * @return the changeButton
	 */
	private SimpleButton getChangeButton() {
		return this.changeButton;
	}

	/**
	 * @return the childHeightTextBox
	 */
	private TextBox getChildHeightTextBox() {
		return this.childHeightTextBox;
	}

	/**
	 * @return the childWidthTextBox
	 */
	private TextBox getChildWidthTextBox() {
		return this.childWidthTextBox;
	}

	/**
	 * @return the choseFileDialog
	 */
	public SimpleDialog getChoseFileDialog() {
		return this.choseFileDialog;
	}

	/**
	 * @return the form
	 */
	FormPanel getForm() {
		return this.form;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getTypeEditor()
	 */
	public String getTypeEditor() {
		return IMAGE_EDITOR;
	}

	/**
	 * @return the upload
	 */
	FileUpload getUpload() {
		return this.upload;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getValue()
	 */
	public String getValue() {
		return this.base64ImageData;
	}

	/**
	 * @param changeButton
	 *            the changeButton to set
	 */
	private void setChangeButton(SimpleButton changeButton) {
		this.changeButton = changeButton;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setChildHeight(java.lang.String)
	 */
	public void setChildHeight(String childHeight) {
		super.setChildHeight(childHeight);
		this.getChildHeightTextBox().setText(getChildHeight());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setChildWidth(java.lang.String)
	 */
	public void setChildWidth(String childWidth) {
		super.setChildWidth(childWidth);
		this.getChildWidthTextBox().setText(getChildWidth());
	}

	/**
	 * @param choseFileDialog
	 *            the choseFileDialog to set
	 */
	public void setChoseFileDialog(SimpleDialog choseFileDialog) {
		this.choseFileDialog = choseFileDialog;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean isReadOnly) {
		super.setReadOnly(isReadOnly);
		getChangeButton().setVisible(!isReadOnly);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setValue(java.lang.String)
	 */
	public void setValue(String val) {
		/*Safari fix*/
		if (val != null && val.indexOf(";")!= -1) {
			val = val.substring(val.lastIndexOf(";")+3);
		}
		try {
			this.base64ImageData = val;
			final String logoAddress = constant.servletPaintLogoAddress() + "?cdata=" + val.substring(val.length() - 20).replace('+', '_');
			if (Utils.isIE()) {
				//image.setUrl(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());
				ICMEntryPoint.service.putImageForIE(val, new AsyncCallback() {
					public void onSuccess(Object arg0) {
						image.setUrl(logoAddress);
					}

					public void onFailure(Throwable arg0) {
						image.setVisible(false);
					}
				});
			}
			/*
			 * if (Utils.isIE()) { if (val != null) { image.setUrl(constant.servletPaintLogoAddress() + "?cdata=" +
			 * val.substring(val.length() - 20)); image.setVisible(true); } else image.setVisible(false); }
			 */else {
				DOM.setElementAttribute(this.image.getElement(), "src", "data:image/jpeg;base64," + val);
				/*image.setWidth("60px");
				image.setHeight("60px");*/
			}
			
			insert(this.image, 0);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// insert(this.image, 0);
		// DOM.setElementAttribute(this.image.getElement(), "src",
		// "data:image/jpeg;base64," + val);
	}

	private void showSafeProgressPopup() {
		RoundedPanelDialog roundedPanel = new RoundedPanelDialog(wait);
		waitBox.setWidget(roundedPanel);
		DOM.setIntStyleAttribute(waitBox.getElement(), "zIndex", 999999);
		waitBox.show();
		waitBox.setPopupPosition((Utils.rootWidth - waitBox.getOffsetWidth()) / 2, (Utils.rootHeight - waitBox.getOffsetHeight()) / 2);
		;
	}

	private void hideSafeProgressPopup() {
		waitBox.hide();
	}
}
