/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.editor;

import com.google.gwt.user.client.ui.TextBox;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class TextBoxEditor extends BaseEditor {

	/**
	 * 
	 */
	public TextBoxEditor() {
		super();
		editor = new TextBox();
//		editor.setWidth("100%");
		editor.setStyleName(STYLE_TEXT_BOX_EDITOR);
		add(editor);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getTypeEditor()
	 */
	public String getTypeEditor() {
		return TEXT_BOX_EDITOR;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getValue()
	 */
	public String getValue() {
		return ((TextBox) editor).getText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean isReadOnly) {
		super.setReadOnly(isReadOnly);
		((TextBox) editor).setReadOnly(isReadOnly);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setValue(java.lang.String)
	 */
	public void setValue(String val) {
		if (val != null) 
			((TextBox) editor).setText(val);
		else ((TextBox) editor).setText("");
	}

}
