/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.model.entity;

import java.io.Serializable;
import java.util.Date;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class Card extends BaseEntity implements Serializable {

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		if (obj instanceof Card) {
			return this.getCuid().equals(((Card) obj).getCuid());
		}
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return 7*this.getCuid().hashCode();
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = -3403379025788539523L;

	private String cuid;

	private Date expiredTime;

	private String id;

	private String image;

	private String imageType;

	private String issuerName;

	private Boolean selfIssued;

	private Boolean isRelationCatagory = new Boolean(false);

	private ClaimItem[] claimItems;
	
	private CardInformation cardInfo;

	private String defaultIcon;

	private String selectedIcon;

	private CardCredential[] cardCredential;

	private boolean isProtected = false;

	private boolean isValueAvailable = false;
	
	private boolean isSaveCredential = false;

	/**
	 * @return the cuid
	 */
	public String getCuid() {
		return this.cuid;
	}

	/**
	 * @param cuid
	 *            the cuid to set
	 */
	public void setCuid(String cuid) {
		this.cuid = cuid;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the imageType
	 */
	public String getImageType() {
		return this.imageType;
	}

	/**
	 * @param imageType
	 *            the imageType to set
	 */
	public void setImageType(String imageType) {
		this.imageType = imageType;
	}

	/**
	 * @return the issuerName
	 */
	public String getIssuerName() {
		return this.issuerName;
	}

	/**
	 * @param issuerName
	 *            the issuerName to set
	 */
	public void setIssuerName(String issuerName) {
		this.issuerName = issuerName;
	}

	/**
	 * @return the claimItems
	 */
	public ClaimItem[] getClaimItems() {
		return this.claimItems;
	}

	/**
	 * @param claimItems
	 *            the claimItems to set
	 */
	public void setClaimItems(ClaimItem[] claimItems) {
		this.claimItems = claimItems;
	}

	/**
	 * @return the image
	 */
	public String getImage() {
		return this.image;
	}

	/**
	 * @param image
	 *            the image to set
	 */
	public void setImage(String image) {
		this.image = image;
	}

	/**
	 * @return the cardCredential
	 */
	public CardCredential[] getCardCredential() {
		return this.cardCredential;
	}

	/**
	 * @param cardCredential
	 *            the cardCredential to set
	 */
	public void setCardCredential(CardCredential[] cardCredential) {
		this.cardCredential = cardCredential;
	}

	/**
	 * @return the isRelationCatagory
	 */
	public Boolean isRelationCatagory() {
		return this.isRelationCatagory;
	}

	/**
	 * @param isRelationCatagory
	 *            the isRelationCatagory to set
	 */
	public void setRelationCatagory(Boolean isRelationCatagory) {
		this.isRelationCatagory = isRelationCatagory;
	}

	/**
	 * @return the selfIssued
	 */
	public Boolean getSelfIssued() {
		return this.selfIssued;
	}

	/**
	 * @param selfIssued
	 *            the selfIssued to set
	 */
	public void setSelfIssued(Boolean selfIssued) {
		this.selfIssued = selfIssued;
	}

	/**
	 * @return the expiredTime
	 */
	public Date getExpiredTime() {
		return this.expiredTime;
	}

	/**
	 * @param expiredTime
	 *            the expiredTime to set
	 */
	public void setExpiredTime(Date expiredTime) {
		this.expiredTime = expiredTime;
	}

	/**
	 * @return the defaultIcon
	 */
	public String getDefaultIcon() {
		return this.defaultIcon;
	}

	/**
	 * @param defaultIcon
	 *            the defaultIcon to set
	 */
	public void setDefaultIcon(String defaultIcon) {
		this.defaultIcon = defaultIcon;
	}

	/**
	 * @return the selectedIcon
	 */
	public String getSelectedIcon() {
		return this.selectedIcon;
	}

	/**
	 * @param selectedIcon
	 *            the selectedIcon to set
	 */
	public void setSelectedIcon(String selectedIcon) {
		this.selectedIcon = selectedIcon;
	}

	/**
	 * @return the isProtected
	 */
	public boolean isProtected() {
		return this.isProtected;
	}

	/**
	 * @param isProtected
	 *            the isProtected to set
	 */
	public void setProtected(boolean isProtected) {
		this.isProtected = isProtected;
		setValueAvailable(!isProtected);
	}

	/**
	 * @return the isValueAvailable
	 */
	public boolean isValueAvailable() {
		return this.isValueAvailable;
	}

	/**
	 * @param isValueAvailable
	 *            the isValueAvailable to set
	 */
	public void setValueAvailable(boolean isValueAvailable) {
		this.isValueAvailable = isValueAvailable;
	}
	
	public void setCardInformation(CardInformation info)
	{
		this.cardInfo = info;
	}
	
	public CardInformation getCardInformation()
	{
		return this.cardInfo;
	}
	
	public void setIsSaveCredential(boolean isSave)
	{
		this.isSaveCredential = isSave;
	}
	
	public boolean isSaveCredential()
	{
		return this.isSaveCredential;
	}
}
