/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 * */
package org.eclipse.higgins.ics.gwt.base.client.util;

import org.eclipse.higgins.ics.gwt.base.client.BaseConstant;
import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.FadeoutDialogBox;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;
import org.eclipse.higgins.ics.gwt.base.client.panel.WaitPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class Utils {

	public static BaseConstant baseConstant;

	public static int rootHeight;

	public static final String contextPath;

	public static int rootWidth;

	public static WaitPanel waitPanel;

	public static FadeoutDialogBox waitDialogBox;

	static {
		baseConstant = (BaseConstant) GWT.create(BaseConstant.class);
		rootWidth = Window.getClientWidth();
		try {
			rootHeight = parseInt(getWindowHeight(), Window.getClientHeight());
		} catch (Exception e) {
			rootHeight = Window.getClientHeight();
		}
		contextPath = GWT.getModuleBaseURL().substring(0, GWT.getModuleBaseURL().indexOf(GWT.getModuleName()));
		waitPanel = new WaitPanel();
		waitDialogBox = new FadeoutDialogBox();
		// defineGetICard();
		// defineAfterImportICard();
		// defineOpenICMTab();
	}

	public static final void setRootWidth(int width) {
		rootWidth = width;
	}

	public static final void setRootHeight(int height) {
		rootHeight = height;
	}

	public static final void recalculateSize() {
		rootWidth = Window.getClientWidth();
		try {
			rootHeight = parseInt(getWindowHeight(), 0);
		} catch (Exception e) {
			rootHeight = 600;
		}
	}

	public static final void setPixelSize(int width, int height) {
		rootWidth = width;
		rootHeight = height;
	}

	public static final UserProfile cloneUserProfile(UserProfile userProfile) {
		UserProfile copy = new UserProfile();
		copy.setName(userProfile.getName());
		copy.setCreated(userProfile.getCreated());
		copy.setEmail(userProfile.getEmail());
		copy.setFirstName(userProfile.getFirstName());
		copy.setLastName(userProfile.getLastName());
		copy.setLoginName(userProfile.getLoginName());
		copy.setModified(userProfile.getModified());
		copy.setPassword(userProfile.getPassword());
		copy.setStatus(userProfile.getStatus());
		copy.setUsedFrom(userProfile.getUsedFrom());
		return copy;
	}

	public static final void showWaiteDialog(String message) {
		waitPanel.setText(message);
		// final RoundedPanelDialog roundedPanel = new RoundedPanelDialog(waitPanel);
		waitDialogBox.clear();
		waitDialogBox.setStyleName("gwt-WaitPanel");
		waitDialogBox.setWidget(waitPanel);
		// waitDialogBox.show();
		// waitDialogBox
		// .setPopupPosition((rootWidth - waitDialogBox.getOffsetWidth()) / 2, (rootHeight -
		// waitDialogBox.getOffsetHeight()) / 2);

		waitDialogBox.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
			public void setPosition(int offsetWidth, int offsetHeight) {
				int w = waitPanel.getOffsetWidth(), h = waitPanel.getOffsetHeight();
				if (w + 100 > Utils.rootWidth)
					w = Utils.rootWidth - 50;
				if (h + 170 > Utils.rootHeight)
					h = Utils.rootHeight - 170;

				waitDialogBox.setPixelSize(w + 20, h);

				waitDialogBox.setPopupPosition(((Utils.rootWidth - w) / 2), (Utils.rootHeight - h) / 2);
			}
		});

	}

	public static final void hideWaiteDialog() {
		waitDialogBox.hide();
	}

	public static final Card cloneCard(Card srcCard) {
		Card card = new Card();
		card.setName(srcCard.getName());
		card.setCuid(srcCard.getCuid());
		card.setExpiredTime(srcCard.getExpiredTime());
		card.setId(srcCard.getId());
		card.setImage(srcCard.getImage());
		card.setImageType(srcCard.getImageType());
		card.setIssuerName(srcCard.getIssuerName());
		card.setSelfIssued(srcCard.getSelfIssued());
		card.setRelationCatagory(srcCard.isRelationCatagory());
		card.setClaimItems(srcCard.getClaimItems());
		card.setCardInformation(srcCard.getCardInformation());
		card.setDefaultIcon(srcCard.getDefaultIcon());
		card.setSelectedIcon(srcCard.getSelectedIcon());
		card.setCardCredential(srcCard.getCardCredential());
		card.setProtected(srcCard.isProtected());
		card.setValueAvailable(srcCard.isValueAvailable());
		card.setIsSaveCredential(srcCard.isSaveCredential());
		return card;
	}

	public static final void showErrorMessage(String message) {
		final HorizontalPanel bodyPanel = new HorizontalPanel();
		bodyPanel.setSpacing(5);
		bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		bodyPanel.add(new Image(baseConstant.uriImgIconAlertLarge()));
		HTML html = new HTML(message);
		html.setStyleName("message");
		bodyPanel.add(html);
		final SimpleDialog dialog = new SimpleDialog(bodyPanel);
		// dialog.getHeaderPanel().add(new HTML("<h1>Error </h1>"));
		dialog.setHTML("<center><h1> Error </h1></center>");

		dialog.showDialog();
		// dialog.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
		// public void setPosition(int offsetWidth, int offsetHeight) {
		// int w = bodyPanel.getOffsetWidth(), h = bodyPanel.getOffsetHeight();
		// if (w + 100 > Utils.rootWidth)
		// w = Utils.rootWidth - 50;
		// if (h + 170 > Utils.rootHeight)
		// h = Utils.rootHeight - 170;
		//
		// dialog.setPixelSize(w + 40, h);
		//
		// dialog.setPopupPosition(((Utils.rootWidth - w) / 2), (Utils.rootHeight - h) / 2);
		// }
		// });
	}

	public static final void showConfirmDialog(String title, String message, CardActionButton actionButton) {
		final HorizontalPanel bodyPanel = new HorizontalPanel();
		bodyPanel.setSpacing(5);
		bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		bodyPanel.add(new Image(baseConstant.uriImgIconAlertLarge()));
		HTML html = new HTML(message);
		html.setStyleName("message");
		bodyPanel.add(html);
		final SimpleDialog dialog = new SimpleDialog(bodyPanel);
		// dialog.getHeaderPanel().add(new HTML("<center><h1>" + title + "</h1></center>"));
		dialog.setHTML("<center><h1>" + title + "</h1></center>");
		actionButton.addClickListener(new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				dialog.hide();
			}
		});
		dialog.getButtonPanel().insert(actionButton, 2);
		dialog.showDialog();
		// dialog.center();
		// dialog.setPopupPositionAndShow(new PopupPanel.PositionCallback() {
		// public void setPosition(int offsetWidth, int offsetHeight) {
		// int w = bodyPanel.getOffsetWidth(), h = bodyPanel.getOffsetHeight();
		// if (w + 100 > Utils.rootWidth)
		// w = Utils.rootWidth - 50;
		// if (h + 170 > Utils.rootHeight)
		// h = Utils.rootHeight - 170;
		//
		// dialog.setPixelSize(w + 40, h);
		//
		// dialog.setPopupPosition(((Utils.rootWidth - w) / 2), (Utils.rootHeight - h) / 2);
		// }
		// });

	}

	public static final void addModule(String moduleName, Widget widget) {
		RootPanel rootPanel = RootPanel.get(moduleName);
		if (rootPanel != null)
			rootPanel.add(widget);
	}

	public static boolean replaceWidget(final String oldComponentName, Widget newComponent) {
		RootPanel rootPanel = RootPanel.get(oldComponentName);
		if (rootPanel != null) {
			rootPanel.clear();
			rootPanel.add(newComponent);
			return true;
		}
		return false;
	}

	public static final Widget findModule(String moduleName, int widgetIdx) {
		RootPanel rootPanel = RootPanel.get(moduleName);
		if (rootPanel != null) {
			if (rootPanel.getWidgetCount() > widgetIdx) {
				return rootPanel.getWidget(widgetIdx);
			} else if (rootPanel.getWidgetCount() > 0) {
				return rootPanel.getWidget(0);
			} else {
				return null;
			}
		}
		return null;
	}

	public static final int parseInt(String str, int defVal) {
		int res = defVal;
		try {
			res = Integer.parseInt(str);
		} catch (Exception e) {
			res = defVal;
		}
		return res;
	}

	public static final String getContextPath() {
		return contextPath;
	}

	// public static final String getParameter(String pname) {
	// return WindowUtils.getLocation().getParameter(pname);
	// }

	public static void showHelp() {
		Window.open("/icm-help/index.html"/* baseConstant.uriHelpPageIndex() */, "_blank",
				"toolbar=yes,location=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes");
	}

	public static final void addStylesheet(String uri, Element rootElement) {
		try {
			Element link = DOM.createElement("link");
			DOM.setElementAttribute(link, "href", getContextPath() + uri);
			DOM.setElementAttribute(link, "rel", "stylesheet");
			DOM.setElementAttribute(link, "type", "text/css");
			DOM.appendChild(rootElement, link);
		} catch (RuntimeException e) {
		}
	}

	public static native boolean isIE() /*-{
	
	 return navigator.userAgent.toLowerCase().indexOf("msie")>=0  || navigator.userAgent.toLowerCase().indexOf("adobeair")>=0;
	 
	}-*/;

	// 

	public static native void reloadPage() /*-{
	        $wnd.location.reload();
	    }-*/;

	public static native void defineAddCSS(String uri) /*-{
	$doc.addcss = function (fdoc){
		  	 var oLink = fdoc.createElement('link');
	     oLink.href = uri;
	     oLink.rel = 'stylesheet';
	     oLink.type = 'text/css';
	     fdoc.body.appendChild(oLink);
	};
	}-*/;

	public static native Element getDocument(Element e) /*-{
	   if ( !e || !e.contentWindow) {
	      return null;
	   }
	   return e.contentWindow.document.body;
	}-*/;

	public static native boolean checkCardSpace() /*-{
	   var IEVer = -1;
	   if (navigator.appName == 'Microsoft Internet Explorer')
	     if (new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})").exec(navigator.userAgent) != null)
	     	IEVer = parseFloat( RegExp.$1 );
	   if( IEVer >= 6 ) {
	     var embed = document.createElement("object");
	     embed.setAttribute("type", "application/x-informationcard");
	     if(  ""+embed.issuerPolicy != "undefined" )
	       return true;
	     return false;        
	   }    
	   if( IEVer < 0 && navigator.mimeTypes && navigator.mimeTypes.length) {
	     x = navigator.mimeTypes['application/x-informationcard'];
	     if (x && x.enabledPlugin)
	       return true;
	   }
	   return false;
	}-*/;

	public static native boolean checkHBX() /*-{ 
	  var imgs=$doc.getElementsByTagName('IMG');
	  for (var i=0;i<imgs.length;i++){ 
	     var img=imgs[i]; 
	     if (img.className=='toolbarimg'){
	        if (!img.complete) {
	          return false;
	        }
	        if (typeof img.naturalWidth != "undefined" && img.naturalWidth == 0){
	          return false;
	        }
	        return true;
	     } 
	  }        
	}-*/;

	public static native String getWindowHeight() /*-{
	 var t = "";
	 t += "$doc.compatMode=" + ($doc.compatMode || "") + "<br>";
	 t += "$doc.body.clientHeight=" + ($doc.body.clientHeight || "") + "<br>";
	 t += "$doc.documentElement.clientHeight=" + ($doc.documentElement.clientHeight ||
	 "") + "<br>";
	 t = ($wnd.innerHeight || "");
	 return t;
	 }-*/;

	public static native String getElementHeight(Element e) /*-{
	return e.innerHeight;
	 }-*/;

	public static native String getElementWidth(Element e) /*-{
	return $wnd.getComputedStyle(e,null).width;
	 }-*/;

	public static native void click(Element e) /*-{
	   e.click();
	 }-*/;

	// public static final CardTemplateItem cloneCardTemplateItem(CardTemplateItem cardTemplateItem) {
	// CardTemplateItem copy = new CardTemplateItem();
	// copy.setName(cardTemplateItem.getName());
	// return copy;
	// }
	// public static final CardTemplate cloneCardTemplate(CardTemplate cardTemplate) {
	// CardTemplate copy = new CardTemplate();
	// copy.setName(cardTemplate.getName());
	// copy.setCardType(cardTemplate.getCardType());
	// copy.setDescription(cardTemplate.getDescription());
	// copy.setId(cardTemplate.getId());
	// copy.setIdx(cardTemplate.getIdx());
	// copy.setProviderID(cardTemplate.getProviderID());
	// copy.setProviderName(cardTemplate.getProviderName());
	//		
	// for (int i = 0; i < cardTemplate.getCardTemplateItems().length; i++) {
	//			
	// }
	// return copy;
	// }

}
