/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.panel.category.CategoryEditablePanel;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class RPCUtils {

	public static void deleteAllCards() {
		// CardActionButton actionButton = new CardActionButton("Delete ALL cards", new NotYetImplimented());

		CardActionButton actionButton = new CardActionButton(ICMEntryPoint.dictionary.get("DeleteAllCardsMenuItem_HTML"),
				new ClickListener() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
					 */
					public void onClick(Widget arg0) {
						Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("DeletingCardsLabel_HTML"));
						ICMEntryPoint.service.deleteAllCard(ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile()
								.getPassword(), new GWTCallBack() {

							/*
							 * (non-Javadoc)
							 * 
							 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
							 */
							public void onSuccess(Object res) {
								Utils.hideWaiteDialog();
								if (res instanceof GWTResponse) {
									if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
										// ICMEntryPoint.currentState.deleteAllCard();
										Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("CardsDeletedReloadLabel_HTML"));
										Utils.reloadPage();
									} else {
										Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
									}
								}
							}
						});
					}
				});

		Utils.showConfirmDialog(ICMEntryPoint.dictionary.get("DeleteAllCardsMessageTitle_HTML"), ICMEntryPoint.dictionary
				.get("DeleteAllCardsMessageBody_HTML"), actionButton);

	}

	public static void deleteCategory(final Category category) {

		CardActionButton actionButton = new CardActionButton(ICMEntryPoint.dictionary.get("DeleteCategoryLabel_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				Utils.showWaiteDialog("Deleting category '" + category.getName() + "' on server ...");
				ICMEntryPoint.service.deleteCategory(category, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
						.getUserProfile().getPassword(), new GWTCallBack() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
								ICMEntryPoint.currentState.deleteCategory(category);
							} else {
								Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
							}
						}
					}
				});
			}
		});

		if (category.getCardList().size() > 0)
			Utils.showConfirmDialog(ICMEntryPoint.dictionary.get("DeleteCategoryMessageTitle_HTML"), "\'"+category.getName()
					+ ICMEntryPoint.dictionary.get("DeleteCategoryMessageBody_HTML"), actionButton);
		else
			Utils.showConfirmDialog(ICMEntryPoint.dictionary.get("DeleteEmptyCategoryMessageTitle_HTML"), "<p>The \'" + category.getName()
					+ ICMEntryPoint.dictionary.get("DeleteEmptyCategoryMessageBody_HTML"), actionButton);

	}

	public static void moveCardToCategory(final Category category) {
		if (category.getCardList().contains(ICMEntryPoint.currentState.getSelectedCard())) {
			Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ErrorNonEmptyCategoryMessagePart1_HTML") + category.getName()
					+ ICMEntryPoint.dictionary.get("ErrorNonEmptyCategoryMessagePart2_HTML"));
		} else {

			Category oldCategory = ICMEntryPoint.currentState.getSelectedCategory();
			final Card card = ICMEntryPoint.currentState.getSelectedCard();

			// remove card from old category
			ICMEntryPoint.currentState.removeCard(card, oldCategory);
			oldCategory.getCardList().remove(card);
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("MovingCardLabel_HTML"));
				ICMEntryPoint.service.modifyCategory(oldCategory, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
						.getUserProfile().getPassword(), new GWTCallBack() {
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
					}
				});
			
			// add card to category
			ICMEntryPoint.currentState.addNewCard(card, category);

				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("MovingCardLabel_HTML"));
				ICMEntryPoint.service.modifyCategory(category, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
						.getUserProfile().getPassword(), new GWTCallBack() {
					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						if (res instanceof GWTResponse) {
							Utils.hideWaiteDialog();
							if (!((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
								Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
							}
							
							else {
								
							}
						}
					}
				});
			}
	}

	public static void removeCardFromCategory() {
		Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("RemovingCardLabel_HTML"));
		final Category category = ICMEntryPoint.currentState.getSelectedCategory();
		category.getCardList().remove(ICMEntryPoint.currentState.getSelectedCard());

		ICMEntryPoint.service.modifyCategory(category, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile()
				.getPassword(), new GWTCallBack() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
			 */
			public void onSuccess(Object res) {
				Utils.hideWaiteDialog();
				if (res instanceof GWTResponse) {
					if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
						ICMEntryPoint.currentState.removeCard(ICMEntryPoint.currentState.getSelectedCard(), category);
					} else {
						Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
					}
				}
			}
		});

	}

	public static void createCategory(int idx) {
		Category category = new Category();
		category.setParentId("0");
		category.setIdx(idx);
		category.setName(ICMEntryPoint.dictionary.get("NewCategoryButton_HTML"));
		category.setIcon("personas_category_icon");
		category.setSelectedIcon("personas_category_selected_icon");
		CategoryEditablePanel editablePanel = new CategoryEditablePanel(category);
		SimpleDialog dialog = new SimpleDialog(editablePanel, false);
		dialog.setText(ICMEntryPoint.dictionary.get("DetailsNewCategoryMenuItem_HTML"));
		editablePanel.setDialogBox(dialog);
		dialog.getButtonPanel().insert(editablePanel.getCreateCategoryButton(), 2);
		dialog.showDialog();
		editablePanel.setFocus(true);
	}

	public static void modifyCategory(Category category) {
		CategoryEditablePanel editablePanel = new CategoryEditablePanel(category);
		SimpleDialog dialog = new SimpleDialog(editablePanel);
		dialog.setText(ICMEntryPoint.dictionary.get("DetailsEditCategoryButton_HTML"));
		editablePanel.setDialogBox(dialog);
		dialog.getButtonPanel().insert(editablePanel.getModifyCategoryButton(), 2);
		dialog.showDialog();
		editablePanel.setFocus(true);
	}
}
