package org.eclipse.higgins.ics.gwt.icm.client.backup;

import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.BaseConstant;
import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class ChooseCardsBackupPanel extends VerticalPanel implements BackupWizardPage{
	
	private final BaseConstant constant = (BaseConstant) GWT.create(BaseConstant.class);
	
	private class CardBackupPanelItem extends VerticalPanel {
		
		private Image image = new Image();
		
		private Label label;
		
		private String cuid;
		
		private boolean selected;
		
		public CardBackupPanelItem(final Card card) {
			super();
			selected = false;
			cuid = card.getCuid();
			setWidth("140px");
			setHeight("140px");
			setSpacing(2);
			setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
			setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
			final String imagee = new String(card.getImage());
			try {
				if (Utils.isIE()) {
					//photo.setUrl(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());
					ICMEntryPoint.service.putImageForIE(card.getImage(),
							new AsyncCallback() {
								public void onSuccess(Object arg0) {
									image.setUrl(constant.servletPaintLogoAddress()
											+ "?cdata="
											+ imagee.substring(imagee.length() - 20).replace('+','_'));
								}

								public void onFailure(Throwable arg0) {
									image.setVisible(false);
								}
							});
				} else
					DOM.setElementAttribute(image.getElement(), "src",
							"data:image/jpeg;base64," + imagee);
			} catch (Exception e) {
				e.printStackTrace();
			}
			image.setSize("120px", "80px");
			add(image);
			label = new Label(card.getName().substring(0, 15));
			label.setTitle(card.getName());
			label.setSize("100%", "100%");
			add(label);
			ClickListener listener = new ClickListener() {
				public void onClick(Widget arg) {
					selected = !selected;
					if (selected) {
						setStyleName("backupWizardItemSelected");
						cardCount++;
						cardCounter.setHTML("You've chosen "+cardCount+" cards");
					}
					else {
						removeStyleName("backupWizardItemSelected");
						cardCount--;
						cardCounter.setHTML("You've chosen "+cardCount+" cards");
					}
				}
			};
			
			MouseListener mouseListener = new MouseListener() {
				
				 public void onMouseEnter(Widget arg0) {
					/*image.addStyleName("cardTreeItemPreSelected");
					label.addStyleName("cardTreeItemPreSelected");*/
					addStyleName("backupWizardItemPreSelected"); 
				}

				public void onMouseLeave(Widget arg0) {
					/*image.removeStyleName("cardTreeItemPreSelected");
					label.removeStyleName("cardTreeItemPreSelected");*/
					removeStyleName("backupWizardItemPreSelected");
				}

				
				 public void onMouseMove(Widget arg0, int arg1, int arg2) {
				}

				
				public void onMouseUp(Widget arg0, int arg1, int arg2) {
				}
				
				public void onMouseDown(Widget arg0, int arg1, int arg2) {					
				}
			};
			
			addMouseListener(mouseListener);
			addClickListener(listener);
							
		}
		
		public void addClickListener(ClickListener listener) {
			this.image.addClickListener(listener);
			this.label.addClickListener(listener);		
		}
		
		public void removeClickListener(ClickListener listener) {
			this.image.removeClickListener(listener);
			this.label.removeClickListener(listener);	
		}
		
		public void addMouseListener(MouseListener mouseListener) {
			this.image.addMouseListener(mouseListener);
			this.label.addMouseListener(mouseListener);	
		}
		
		public void removeMouseListener(MouseListener mouseListener) {
			this.image.removeMouseListener(mouseListener);
			this.label.removeMouseListener(mouseListener);
		}
		
		public boolean isSelected() {
			return this.selected;
		}
		
		public void setSelected(boolean selected) {
			this.selected = selected;
		}
		
	}
	
	private final Label description = new Label("Description");
	
	private final HTML cardCounter = new HTML();
	
	private int cardCount = 0;
	
	private List cards;
	
	private int tableWidthCount = 3;
	
	private final FlexTable cardsTable = new FlexTable();
	
	public ChooseCardsBackupPanel() {
		super();
		setSpacing(10);
		cardsTable.setCellSpacing(2);
		setSize("100%", "100%");
		add(description);
		add(cardsTable);
		add(cardCounter);
		tableWidthCount = (Utils.rootWidth/160) - 2;
		if (tableWidthCount<1) tableWidthCount=3;		
	}
	
	public String getHeader() {
		return "Choose cards";
	}	
	
	public void drawTable() {
		cardCount = 0;
		cardCounter.setHTML("");
		int row = 0;
		int col = 0;
		for (int i=0; i<cards.size(); i++) {
			CardBackupPanelItem item = new CardBackupPanelItem((Card)cards.get(i));
			cardsTable.setWidget(row, col, item);			
			col++;
			if (col>tableWidthCount) {
				row++;
				col=0;
			}
		}
		cardsTable.setSize("100%", "100%");
	}

	public List getCards() {
		return cards;
	}

	public void setCards(List cards) {
		this.cards = cards;
	}
	
	public String[] getSelectedCardCuids() {
		String[] cuids = new String[cardCount];
		int cuidsNum = 0;
		int row = 0;
		int col = 0;
		for (int i=0; i<cards.size(); i++) {
			CardBackupPanelItem item = (CardBackupPanelItem)cardsTable.getWidget(row, col);	
			if (item.selected) {
				cuids[cuidsNum] = item.cuid;
				cuidsNum++;
			}
			col++;
			if (col>tableWidthCount) {
				row++;
				col=0;
			}
		}
		return cuids;
	}

	public int getCardCount() {
		return cardCount;
	}

	public void setCardCount(int cardCount) {
		this.cardCount = cardCount;
	}
	
	public CardActionButton getSelectAllButton() {
		return new CardActionButton("Select All", new ClickListener() {
			public void onClick(Widget arg){
				int row = 0;
				int col=0;
				for (int i=0; i<cards.size(); i++) {
					CardBackupPanelItem item = (CardBackupPanelItem)cardsTable.getWidget(row, col);	
					if (!item.selected) {
						item.selected = true;
						item.setStyleName("backupWizardItemSelected");
						cardCount++;
						cardCounter.setHTML("You've chosen "+cardCount+" cards");
					}
					col++;
					if (col>tableWidthCount) {
						row++;
						col=0;
					}
				}
			}
		});
	}
	
	public CardActionButton getDeselectAllButton() {
		return new CardActionButton("Deselect All", new ClickListener() {
			public void onClick(Widget arg){
				int row = 0;
				int col=0;
				for (int i=0; i<cards.size(); i++) {
					CardBackupPanelItem item = (CardBackupPanelItem)cardsTable.getWidget(row, col);	
					if (item.selected) {
						item.selected = false;
						item.removeStyleName("backupWizardItemSelected");
						cardCount--;
						cardCounter.setHTML("You've chosen "+cardCount+" cards");
					}
					col++;
					if (col>tableWidthCount) {
						row++;
						col=0;
					}
				}
			}
		});
	}
}
