/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Serhiy Plygun - implementation
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormHandler;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.FormSubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormSubmitEvent;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class ImportFilePanel extends Composite {

	private final VerticalPanel bodyPanel = new VerticalPanel();
	private FormPanel form = new FormPanel();
	private FileUpload upload = new FileUpload();
	private HTML description = new HTML();
	private SimpleDialog chooseFileDialog;
	private TextBox login = new TextBox();
	private TextBox password = new TextBox();
	private final CardActionButton uploadButton;
	private String fileMask;

	public ImportFilePanel(String actionUrl, String fileMask) {
		this.bodyPanel.add(description);
		this.fileMask = fileMask;
		form.setAction(Utils.getContextPath() + actionUrl);
		form.setEncoding(FormPanel.ENCODING_MULTIPART);
		form.setMethod(FormPanel.METHOD_POST);
		upload.setName("cardFile");
		upload.setHeight("20px");
		DOM.setElementAttribute(upload.getElement(), "size", "62");
		upload.setStyleName("imageFile");

		HorizontalPanel formPanel = new HorizontalPanel();
		formPanel.add(upload);
		login.setName("ln");
		login.setText(ICMEntryPoint.getUserProfile().getLoginName());
		login.setVisible(false);
		formPanel.add(login);

		uploadButton = new CardActionButton(ICMEntryPoint.dictionary.get("UploadButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				form.submit();
			}
		});

		password.setName("pw");
		password.setText(ICMEntryPoint.getUserProfile().getPassword());
		password.setVisible(false);
		formPanel.add(password);

		form.setWidget(formPanel);
		form.addFormHandler(new FormHandler() {
			public void onSubmit(FormSubmitEvent event) {
				ImportFilePanel.this.onSubmit(event);
			}

			public void onSubmitComplete(FormSubmitCompleteEvent event) {
				Utils.hideWaiteDialog();
				String response = event.getResults();
				if (response != null && response.length() > 10) {
					response = response.substring(5, response.length() - 6);
				}
				if (response == null || response.startsWith("Error")) {
					Utils.showErrorMessage(response);
				} else {
					chooseFileDialog.hide();
					ImportFilePanel.this.onSubmitComplete(event);
				}
			}
		});

		initWidget(this.bodyPanel);
	}

	public void show(String dialogHeaderMessage) {
		chooseFileDialog = new SimpleDialog(this.form);
		chooseFileDialog.setText(dialogHeaderMessage);
		chooseFileDialog.getButtonPanel().insert(uploadButton, 2);
		chooseFileDialog.showDialog();
	}
	
	public void setAction(String url) {
		form.setAction(url);
	}
	
	public String getFileMask() {
		return fileMask;
	}
	
	public FileUpload getUpload() {
		return upload;
	}
	
	public void setFileMask(String fileMask) {
		this.fileMask = fileMask;
	}
	
	public SimpleDialog getDialog() {
		return chooseFileDialog;
	}
	
	public abstract void onSubmitComplete(FormSubmitCompleteEvent event);
	
	public abstract void onSubmit(FormSubmitEvent event);
}
