/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.button.PopupButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeUserProfileListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;
import org.eclipse.higgins.ics.gwt.base.client.panel.RoundedPanelDialog;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.panel.profile.UserProfilePanel;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class TopPanel extends Composite {

	private final HorizontalPanel layoutPanel = new HorizontalPanel();
	private final VerticalPanel logoPanel = new VerticalPanel();
	private final HorizontalPanel buttonPanel = new HorizontalPanel();
	private final Image imageLogoParity = new Image(Utils.getContextPath() + ICMEntryPoint.constant.uriImgLogoIcardSelector());
	final Label htmlWelcome = new Label();

	/**
	 * 
	 */
	public TopPanel() {
		this.layoutPanel.setWidth("100%");
		this.layoutPanel.setStyleName("topPanel_layout");
		this.layoutPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.layoutPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);

		try {
			ICMEntryPoint.addChangeUserProfileList(new ChangeUserProfileListener() {

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.higgins.ics.gwt.base.client.listener.ChangeUserProfileListener#onChangeUserProfile(org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile)
				 */
				public void onChangeUserProfile(UserProfile userProfile) {
					TopPanel.this.htmlWelcome.setText(ICMEntryPoint.dictionary.get(ICMEntryPoint.constant.dnWelcomeText()) + "  "
							+ userProfile.getFirstName() + " " + userProfile.getLastName());
				}

			});
			this.htmlWelcome.setText(ICMEntryPoint.dictionary.get(ICMEntryPoint.constant.dnWelcomeText()) + "  "
					+ ICMEntryPoint.getUserProfile().getFirstName() + " " + ICMEntryPoint.getUserProfile().getLastName());

			this.htmlWelcome.setStyleName("topPanel_welcome");
			this.imageLogoParity.setStyleName("topPanel_logo");

		} catch (Exception e) {
		}

		this.logoPanel.add(this.imageLogoParity);

		this.buttonPanel.setSpacing(8);
		this.buttonPanel.add(new SimpleButton("Account", new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				UserProfilePanel userProfilePanel = new UserProfilePanel();
				userProfilePanel.show();
				userProfilePanel.setFocus();
			}
		}));
		this.buttonPanel.add(new PopupButton(ICMEntryPoint.dictionary.get("ToolsButtonTitle_HTML"), new RoundedPanelDialog(
				new ToolsListPanel()), PopupButton.BOTTOM_DIRECTION));
		this.buttonPanel.add(new SimpleButton(ICMEntryPoint.dictionary.get("HelpButtonTitle_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				Utils.showHelp();
			}

		}));
		// this.buttonPanel.add(new SimpleButton("Log out", new NotYetImplimented()));

		this.layoutPanel.add(this.logoPanel);
		this.layoutPanel.add(this.htmlWelcome);
		this.layoutPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		this.layoutPanel.add(this.buttonPanel);
		initWidget(this.layoutPanel);
	}

	/**
	 * @param width
	 * @param height
	 * @see com.google.gwt.user.client.ui.UIObject#setPixelSize(int, int)
	 */
	public void setPixelSize(int width, int height) {
		this.layoutPanel.setPixelSize(width, height);
	}

	/**
	 * @param width
	 * @param height
	 * @see com.google.gwt.user.client.ui.UIObject#setSize(java.lang.String, java.lang.String)
	 */
	public void setSize(String width, String height) {
		this.layoutPanel.setSize(width, height);
	}

	/**
	 * @param width
	 * @see com.google.gwt.user.client.ui.UIObject#setWidth(java.lang.String)
	 */
	public void setWidth(String width) {
		this.layoutPanel.setWidth(width);
	}

}
