/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class UserNamePasswordCredentialPanel extends Composite implements CardCredentialEditor {

	private CardCredential cardCredential;

	private final FlexTable bodyTable = new FlexTable();
	private final PasswordTextBox passwordTextBox = new PasswordTextBox();
	private final Label passwordLabel = new Label(ICMEntryPoint.dictionary.get("PasswordLabel_HTML"));
	private final TextBox userNameTextBox = new TextBox();
	private final Label userNameLabel = new Label(ICMEntryPoint.dictionary.get("UserNameLabel_HTML"));

	/**
	 * 
	 */
	public UserNamePasswordCredentialPanel(CardCredential cardCredential) {
		if (cardCredential != null && CardCredentialEditor.USERNAME_PASSWORD_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
			this.cardCredential = cardCredential;
			this.bodyTable.setWidget(0, 0, this.userNameLabel);
			this.bodyTable.setWidget(0, 1, this.userNameTextBox);
			this.bodyTable.setWidget(1, 0, this.passwordLabel);
			this.bodyTable.setWidget(1, 1, this.passwordTextBox);
			this.userNameTextBox.setText(cardCredential.getUsername());
			this.userNameTextBox.setReadOnly(!(cardCredential.getUsername().equals("?") || cardCredential.getUsername().equals("") || cardCredential.getUsername()==null));
			this.passwordTextBox.setText(cardCredential.getPassword());
		}
		initWidget(this.bodyTable);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialEditor#setCardCredential(org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential)
	 */
	public CardCredential getCardCredential() {
		if (this.cardCredential != null) {
			if (CardCredentialEditor.USERNAME_PASSWORD_CRIDENTIAL_TYPE.equals(this.cardCredential.getType())) {
				this.cardCredential.setUsername(getUserNameTextBox().getText());
				this.cardCredential.setPassword(getPasswordTextBox().getText());
			}
		}
		return this.cardCredential;
	}

	/**
	 * @return the passwordTextBox
	 */
	public PasswordTextBox getPasswordTextBox() {
		return this.passwordTextBox;
	}

	/**
	 * @return the userNameTextBox
	 */
	public TextBox getUserNameTextBox() {
		return this.userNameTextBox;
	}

	/**
	 * @param focused
	 * @see com.google.gwt.user.client.ui.FocusWidget#setFocus(boolean)
	 */
	public void setFocus(boolean focused) {
		this.passwordTextBox.setFocus(focused);
	}

}
