/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.editor.TextBoxEditor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CategoryEditablePanel extends Composite {

	private final HTML desciption = new HTML(ICMEntryPoint.dictionary.get("CategoryNameLabel_HTML"));
	//private final Label name = new Label("Name");
	private final TextBoxEditor categoryName = new TextBoxEditor();
	private final CardActionButton createCategoryButton;
	private final CardActionButton modifyCategoryButton;
	private final VerticalPanel bodyPanel = new VerticalPanel();
	private SimpleDialog dialogBox;

	/**
	 * 
	 */
	public CategoryEditablePanel(final Category category) {
		bodyPanel.setSpacing(7);
		this.desciption.setStyleName("messages");
		this.categoryName.setValue(category.getName());

		createCategoryButton = new CardActionButton(ICMEntryPoint.dictionary.get("DetailsConfirmNewCategoryDialogTitle_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("CreatingCategoryLabel_HTML"));
				category.setName(CategoryEditablePanel.this.categoryName.getValue());
				ICMEntryPoint.service.createCategory(category, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
						.getUserProfile().getPassword(), new GWTCallBack() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
								ICMEntryPoint.currentState.addCategory((Category) ((GWTResponse) res).getResult());

							} else {
								Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
							}
						}
						if (getDialogBox() != null) {
							getDialogBox().hide();
						}

					}
				});
			}
		});

		modifyCategoryButton = new CardActionButton(ICMEntryPoint.dictionary.get("SaveButton_HTML"), new ClickListener() {
			
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("UpdatingCategoryLabel_HTML"));
				category.setName(CategoryEditablePanel.this.categoryName.getValue());
				ICMEntryPoint.service.modifyCategory(category, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
						.getUserProfile().getPassword(), new GWTCallBack() {
					
					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
								
								ICMEntryPoint.currentState.modifyCategory((Category) ((GWTResponse) res).getResult());
								
							} else {
								Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
							}
						}
						if (getDialogBox() != null) {
							getDialogBox().hide();
						}
						
					}
				});
			}
		});

		this.bodyPanel.add(this.desciption);
		// this.bodyPanel.add(this.name);
		this.bodyPanel.add(this.categoryName);

		initWidget(this.bodyPanel);

	}

	/**
	 * @return the categoryName
	 */
	public TextBoxEditor getCategoryName() {
		return this.categoryName;
	}

	/**
	 * @return the dialogBox
	 */
	public SimpleDialog getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox(SimpleDialog dialogBox) {
		this.dialogBox = dialogBox;
	}

	/**
	 * @return the createCategoryButton
	 */
	public CardActionButton getCreateCategoryButton() {
		return this.createCategoryButton;
	}

	/**
	 * @param focused
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setFocus(boolean)
	 */
	public void setFocus(boolean focused) {
		this.categoryName.setFocus(focused);
	}

	/**
	 * @return the modifyCategoryButton
	 */
	public CardActionButton getModifyCategoryButton() {
		return this.modifyCategoryButton;
	}

}
