/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category;

import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.button.MenuItemMouseListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.AddCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifyCategoryListListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifyCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.RPCUtils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CategoryListPanel extends Composite {

	private final FlexTable flexTable = new FlexTable();

	private class CategoryItem extends HorizontalPanel {
		final Category category;
		private final Label label;

		/**
		 * @param category
		 */
		public CategoryItem(Category category) {
			super();
			this.category = category;
			// Image imgDelete = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgDeleteCategory());
			// imgDelete.addClickListener(new ClickListener() {
			// public void onClick(Widget arg0) {
			// RPCUtils.deleteCategory(categoryItem);
			// hideParentPopup();
			// }
			// });
			// imgDelete.addMouseListener(new MenuItemMouseListener());

			label = new Label(category.getName());
			label.setStyleName("default");
			label.addMouseListener(new MenuItemMouseListener());
			label.addClickListener(new ClickListener() {
				/*
				 * (non-Javadoc)
				 * 
				 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
				 */
				public void onClick(Widget arg0) {
					RPCUtils.moveCardToCategory(CategoryItem.this.category);
					hideParentPopup();
				}
			});
			add(label);
		}

		/**
		 * @return the category
		 */
		public Category getCategory() {
			return this.category;
		}

		/**
		 * @return the label
		 */
		public Label getLabel() {
			return this.label;
		}

	}

	private ModifyCategoryListener modifyCategoryListener = new ModifyCategoryListener() {
		public void onModifyCategory(Category category) {
			if (category != null && category.getId() != null) {
				for (int i = 0; i < flexTable.getRowCount(); i++) {
					try {
						if (category.getId().equalsIgnoreCase(((CategoryItem) flexTable.getWidget(i, 0)).getCategory().getId())) {
							((CategoryItem) flexTable.getWidget(i, 0)).getCategory().setName(category.getName());
							((CategoryItem) flexTable.getWidget(i, 0)).getLabel().setText(category.getName());
						}
					} catch (Exception e) {
					}
				}
			}
		}
	};

	private final DeleteCategoryListener deleteCategoryListener = new DeleteCategoryListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCategoryListener#onDeleteCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onDeleteCategory(Category category) {
			if (category != null && category.getId() != null) {
				for (int i = 0; i < flexTable.getRowCount(); i++) {
					try {
						if (category.getId().equalsIgnoreCase(((CategoryItem) flexTable.getWidget(i, 0)).getCategory().getId())) {
							flexTable.removeRow(i);
						}
					} catch (Exception e) {
					}
				}
			}
		}

	};

	private final AddCategoryListener addCategoryListener = new AddCategoryListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.AddCategoryListener#onAddCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onAddCategory(Category category) {
			buildItem(category);
			// CategoryListPanel.this.idx = CategoryListPanel.this.idx + 1;
		}
	};
	
	private ModifyCategoryListListener modifyCategoryListListener = new ModifyCategoryListListener()
	{
		public void onModifyCategoryList(List list)
		{
			for (int i=flexTable.getRowCount()-1; i>0; i--)
				flexTable.removeRow(i);
			
			buildCategoryList(list);
		}
	};

	// int idx = 2;

	/**
	 * 
	 */
	public CategoryListPanel() {
		Label createLabel = new Label(ICMEntryPoint.dictionary.get("DetailsConfirmNewCategoryDialogTitle_HTML"));
		createLabel.setStyleName("default");
		createLabel.setStyleName("createCategoryLabel");
		createLabel.addClickListener(new ClickListener() {
			public void onClick(Widget arg0) {
				RPCUtils.createCategory(flexTable.getRowCount() + 1);
			}
		});

		createLabel.addClickListener(new ClickListener() {
			public void onClick(Widget arg0) {
				hideParentPopup();
			}
		});
		createLabel.addMouseListener(new MenuItemMouseListener());
		this.flexTable.setWidget(0, 0, createLabel);
		this.flexTable.getFlexCellFormatter().setColSpan(0, 0, 2);
		buildCategoryList(ICMEntryPoint.currentState.getCategoryList(ICMEntryPoint.currentState.getCategory()));
		ICMEntryPoint.currentState.addDeleteCategoryListener(this.deleteCategoryListener);
		ICMEntryPoint.currentState.addModifyCategoryListener(this.modifyCategoryListener);
		ICMEntryPoint.currentState.addModifyCategoryListListener(this.modifyCategoryListListener);

		initWidget(this.flexTable);
	}

	/**
	 * @param iterator
	 */
	void buildItem(final Category categoryItem) {
		this.flexTable.setWidget(this.flexTable.getRowCount() + 1, 0, new CategoryItem(categoryItem));
		// this.flexTable.setWidget(idx, 1, imgDelete);
	}
	
	void buildCategoryList(List categoryList)
	{
		
		for (Iterator iterator = categoryList.iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			// if (!categoryItem.isPreDefined()) {
			buildItem(categoryItem);
			// }
		}
	}

	void hideParentPopup() {
		try {
			// TODO refactor that
			((PopupPanel) flexTable.getParent().getParent().getParent().getParent().getParent()).hide();
		} catch (RuntimeException e) {
		}
	}

	/**
	 * @return the addCategoryListener
	 */
	public AddCategoryListener getAddCategoryListener() {
		return this.addCategoryListener;
	}
}
