/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.button.DialogButton;
import org.eclipse.higgins.ics.gwt.base.client.button.NewButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.listener.AddCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifyCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.RPCUtils;
import org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd.TableDragController;
import org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd.TableDropController;

import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ManageCategoriesPanel extends Composite {
	private final String header = new String(ICMEntryPoint.dictionary.get("ManageCategoriesMenuItem_HTML"));
	
	private final NewButton newCategoryButton;
	
	final AbsolutePanel tableExamplePanel = new AbsolutePanel();
	private final VerticalPanel layoutPanel = new VerticalPanel();
	private final HorizontalPanel actionPanel = new HorizontalPanel();
	final FlexTable flexTable = new FlexTable();

	private TableDragController dragController;
	private CardActionButton saveChangesButton;
	
	private DialogButton cancelButton;

	// private final VerticalPanel bodyPanel = new VerticalPanel();
	private SimpleDialog dialogBox;

	private final DeleteCategoryListener deleteCategoryListener = new DeleteCategoryListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCategoryListener#onDeleteCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onDeleteCategory(Category category) {
			if (category != null && category.getId() != null) {
				for (int i = 0; i < ManageCategoriesPanel.this.flexTable.getRowCount(); i++) {
					// if (ManageCategoriesPanel.this.flexTable.getWidget(i, 0) instanceof CategoryPanelItem) {
					try {
						if (category.getId().equalsIgnoreCase(
								((CategoryPanelItem) ManageCategoriesPanel.this.flexTable.getWidget(i, 0)).getCategory().getId())) {
							ManageCategoriesPanel.this.flexTable.removeRow(i);
							
						}
					} catch (Exception e) {
					}
					// }
				}
			}
			
		}
	};

	private final ModifyCategoryListener modifyCategoryListener = new ModifyCategoryListener() {
		public void onModifyCategory(Category category) {
			if (category != null && category.getId() != null) {
				for (int i = 0; i < ManageCategoriesPanel.this.flexTable.getRowCount(); i++) {
					try {
						if (category.getId().equalsIgnoreCase(
								((CategoryPanelItem) ManageCategoriesPanel.this.flexTable.getWidget(i, 0)).getCategory().getId())) {
							((CategoryPanelItem) ManageCategoriesPanel.this.flexTable.getWidget(i, 0)).getCategory().setName(
									category.getName());
							((CategoryPanelItem) ManageCategoriesPanel.this.flexTable.getWidget(i, 0)).getLabel().setText(
									category.getName());
						}
					} catch (Exception e) {
					}
				}
			}
		}
	};
	private final AddCategoryListener addCategoryListener = new AddCategoryListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.AddCategoryListener#onAddCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onAddCategory(Category category) {
			buildItem(category, flexTable.getRowCount());
			tableExamplePanel.setSize("100%", "100%");		
		}
	};

	/**
	 * 
	 */
	public ManageCategoriesPanel() {
		//tableExamplePanel.setPixelSize(306, (ICMEntryPoint.currentState.getCategory().getChildList().size()) * 33);
		tableExamplePanel.setSize("100%", "100%");
		this.dragController = new TableDragController(tableExamplePanel);
		ICMEntryPoint.currentState.addAddCategoryListener(this.addCategoryListener);
		ICMEntryPoint.currentState.addDeleteCategoryListener(this.deleteCategoryListener);
		ICMEntryPoint.currentState.addModifyCategoryListener(this.modifyCategoryListener);
		this.newCategoryButton = new NewButton("New", new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				RPCUtils.createCategory(flexTable.getRowCount());
			}

		});
		
		this.cancelButton = new DialogButton("Close", new ClickListener() {

			public void onClick(Widget arg0) {
				
				dialogBox.hide();
			}
		});

		this.saveChangesButton = new CardActionButton(ICMEntryPoint.dictionary.get("SaveButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(final Widget arg0) {
				
				try {
					Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("ModifyingCategoriesWaitLabel_HTML"));
					final ArrayList categoryList = new ArrayList();
					Category[] categoryArray = new Category[flexTable.getRowCount()];
					for (int i=0; i<flexTable.getRowCount(); i++)
					{
						Category category = ((CategoryPanelItem)flexTable.getWidget(i, 0)).getCategory();
						category.setIdx(i);
						categoryList.add(category);
						categoryArray[i] = category;
					}
					ICMEntryPoint.service.modifyCategories(ICMEntryPoint.getUserProfile().getLoginName(),
							ICMEntryPoint.getUserProfile().getPassword(),
							categoryArray, new GWTCallBack(){
						public void onSuccess(Object arg){
							GWTResponse response = (GWTResponse)arg;
							if (response.getStatusCode().intValue() == 0)
							{
								if (getDialogBox() != null) {
									getDialogBox().hide();
								}
								Utils.hideWaiteDialog();
								ICMEntryPoint.currentState.modifyCategoryList(categoryList);
							}
							else
							{
								Utils.hideWaiteDialog();
								Utils.showErrorMessage(response.getStatusMessage());
							}
						}
						
						public void onFailure(Throwable arg){
							Utils.hideWaiteDialog();
							Utils.showErrorMessage(ICMEntryPoint.dictionary.get("CannotModifyCategoriesErrorMessage_HTML"));
						}
					});
					
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

		});

		int idx = 0;
		final List categoryList = ICMEntryPoint.currentState.getCategoryList(ICMEntryPoint.currentState.getCategory());
		for (final Iterator iterator = categoryList.iterator(); iterator.hasNext();) {
			final Category categoryItem = (Category) iterator.next();
			buildItem(categoryItem, idx);
			idx += 1;
		}

		// this.buttonPanel.add(new HTML("Hint: Drag-and-drop to reorder"));
		this.actionPanel.setWidth("100%");
		this.actionPanel.setStyleName("simpleDialog_actionPanel");
		tableExamplePanel.setSize("100%", "100%");
		tableExamplePanel.add(this.flexTable);
		this.actionPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		this.actionPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		this.actionPanel.add(this.newCategoryButton);
		this.layoutPanel.add(this.actionPanel);
		this.layoutPanel.add(new ScrollPanel(tableExamplePanel));
		this.dragController.registerDropController(new TableDropController(this.flexTable));
		initWidget(this.layoutPanel);
		// initWidget(this.layoutPanel);
	}

	void buildItem(final Category categoryItem, int idx) {
		final CategoryPanelItem categoryPanelItem = new CategoryPanelItem(categoryItem);
		// HTML categoryPanelItem = new HTML(categoryItem.getName());
		this.flexTable.setWidget(idx, 0, categoryPanelItem);
		this.dragController.makeDraggable(categoryPanelItem);
	}

	/**
	 * @return the actionPanel
	 */
	public HorizontalPanel getActionPanel() {
		return this.actionPanel;
	}

	/**
	 * @return the dialogBox
	 *            the dialogBox to set
	 */
	public SimpleDialog getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @return the header
	 */
	public String getHeader() {
		return this.header;
	}

	/**
	 * @return the saveChangesButton
	 */
	public CardActionButton getSaveChangesButton() {
		return this.saveChangesButton;
	}
	
	public DialogButton getCancelButton() {
		return this.cancelButton;
	} 

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox() {
		this.dialogBox = new SimpleDialog(this, false);
		setDialogBoxProperties();
	}
	
	public void setDialogBoxProperties() {
		dialogBox.setStyleName("simpleDialog_noBorder");
		dialogBox.setText(this.getHeader());
		dialogBox.getInnerPanel().setSpacing(0);
		dialogBox.getButtonPanel().insert(this.getSaveChangesButton(), 2);
		dialogBox.getButtonPanel().remove(1);
		//dialogBox.getButtonPanel().insert(this.newCategoryButton, 2);
		dialogBox.getButtonPanel().insert(this.getCancelButton(), 1);
	}
	
	public void showDialog() {
		dialogBox.showDialog();
	}
	
	public void hideDialog() {
		dialogBox.hide();
	}

	/**
	 * @param saveChangesButton
	 *            the saveChangesButton to set
	 */
	public void setSaveChangesButton(final CardActionButton saveChangesButton) {
		this.saveChangesButton = saveChangesButton;
	}
}
