/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd;

import org.eclipse.higgins.ics.gwt.icm.client.panel.category.CategoryPanelItem;

import com.allen_sauer.gwt.dragdrop.client.DragController;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class TableDragController extends DragController {

	private FlexTable draggableTable;
	private int dragRow;

	public TableDragController(final AbsolutePanel boundryPanel) {
		super(boundryPanel);
		setDragProxyEnabled(true);
	}

	private void copyRow(final FlexTable sourceTable, final FlexTable targetTable, final int sourceRow, final int targetRow) {
		try {
			targetTable.insertRow(targetRow);
			final Widget w = sourceTable.getWidget(sourceRow, 0);
			if (w != null) {
				final CategoryPanelItem categoryPanelItem = new CategoryPanelItem(((CategoryPanelItem) w).getCategory());
				categoryPanelItem.setStyleName("categoryItemDnDPanel");
				targetTable.setWidget(targetRow, 0, categoryPanelItem);
			}
		} catch (final Exception e) {
			// Window.alert("copyRow:" + e.getMessage());
		}
	}

	public void dragEnd(final Widget draggable, final Widget dropTarget) {
		super.dragEnd(draggable, dropTarget);
	}

	/**
	 * @return the draggableTable
	 */
	public FlexTable getDraggableTable() {
		return this.draggableTable;
	}

	/**
	 * @return the dragRow
	 */
	public int getDragRow() {
		return this.dragRow;
	}

	private int getWidgetRow(final CategoryPanelItem widget, final FlexTable table) {
		for (int row = 0; row < table.getRowCount(); row++) {
			final CategoryPanelItem w = (CategoryPanelItem) table.getWidget(row, 0);
			if (w.getCategory().getId() == widget.getCategory().getId()) {
				return row;
			}
		}
		throw new RuntimeException("Unable to determine widget row");
	}

	protected Widget newDraggableProxy(final Widget draggable) {
		final FlexTable proxy = new FlexTable();
		try {
			this.draggableTable = (FlexTable) draggable.getParent().getParent();
			this.dragRow = getWidgetRow((CategoryPanelItem) draggable.getParent(), this.draggableTable);
			copyRow(this.draggableTable, proxy, this.dragRow, 0);
		} catch (final Exception e) {
			// Window.alert(" new proxy" + e.getMessage());
		}
		return proxy;
	}

}
