/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko -  initial API and implementation
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.category.dnd;

import com.allen_sauer.gwt.dragdrop.client.DragController;
import com.allen_sauer.gwt.dragdrop.client.drop.AbstractPositioningDropController;
import com.allen_sauer.gwt.dragdrop.client.util.Location;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class TableDropController extends AbstractPositioningDropController {

	private final FlexTable flexTable;

	private int targetRow = 0;

	/**
	 * @param dropTarget
	 */
	public TableDropController(final FlexTable flexTable) {
		super(flexTable);
		this.flexTable = flexTable;
	}

	private int determineRow(final Widget reference) {
		final int refY = reference.getAbsoluteTop() + reference.getOffsetHeight() / 2;
		for (int row = this.flexTable.getRowCount() - 1; row >= 0; row--) {
			final Widget w = this.flexTable.getWidget(row, 0);
			final int y = w.getAbsoluteTop() + w.getOffsetHeight() / 2;
			if (y < refY) {
				return row;
			}
		}
		return -1;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.allen_sauer.gwt.dragdrop.client.drop.AbstractPositioningDropController#drop(com.google.gwt.user.client.ui.Widget,
	 *      int, int)
	 */
	public void drop(final Widget widget, final int left, final int top) {
		Window.alert("Drop start");
		super.drop(widget, left, top);

	}

	private void moveRow(final FlexTable sourceTable, final FlexTable targetTable, int sourceRow, final int targetRow) {
		try {
			if (sourceTable == targetTable && sourceRow >= targetRow) {
				sourceRow++;
			}
			// if (sourceTable == null)
			// Window.alert("sourceTable == null");
			// if (targetTable == null)
			// Window.alert("targetTable == null");
			targetTable.insertRow(targetRow);
			final Widget w = sourceTable.getWidget(sourceRow, 0);
			if (w != null) {
				targetTable.setWidget(targetRow, 0, w);
				// } else {
				// Window.alert("Widget is null");
			}
			sourceTable.removeRow(sourceRow);
		} catch (final Exception e) {
			// Window.alert("moveRow" + e.getMessage());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.allen_sauer.gwt.dragdrop.client.drop.AbstractPositioningDropController#newPositioner(com.google.gwt.user.client.ui.Widget)
	 */
	protected Widget newPositioner(final Widget reference) {
		final Widget p = new SimplePanel();
		p.addStyleName("dragdrop-dropTarget-engage");
		p.setPixelSize(this.flexTable.getOffsetWidth(), 3);
		return p;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.allen_sauer.gwt.dragdrop.client.drop.AbstractPositioningDropController#onDrop(com.google.gwt.user.client.ui.Widget,
	 *      com.google.gwt.user.client.ui.Widget, com.allen_sauer.gwt.dragdrop.client.DragController)
	 */
	public void onDrop(final Widget reference, final Widget draggable, final DragController dragController) {
		super.onDrop(reference, draggable, dragController);
		final TableDragController trDragController = (TableDragController) dragController;
		moveRow(trDragController.getDraggableTable(), this.flexTable, trDragController.getDragRow(), this.targetRow + 1);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.allen_sauer.gwt.dragdrop.client.drop.AbstractDropController#onMove(com.google.gwt.user.client.ui.Widget,
	 *      com.google.gwt.user.client.ui.Widget, com.allen_sauer.gwt.dragdrop.client.DragController)
	 */
	public void onMove(final Widget reference, final Widget draggable, final DragController dragController) {
		// TODO Auto-generated method stub
		super.onMove(reference, draggable, dragController);
		this.targetRow = determineRow(reference);
		final Widget w = this.flexTable.getWidget(this.targetRow == -1 ? 0 : this.targetRow, 0);
		final Location widgetLocation = new Location(w, dragController.getBoundryPanel());
		final Location tableLocation = new Location(this.flexTable, dragController.getBoundryPanel());
		dragController.getBoundryPanel().add(getPositioner(), tableLocation.getLeft(),
				widgetLocation.getTop() + (this.targetRow == -1 ? 0 : w.getOffsetHeight()));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.allen_sauer.gwt.dragdrop.client.drop.DropController#onPreviewDrop(com.google.gwt.user.client.ui.Widget,
	 *      com.google.gwt.user.client.ui.Widget, com.allen_sauer.gwt.dragdrop.client.DragController)
	 */
	public boolean onPreviewDrop(final Widget reference, final Widget draggable, final DragController dragController) {
		return true;
	}

}
