/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.edit;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.editor.ImageEditor;
import org.eclipse.higgins.ics.gwt.base.client.editor.TextBoxEditor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CardEditablePanel extends Composite {

	private final Label labelCardImage = new Label();
	private final ImageEditor cardImage = new ImageEditor();
	private final Label labelCardName = new Label();
	private final TextBoxEditor cardName = new TextBoxEditor();
	private final FlexTable bodyTable = new FlexTable();
	private ClickListener saveChangesListener;
	private CardActionButton saveChangesButton;
	private DialogBox dialogBox;

	final Card card;
	protected int dimRowTable = 3;

	/**
	 * 
	 */
	public CardEditablePanel(Card pcard) {
		this.card = pcard;

		getBodyTable().setWidth("100%");
		getBodyTable().setWidget(0, 0, buildGroupPanel(ICMEntryPoint.dictionary.get("Level0ClaimTitle_HTML")));
		getBodyTable().getFlexCellFormatter().setColSpan(0, 0, 2);

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
		getLabelCardName().setStyleName("cardPanel_claim_label");
		getLabelCardName().setText(ICMEntryPoint.dictionary.get("CardNameLabel_HTML"));

		getBodyTable().setWidget(1, 0, getLabelCardName());

		getCardName().setValue(getCard().getName());
		getCardName().setName(ICMEntryPoint.dictionary.get("CardNameLabel_HTML"));
		getCardName().setInputRegExp("^\\w");
		getCardName().setCheckValueRunTime(true);

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(1, 1, HasHorizontalAlignment.ALIGN_LEFT);
		getBodyTable().setWidget(1, 1, getCardName());

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(2, 0, HasHorizontalAlignment.ALIGN_RIGHT);
		getLabelCardImage().setStyleName("cardPanel_claim_label");
		getBodyTable().setWidget(2, 0, getLabelCardImage());

		getCardImage().setValue(getCard().getImage());
		getCardImage().setName(ICMEntryPoint.dictionary.get("CardImageLabel_HTML"));
		getCardImage().setChildWidth(getCard().getSelfIssued().booleanValue() ? "80" : "120");
		getCardImage().setChildHeight("80");

		getBodyTable().getFlexCellFormatter().setHorizontalAlignment(2, 1, HasHorizontalAlignment.ALIGN_LEFT);
		getBodyTable().setWidget(2, 1, getCardImage());

		initWidget(getBodyTable());
	}

	/**
	 * @return the card
	 */
	public Card getCard() {
		return this.card;
	}

	/**
	 * @return the bodyTable
	 */
	public FlexTable getBodyTable() {
		return this.bodyTable;
	}

	/**
	 * @return the labelCardImage
	 */
	public Label getLabelCardImage() {
		return this.labelCardImage;
	}

	/**
	 * @return the cardImage
	 */
	public ImageEditor getCardImage() {
		return this.cardImage;
	}

	/**
	 * @return the labelCardName
	 */
	public Label getLabelCardName() {
		return this.labelCardName;
	}

	/**
	 * @return the cardName
	 */
	public TextBoxEditor getCardName() {
		return this.cardName;
	}

	/**
	 * @return the saveChangesListener
	 */
	public ClickListener getSaveChangesListener() {
		return this.saveChangesListener;
	}

	/**
	 * @param saveChangesListener
	 *            the saveChangesListener to set
	 */
	public void setSaveChangesListener(ClickListener saveChangesListener) {
		this.saveChangesListener = saveChangesListener;
	}

	/**
	 * @return the dialogBox
	 */
	public DialogBox getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox(DialogBox dialogBox) {
		this.dialogBox = dialogBox;
	}

	/**
	 * @return the saveChangesButton
	 */
	public CardActionButton getSaveChangesButton() {
		return this.saveChangesButton;
	}

	/**
	 * @param saveChangesButton
	 *            the saveChangesButton to set
	 */
	public void setSaveChangesButton(CardActionButton saveChangesButton) {
		this.saveChangesButton = saveChangesButton;
	}

	public static HorizontalPanel buildGroupPanel(String name) {
		HorizontalPanel groupPanel = new HorizontalPanel();
		groupPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		groupPanel.setSpacing(5);
		groupPanel.setWidth("100%");
		Label nameLabel = new Label(name, false);
		// replaceAll(" ","&nbsp;")
		nameLabel.setStyleName("groupClaim_label");

		Image separator = new Image(Utils.getContextPath() + ICMEntryPoint.constant.uriImgBgHeaderOverlayForm());
		separator.setHeight("1px");
		separator.setWidth("100%");

		groupPanel.add(nameLabel);
		groupPanel.add(separator);
		groupPanel.setCellWidth(separator, "100%");
		return groupPanel;
	}

}