package org.eclipse.higgins.ics.gwt.icm.client.panel.history;

import java.util.ArrayList;

import org.eclipse.higgins.ics.gwt.base.client.button.DisabledNavigationButton;
import org.eclipse.higgins.ics.gwt.base.client.button.NavigationButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.button.TableHeaderSortButton;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardInformation;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUsage;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class CardHistoryPanel extends Composite {

	private static HTMLTable fTable = new FlexTable();

	private static final FlexTable header = new FlexTable();

	private static final CardHistoryPanelFooter footer = new CardHistoryPanelFooter();

	private final VerticalPanel bodyPanel = new VerticalPanel();
	
	private static final ScrollPanel tablePanel = new ScrollPanel();
	
	private int pageSize = 12;
	
	private int pageNumber = 0;
	
	private int pageCount = 0;
	
	private int sortSiteDir = 0;
	
	private int sortDateDir = 1;

	private final Label descriptionLabel = new Label(
			ICMEntryPoint.dictionary.get("HistoryDescriptionLabel_HTML"));
	
	private final TableHeaderSortButton sortBySiteButton = new TableHeaderSortButton(ICMEntryPoint.dictionary
			.get("HistorySitesTableUrlColumnTitle_HTML"), new ClickListener(){
		public void onClick(Widget arg){
			CardUsage[] usages = sortBySite(footer.getCard().getCardInformation().getCardHistory(), sortSiteDir>=0);
			Card tmpCard = footer.getCard();
			tmpCard.getCardInformation().setCardHistory(usages);
			ICMEntryPoint.currentState.modifyCardInCategory(tmpCard,ICMEntryPoint.currentState.getCategory());
			sortSiteDir = sortSiteDir>=0?-1:1;
			sortDateDir = 0;
			drawTable(usages, 0);
			
		}
	});
	
	private final TableHeaderSortButton sortByDateButton = new TableHeaderSortButton(ICMEntryPoint.dictionary
			.get("HistorySitesTableUpdatedColumnTitle_HTML"), new ClickListener(){
		public void onClick(Widget arg){
			CardUsage[] usages = sortByDate(footer.getCard().getCardInformation().getCardHistory(), sortDateDir>=0);
			Card tmpCard = footer.getCard();
			tmpCard.getCardInformation().setCardHistory(usages);
			ICMEntryPoint.currentState
					.modifyCardInCategory(tmpCard,
							ICMEntryPoint.currentState
									.getCategory());
			sortDateDir = sortDateDir>=0?-1:1;
			sortSiteDir = 0;
			drawTable(usages, 0);
			
		}
	});

	private final ChangeSelectedCardListener selectedCardListener = new ChangeSelectedCardListener() {
		public void onChangeSelectedCard(final Card card,
				final Category category) {
			footer.setCard(card);
		}
	};
	
	/*private ClickListener nextPageButtonListener = new ClickListener(){
		public void onClick(Widget arg)
		{
			drawTable(footer.getCard().getCardInformation().getCardHistory(), pageNumber++);
		}
	};*/

	public CardHistoryPanel(Card card) {
		bodyPanel.setHeight("100%");
		bodyPanel.setWidth("100%");
		bodyPanel.setSpacing(10);
		bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
		fTable.setCellSpacing(0);
		header.setCellSpacing(0);
		fTable.setWidth("100%");
		//fTable.setWidget(0, 2, new Label(ICMEntryPoint.dictionary.get("HistorySitesTableSelectColumnTitle_HTML")));
		fTable.setStyleName("cardDetailContent");
		bodyPanel.add(descriptionLabel);
		descriptionLabel.setSize("100%", "100%");
		/*bodyPanel.add(header);
		bodyPanel.add(tablePanel);
		tablePanel.setSize("100%", "100%");
		*/
		//bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		footer.setCard(card);
		ICMEntryPoint.currentState.addChangeSelectedCardListener(this.selectedCardListener);
		setMainTable();
		initWidget(bodyPanel);		
		
		//footer.setDeleteSelectedUrlsButtonListener();
	}

	private void setMainTable() {
		if (footer.getCard() != null) {
			bodyPanel.clear();
			if (footer.getCard().getCardInformation() == null) {
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("HistoryLoadingWaitLabel_HTML"));
				ICMEntryPoint.service.getCardInformation(footer.getCard().getCuid(),
						ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(), pageSize,
						new AsyncCallback() {
							public void onFailure(Throwable arg0) {
								Utils.hideWaiteDialog();
/*								bodyPanel.remove(wait);
								bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
								bodyPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);*/
								Utils.showErrorMessage("ERROR - Cannot get card info");
							};

							public void onSuccess(Object arg) {
								/*bodyPanel.remove(wait);
								bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
								bodyPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);*/
								Card tmpCard = footer.getCard();

								tmpCard.setCardInformation(((CardInformation) ((GWTResponse) arg)
												.getResult()));
								footer.setCard(tmpCard);
								ICMEntryPoint.currentState
										.modifyCardInCategory(tmpCard,
												ICMEntryPoint.currentState
														.getCategory());
								CardUsage[] usages = (((CardInformation) ((GWTResponse) arg)
										.getResult())).getCardHistory();
								drawTable(usages, pageNumber);
								Utils.hideWaiteDialog();
							};
						});
			} else {
				CardUsage[] usages = footer.getCard().getCardInformation().getCardHistory();
				drawTable(usages, pageNumber);
			}

		}
	}
	
	

	public Widget getCardHistoryWidget() {
		return this;
	}

	private static String getDomainFromUrl(String url) {
		return url.substring(url.indexOf("://") + 3, url.indexOf("/", url
				.indexOf("://") + 3));
	}

	private static String getDomainLinkFromUrl(String url) {
		return "<A HREF=\"" + url + "\">" + getDomainFromUrl(url) + "</A>";
	}
	
	private static String getUrlFromDomainLink(String link)
	{
		String url = link.substring(link.indexOf("HREF=\"")+10, link.indexOf("\">", link.indexOf(link.indexOf("HREF=\"")+10)));
		return url;
	}

	private void drawTable(CardUsage[] usages, int pageNumber) {
		if (usages != null) {
			this.pageNumber = pageNumber;
			this.pageCount = (usages.length - ((usages.length) % pageSize))/pageSize;			
			try {
				//tablePanel.remove(fTable);
				bodyPanel.clear();
				fTable.clear();
				bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
				bodyPanel.add(descriptionLabel);
				descriptionLabel.setSize("100%", "100%");
				//bodyPanel.add(header);
				bodyPanel.add(tablePanel);
				HorizontalPanel siteLabel = new HorizontalPanel();
				siteLabel.add(sortBySiteButton);
				siteLabel.setSpacing(3);
				siteLabel.setWidth("100%");
				siteLabel.setStyleName("tableHistoryHeader");
				//siteLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
				if (sortSiteDir>0)siteLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinOpen()));
				if (sortSiteDir<0)siteLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinUp()));
				
				HorizontalPanel dateLabel = new HorizontalPanel();
				dateLabel.add(sortByDateButton);
				dateLabel.setSpacing(3);
				dateLabel.setWidth("90px");
				dateLabel.setStyleName("tableHistoryHeader");
				//dateLabel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);				
				if (sortDateDir>0)dateLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinOpen()));
				if (sortDateDir<0)dateLabel.add(new Image(ICMEntryPoint.constant.uriImgMenuSpinUp()));
				
				final Label useLabel = new Label(ICMEntryPoint.dictionary.get("HistorySitesTableUseEveryTimeColumnTitle_HTML"));
				useLabel.setWidth("90px");
				useLabel.setStyleName("tableHistoryHeader");
				fTable.setWidget(0, 0, siteLabel);
				fTable.setWidget(0, 1, dateLabel);
				fTable.setWidget(0, 2, useLabel);
				//fTable.getColumnFormatter().setWidth(1, "200px");
				//fTable.getColumnFormatter().setWidth(2, "200px");
				header.getColumnFormatter().setWidth(0, "100%");
				fTable.getColumnFormatter().setWidth(0, "100%");
				int col = 0;
				int begin = pageNumber*pageSize;
				int end = (pageNumber*pageSize)+pageSize;
				if (end > usages.length) end = usages.length;
				for (int i = begin; i < end; i++) {
					
					HTML siteUrl = new HTML(
							getDomainLinkFromUrl(usages[i].getSite()));
					siteUrl.addStyleName("siteURL");
					final Label dateL = new Label(usages[i].getDate());
					dateL.setWidth("90px");
					fTable.setWidget(col + 1, 0, siteUrl);
					fTable.setWidget(col + 1, 1, dateL);
					siteUrl.setStyleName("tableHistory");
					dateL.setStyleName("tableHistory");
					if (usages[i].isSaved()) {
						final int ii = i;
						SimpleButton noUseButton = new SimpleButton(ICMEntryPoint.dictionary.get("ForgetCardForSiteButton_HTML"), new ClickListener() {
						public void onClick(Widget arg0) {
								String[] s = new String[1];
								s[0] = footer.getCard().getCardInformation().getCardHistory()[ii].getSite();
								Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("HistoryModifyingLabel_HTML"));
								ICMEntryPoint.service.deleteUrlsCardRelation(ICMEntryPoint
										.getUserProfile().getLoginName(), ICMEntryPoint
										.getUserProfile().getPassword(), footer.getCard()
										.getCuid(), s, new AsyncCallback() {
									public void onSuccess(Object arg) {
										Utils.hideWaiteDialog();
										Card tmpCard = footer.getCard();

										/*tmpCard.setCardInformation(((CardInformation) ((GWTResponse) arg)
														.getResult()));*/
										ICMEntryPoint.currentState
												.modifySelectedCard(tmpCard);
										((FlexTable)fTable).removeCell(ii, 2);
									}

									public void onFailure(Throwable arg) {
										Utils.hideWaiteDialog();
										Utils.showErrorMessage("ERROR - Cannot delete card info");
									}
								});
						}
					});
					noUseButton.setWidth("90px");
					fTable.setWidget(col + 1, 2, noUseButton);
					} else {
						final Label dummy = new Label();
						dummy.setWidth("90px");
						dummy.setStyleName("tableHistory");
						fTable.setWidget(col + 1, 2, dummy);
					}
					fTable.getRowFormatter().addStyleName(col + 1,"tableHistory");
					col++;
					
				}
				header.getRowFormatter().addStyleName(0,"tableHistoryHeader");
				
				//tablePanel.add(fTable);
				
				footer.setPageLabel(this.pageNumber, this.pageCount);
				if (begin == 0) footer.setPreviousPageButton(new DisabledNavigationButton(ICMEntryPoint.dictionary.get("HistoryPreviousPageButton_HTML"), null, "left"));
				else footer.setPreviousPageButton(new NavigationButton(ICMEntryPoint.dictionary.get("HistoryPreviousPageButton_HTML"), new ClickListener(){
					public void onClick(Widget arg)
					{
						drawTable(footer.getCard().getCardInformation().getCardHistory(), getPageNumber()-1);
					}
				}, "left"));
				if (end == usages.length) footer.setNextPageButton(new DisabledNavigationButton(ICMEntryPoint.dictionary.get("HistoryNextPageButton_HTML"), null, "right"));
				else footer.setNextPageButton(new NavigationButton(ICMEntryPoint.dictionary.get("HistoryNextPageButton_HTML"), new ClickListener(){
					public void onClick(Widget arg)
					{
						drawTable(footer.getCard().getCardInformation().getCardHistory(), getPageNumber()+1);
					}
				}, "right"));
				//bodyPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
				//bodyPanel.add(footer);
			} catch (Exception e) {
				
			}
		}
		else {
			bodyPanel.add(new Label("Card history for this card is empty"));
		}
	}
	
	public static String[] getSelectedUrls()
	{
		String[] uurls = new String[0];
		CardUsage[] usages = footer.getCard().getCardInformation().getCardHistory();
		if (fTable.getRowCount() > 1) {
			
			ArrayList urls = new ArrayList(0);
			for (int i = 0; i < fTable.getRowCount() - 1; i++) {
				if (((CheckBox) fTable.getWidget(i + 1, 2)).isChecked())
					//urls.add(getUrlFromDomainLink(((HTML)fTable.getWidget(i + 1, 0)).getHTML()));
					urls.add(usages[i].getSite());
					
			}
			uurls = new String[urls.size()];
			for (int i = 0; i < urls.size(); i++)
				uurls[i] = (String)urls.get(i);
				
		}
		return uurls;
		
	}
	
	public int getPageNumber()
	{
		return this.pageNumber;
	}
	
	private CardUsage[] sortBySite(CardUsage[] usages, boolean sortUp)
	{
		for (int i=0; i< usages.length; i++)
		{
			for (int j=0; j< usages.length; j++)
			{
				int compare = usages[i].getSite().toLowerCase().compareTo(
						usages[j].getSite().toLowerCase());
				if (compare<0 && sortUp)
				{
					CardUsage u = usages[i];
					usages[i] = usages[j];
					usages[j] = u;
				}
				if (compare>0 && !sortUp)
				{
					CardUsage u = usages[j];
					usages[j] = usages[i];
					usages[i] = u;
				}
			}
		}
		return usages;
	}
	
	
	private CardUsage[] sortByDate(CardUsage[] usages, boolean sortUp)
	{
		for (int i=0; i< usages.length; i++)
		{
			for (int j=0; j< usages.length; j++)
			{
				int compare = usages[i].getDate().toLowerCase().compareTo(
						usages[j].getDate().toLowerCase());
				if (compare<0 && sortUp)
				{
					CardUsage u = usages[i];
					usages[i] = usages[j];
					usages[j] = u;
				}
				if (compare>0 && !sortUp)
				{
					CardUsage u = usages[j];
					usages[j] = usages[i];
					usages[i] = u;
				}
			}
		}
		return usages;
	}
	
	public CardHistoryPanelFooter getCardHistoryFooter() {
		return footer;
	}	
}
