package org.eclipse.higgins.ics.gwt.icm.client.panel.history;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.button.DisabledNavigationButton;
import org.eclipse.higgins.ics.gwt.base.client.button.SimpleButton;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUsage;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;

public class CardHistoryPanelFooter extends HorizontalPanel {
	
	private SimpleButton previousPageButton = new DisabledNavigationButton(ICMEntryPoint.dictionary.get("HistoryPreviousPageButton_HTML"), null, "left");
	private SimpleButton nextPageButton = new DisabledNavigationButton(ICMEntryPoint.dictionary.get("HistoryPreviousPageButton_HTML"), null, "right");
	private HTML pageCountLabel = new HTML();
	private Card card;
	private CardActionButton clearHistoryButton;
	private static final HorizontalPanel pageActionPanel = new HorizontalPanel();
	private static final HorizontalPanel urlActionPanel = new HorizontalPanel();
	
	private static final String STYLE_CARD_PANEL_FOOTER = "cardPanel_footer";
	private static final String STYLE_CARD_PANEL_FOOTER_LABEL = "cardPanel_footer_label";
	
	public CardHistoryPanelFooter(){
		clearHistoryButton = new CardActionButton(ICMEntryPoint.dictionary.get("ClearHistoryButton_HTML"), new ClickListener(){
			public void onClick(Widget arg){
				CardActionButton actionButton = new CardActionButton(ICMEntryPoint.dictionary.get("ClearButton_HTML"), new ClickListener() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
					 */
					public void onClick(Widget arg0) {
						Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("HistoryDeletingLabel_HTML"));
						ICMEntryPoint.service.clearCardHistory(ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
								.getUserProfile().getPassword(),getCard().getCuid(), new GWTCallBack() {
							/*
							 * (non-Javadoc)
							 * 
							 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
							 */
							public void onSuccess(Object res) {
								Utils.hideWaiteDialog();
								if (res instanceof GWTResponse) {
									if (((GWTResponse) res).getStatusCode().equals(new Integer(0))) {
										Card tmpCard = card;

										tmpCard.getCardInformation().setCardHistory(null);
										ICMEntryPoint.currentState
												.modifySelectedCard(tmpCard);
									} else {
										Utils.showErrorMessage(((GWTResponse) res).getStatusMessage());
									}
								}
							}

						});
					}

				});
				Utils.showConfirmDialog(ICMEntryPoint.dictionary.get("DeleteHistoryWarningMessageTitle_HTML"),
						ICMEntryPoint.dictionary.get("DeleteHistoryWarningMessageBody_HTML"), actionButton);
			}
		});
		clear();
		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		setSpacing(10);
		setStyleName(STYLE_CARD_PANEL_FOOTER);
		super.setHeight("48px");
		setWidth("100%");
		//setHeight("25px");
		pageActionPanel.setSpacing(4);
		pageActionPanel.add(previousPageButton);
		pageActionPanel.add(nextPageButton);
		urlActionPanel.add(clearHistoryButton);
		urlActionPanel.setSpacing(4);
		pageCountLabel.setStyleName(STYLE_CARD_PANEL_FOOTER_LABEL);
		pageCountLabel.setWidth("50px");
		add(pageCountLabel);
		add(pageActionPanel);
		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		add(urlActionPanel);		
	}
	
	public Card getCard()
	{
		return this.card;
	}
	
	public void setCard(Card card)
	{
		this.card = card;
	}
	
	public HorizontalPanel getUrlActionPanel() {
		return urlActionPanel;
	}
	
	public void reset() {
		pageCountLabel.setHTML("");
		setPreviousPageButton(previousPageButton);
		setNextPageButton(nextPageButton);
	}	
	
	public void setPreviousPageButton(SimpleButton button)
	{
		//this.previousPageButton = button;
		pageActionPanel.remove(0);
		pageActionPanel.insert(button, 0);
	}
	
	public void setNextPageButton(SimpleButton button)
	{
		//this.nextPageButton = button;
		pageActionPanel.remove(1);
		pageActionPanel.insert(button, 1);
	}
	
	public void setPageLabel(int pageNumber, int pageCount)
	{
		this.pageCountLabel.setHTML("<b>"+ICMEntryPoint.dictionary.get("HistoryPaginationLabel1_HTML")+ (pageNumber+1) +ICMEntryPoint.dictionary.get("HistoryPaginationLabel2_HTML")+ (pageCount+1)+"</b>");
		this.pageCountLabel.setWidth("100%");
	}
	
	
}
