/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.profile;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor;
import org.eclipse.higgins.ics.gwt.base.client.editor.TextBoxEditor;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeUserProfileListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.HTTPRequest;
import com.google.gwt.user.client.ResponseTextHandler;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class UserProfilePanel extends Composite {

	private final FlexTable flexTable = new FlexTable();
	private final CardActionButton saveButton;
	private SimpleDialog dialog;
	final HTML detailInformation = new HTML();

	/**
	 * 
	 */
	public UserProfilePanel() {
		HTTPRequest.asyncGet(Utils.baseConstant.ip2LocationServiceAddress(), new ResponseTextHandler() {
			public void onCompletion(final String response) {
				UserProfilePanel.this.detailInformation.setHTML(response);
			}
		});

		this.saveButton = new CardActionButton(ICMEntryPoint.dictionary.get(ICMEntryPoint.constant.dnSaveButtonText()),
				new ClickListener() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
					 */
					public void onClick(final Widget arg0) {
						if (check()) {
							hide();
							Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
							try {
								final UserProfile newUserProfile = Utils.cloneUserProfile(ICMEntryPoint.getUserProfile());
								newUserProfile.setFirstName(getFields(1).getValue());
								newUserProfile.setLastName(getFields(2).getValue());
								newUserProfile.setEmail(getFields(3).getValue());
								ICMEntryPoint.service.modifyUserProfile(newUserProfile, new GWTCallBack() {

									/*
									 * (non-Javadoc)
									 * 
									 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
									 */
									public void onFailure(final Throwable arg0) {
										Utils.hideWaiteDialog();
										Utils.showErrorMessage(arg0.getMessage());
									}

									/*
									 * (non-Javadoc)
									 * 
									 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
									 */
									public void onSuccess(final Object res) {
										Utils.hideWaiteDialog();
										if (res instanceof GWTResponse) {
											final GWTResponse gwtResponse = (GWTResponse) res;
											if (gwtResponse.getStatusCode().equals(new Integer(0))) {
												ICMEntryPoint.setUserProfile(Utils.cloneUserProfile((UserProfile) gwtResponse.getResult()));
											} else {
												Utils.showErrorMessage(gwtResponse.getStatusMessage());
											}
										} else {
											Utils.showErrorMessage("<b>Server side error!</b>");
										}
									}

								});
							} catch (final Exception e) {
							}

						}
					}

				});

		this.flexTable.setWidth("100%");
		addFields(ICMEntryPoint.dictionary.get("UserNameLabel_HTML"), ICMEntryPoint.getUserProfile().getLoginName(), true, false, null, 0);
		addFields(ICMEntryPoint.dictionary.get("FirstNameLabel_HTML"), ICMEntryPoint.getUserProfile().getFirstName(), false, true, "^\\w+",
				1);
		addFields(ICMEntryPoint.dictionary.get("LastNameLabel_HTML"), ICMEntryPoint.getUserProfile().getLastName(), false, true, "^\\w+", 2);
		addFields(ICMEntryPoint.dictionary.get("EmailLabel_HTML"), ICMEntryPoint.getUserProfile().getEmail(), false, true,
				"^\\w+\\S*@\\S+\\.[a-zA-Z]+$", 3);
		addFields(ICMEntryPoint.dictionary.get("CreatedLabel_HTML"), ICMEntryPoint.getUserProfile().getCreated() != null ? ICMEntryPoint
				.getUserProfile().getCreated().toString() : "", true, false, null, 4);
		addFields(ICMEntryPoint.dictionary.get("ModifiedLabel_HTML"), ICMEntryPoint.getUserProfile().getModified() != null ? ICMEntryPoint
				.getUserProfile().getModified().toString() : "", true, false, null, 5);

		addNonTextFields(ICMEntryPoint.dictionary.get("CurrentLocationLabel_HTML"), this.detailInformation, 6);
		// addFields("Used from", ICMEntryPoint.userProfile.getUsedFrom(), true, 6);
		ICMEntryPoint.addChangeUserProfileList(new ChangeUserProfileListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.higgins.ics.gwt.base.client.listener.ChangeUserProfileListener#onChangeUserProfile(org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile)
			 */
			public void onChangeUserProfile(final UserProfile userProfile) {
				getFields(0).setValue(userProfile.getLoginName());
				getFields(1).setValue(userProfile.getFirstName());
				getFields(2).setValue(userProfile.getLastName());
				getFields(3).setValue(userProfile.getEmail());
				getFields(5).setValue(userProfile.getModified() != null ? userProfile.getModified().toString() : "");
			}
		});
		initWidget(this.flexTable);
	}

	/**
	 * @param name
	 * @param value
	 * @param readonly
	 * @param isRequired
	 * @param pattern
	 * @param idx
	 */
	public void addFields(final String name, final String value, final boolean readonly, final boolean isRequired, final String pattern,
			final int idx) {
		this.flexTable.getFlexCellFormatter().setHorizontalAlignment(idx, 0, HasHorizontalAlignment.ALIGN_RIGHT);
		this.flexTable.getFlexCellFormatter().setHorizontalAlignment(idx, 1, HasHorizontalAlignment.ALIGN_LEFT);
		// final Label label = new Label(name + (isRequired?" * :":" : "));
		final Label label = new Label(name + " : ");
		label.setStyleName("userProfilePanel_label");
		this.flexTable.setWidget(idx, 0, label);
		final TextBoxEditor textBoxEditor = new TextBoxEditor();
		textBoxEditor.setName(name);
		textBoxEditor.setValue(value);
		textBoxEditor.setReadOnly(readonly);
		textBoxEditor.setRequired(isRequired);
		textBoxEditor.setInputRegExp(pattern);
		textBoxEditor.setCheckValueRunTime(textBoxEditor.getInputRegExp() != null);
		this.flexTable.setWidget(idx, 1, textBoxEditor);
	}

	/**
	 * @param name
	 * @param value
	 * @param readonly
	 * @param isRequired
	 * @param pattern
	 * @param idx
	 */
	public void addNonTextFields(final String name, final Widget value, final int idx) {
		this.flexTable.getFlexCellFormatter().setHorizontalAlignment(idx, 0, HasHorizontalAlignment.ALIGN_LEFT);
		this.flexTable.setWidget(idx, 0, value);
		this.flexTable.getFlexCellFormatter().setColSpan(idx, 0, 2);
	}

	boolean check() {
		boolean res = true;
		String errorMessage = "";

		if (!getFields(1).checkValue()) {
			errorMessage = ICMEntryPoint.dictionary.get("FillInFirstNameErrorLabel_HTML");
			res = false;
		}

		if (!getFields(2).checkValue()) {
			errorMessage += ICMEntryPoint.dictionary.get("FillInLastNameErrorLabel_HTML");
			res = false;
		}

		if (!res) {
			Utils.showErrorMessage("<h3> " + errorMessage + "</h3>");
		}
		return res;
	}

	public BaseEditor getFields(final int idx) {
		return (TextBoxEditor) this.flexTable.getWidget(idx, 1);
	}

	/**
	 * @return the saveButton
	 */
	public CardActionButton getSaveButton() {
		return this.saveButton;
	}

	public void hide() {
		this.dialog.hide();
	}

	public void setFocus() {
		((TextBoxEditor) this.flexTable.getWidget(1, 1)).setFocus(true);

	}

	public void show() {
		this.dialog = new SimpleDialog(this);
		this.dialog.getCancelButton().getText().setHTML(ICMEntryPoint.dictionary.get("ClosePopupButton_HTML"));
		this.dialog.getButtonPanel().insert(getSaveButton(), 2);
		this.dialog.setText(ICMEntryPoint.dictionary.get("EditAccountSettingsTitle_HTML"));
		this.dialog.showDialog();
	}
}
