/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.button.NewButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.listener.AddCardListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.AddCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCardListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifyCategoryListListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifyCategoryListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.ModifySelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.listener.RemoveCardListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.panel.RoundedPanel;
import org.eclipse.higgins.ics.gwt.base.client.util.CategoryComparator;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.panel.NewCardPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ImageBundle;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeImages;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.TreeListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CategoryTree extends Composite implements TreeListener {

	private final VerticalPanel layoutPanel = new VerticalPanel();
	private final HorizontalPanel headerPanel = new HorizontalPanel();

	interface CategoryTreeImages extends TreeImages {

		/**
		 * @gwt.resource images/spin_open.gif
		 */
		AbstractImagePrototype treeOpen();

		/**
		 * @gwt.resource images/spin_closed.gif
		 */
		AbstractImagePrototype treeClosed();
	}
	
	interface CardTypeImages extends ImageBundle {
		
		/**
		 * @gwt.resource images/icon_lock.gif
		 */
		AbstractImagePrototype LockIcon();
		
		/**
		 * @gwt.resource images/icon_card_persona.gif
		 */
		AbstractImagePrototype PCardIcon();
		
		/**
		 * @gwt.resource images/icon_card_website.gif
		 */
		AbstractImagePrototype MCardIcon();
		
		/**
		 * @gwt.resource images/icon_card_persona_hover.gif
		 */
		AbstractImagePrototype PCardIconHover();
		
		/**
		 * @gwt.resource images/icon_card_website_hover.gif
		 */
		AbstractImagePrototype MCardIconHover();
	}
	
	private ModifySelectedCardListener modifySelectedCardListener = new ModifySelectedCardListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.ModifySelectedCardListener#onModifySelectedCard(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card)
		 */
		public void onModifySelectedCard(Card card) {
			for (int i = 0; i < tree.getItemCount(); i++) {
				modifyTreeItem(card, tree.getItem(i));
			}
		}
	};

	private ModifyCategoryListener modifyCategoryListener = new ModifyCategoryListener() {
		public void onModifyCategory(Category category) {
			if (category != null && category.getId() != null) {
				for (int i = 0; i < getTree().getItemCount(); i++) {
					if (getTree().getItem(i).getUserObject() instanceof Category) {
						Category categoryItem = (Category) getTree().getItem(i).getUserObject();
						if (categoryItem.getId().equals(category.getId())) {
							try {
								((HTML) ((HorizontalPanel) getTree().getItem(i).getWidget()).getWidget(0)).setHTML(category.getName());
								getTree().getItem(i).setUserObject(category);
							} catch (Exception e) {
							}
						}
					}

				}
			}
		}
	};

	private AddCategoryListener addCategoryListener = new AddCategoryListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.AddCategoryListener#onAddCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onAddCategory(Category category) {
			getTree().addItem(buildTree(category));
		}
	};
	
	private ModifyCategoryListListener modifyCategoryListListener = new ModifyCategoryListListener()
	{
		public void onModifyCategoryList(List list)
		{
			tree.clear();
			buildAllTree(list);
		}
	};
	private DeleteCardListener deleteCardListener = new DeleteCardListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCardListener#onDeleteCardListener(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
		 *      org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onDeleteCardListener(Card card, Category category) {
			deleteCard(card);
		}
	};

	private DeleteCategoryListener deleteCategoryListener = new DeleteCategoryListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCategoryListener#onDeleteCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onDeleteCategory(Category category) {
			for (int i = 0; i < getTree().getItemCount(); i++) {
				if (getTree().getItem(i).getUserObject() instanceof Category) {
					Category categoryItem = (Category) getTree().getItem(i).getUserObject();
					if (categoryItem.getId().equals(category.getId())) {
						getTree().removeItem(getTree().getItem(i));
					}
				}
			}
		}
	};

	private RemoveCardListener removeCardListener = new RemoveCardListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.DeleteCardListener#onDeleteCardListener(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
		 *      org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onRemoveCard(Card card, Category category) {
			for (int i = 0; i < tree.getItemCount(); i++) {
				removeCard(card, tree.getItem(i));
			}
			modifyCategoryItem(category);
		}
	};

	private AddCardListener addCardListener = new AddCardListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.AddCardListener#onAddCard(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
		 *      org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onAddCard(Card card, Category category) {
			addNewCard(card, category);
			modifyCategoryItem(category);			
		}

	};

	private static TreeImages images;

	private static final CardTypeImages cardImages = (CardTypeImages) GWT.create(CardTypeImages.class);

	public static Tree tree;
	static {
		images = (TreeImages) GWT.create(CategoryTreeImages.class);
		tree = new Tree(images) {
			public void setFocus(boolean inFocus) {
			}
		};
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.UIObject#setPixelSize(int, int)
	 */
	public void setPixelSize(int width, int height) {
		layoutPanel.setPixelSize(width, height);

		tree.setPixelSize(width - 20, height - 50);

		// tree.setPixelSize(width - 10, height - this.headerPanel.getOffsetHeight:-10);

	}

	/**
	 * 
	 */
	public CategoryTree() {
		this.tree.addTreeListener(this);
		buildAllTree(ICMEntryPoint.currentState.getCategory().getChildList());

		this.tree.setSize("100%", "100%");

		this.headerPanel.setStyleName("categoryTree_header");
		this.headerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.headerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		Label mycards = new Label(ICMEntryPoint.dictionary.get(ICMEntryPoint.constant.dnCardListTitleText()));
		mycards.setStyleName("categoryTree_header_myCards");
		this.headerPanel.add(mycards);
		this.headerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		this.headerPanel.add(new NewButton(ICMEntryPoint.dictionary.get(ICMEntryPoint.constant.dnNewCardTitleText()), new ClickListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				NewCardPanel newCardPanel = new NewCardPanel(ICMEntryPoint.getPCardTemplate());
				SimpleDialog dialog = new SimpleDialog(newCardPanel);
				newCardPanel.setDialogBox(dialog);
				dialog.getCancelButton().getText().setHTML("Close");
				dialog.setText(ICMEntryPoint.dictionary.get("CardWizardButton_HTML"));
				dialog.getButtonPanel().insert(newCardPanel.getSaveChangesButton(), 2);
				dialog.showDialog();

			}
		}));
		this.layoutPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
		this.layoutPanel.setSpacing(0);
		this.layoutPanel.add(this.headerPanel);
		this.layoutPanel.add(new ScrollPanel(this.tree));
		// this.layoutPanel.add(this.tree);
		this.layoutPanel.setWidth("230px");
		this.headerPanel.setSize("100%", "29px");
		ICMEntryPoint.currentState.addModifySelectedCardListener(this.modifySelectedCardListener);
		ICMEntryPoint.currentState.addModifyCategoryListListener(this.modifyCategoryListListener);
		ICMEntryPoint.currentState.addAddCardListener(this.addCardListener);
		ICMEntryPoint.currentState.addRemoveCardListener(this.removeCardListener);
		ICMEntryPoint.currentState.addDeleteCardListener(this.deleteCardListener);
		ICMEntryPoint.currentState.addDeleteCategoryListener(this.deleteCategoryListener);
		ICMEntryPoint.currentState.addAddCategoryListener(this.addCategoryListener);
		ICMEntryPoint.currentState.addModifyCategoryListener(this.modifyCategoryListener);
		initWidget(new RoundedPanel(this.layoutPanel));
		selectNextCard();
	}

	private void setSelectedItem(TreeItem item) {
		if (item.getParentItem() != null) {
			item.getParentItem().setState(true, true);
		}
		tree.setSelectedItem(item);
		onTreeItemSelected(item);
	}

	private TreeItem findNextTreeItem(TreeItem parentItem, TreeItem currentItem) {
		int currentIdx = parentItem.getChildIndex(currentItem);
		if (currentItem.getChildCount() > 0) {
			return currentItem.getChild(0);
		} else if ((currentIdx + 1) < parentItem.getChildCount()) {
			if (parentItem.getChild(currentIdx + 1).getChildCount() == 0) {
				return parentItem.getChild(currentIdx + 1);
			} else {
				return parentItem.getChild(currentIdx + 1).getChild(0);
			}
		} else if (parentItem.getParentItem() != null) {
			return findNextTreeItem(parentItem.getParentItem(), parentItem);
		} else {
			return parentItem.getChild(0);
		}

	}

	private TreeItem findPriorTreeItem(TreeItem parentItem, TreeItem currentItem) {
		int currentIdx = parentItem.getChildIndex(currentItem);
		if (currentIdx > 0) {
			if (parentItem.getChild(currentIdx - 1).getChildCount() == 0) {
				return parentItem.getChild(currentIdx - 1);
			} else {
				return parentItem.getChild(currentIdx - 1).getChild(parentItem.getChild(currentIdx - 1).getChildCount() - 1);
			}
		} else if (parentItem.getParentItem() != null) {
			return findPriorTreeItem(parentItem.getParentItem(), parentItem);
		} else {
			return parentItem.getChild(parentItem.getChildCount() - 1);
		}

	}

	public void selectPriorCard() {
		try {
			TreeItem currentItem = tree.getSelectedItem();
			if (currentItem != null && currentItem.getUserObject() != null) {
				TreeItem resItem = currentItem;
				do {
					resItem = findPriorTreeItem(resItem.getParentItem(), resItem);

				} while (!(resItem.getUserObject() instanceof Card));
				setSelectedItem(resItem);
			} else {
				if (tree.getItem(tree.getItemCount()) != null) {
					if (tree.getItem(tree.getItemCount() - 1).getChildCount() == 0) {
						setSelectedItem(tree.getItem(tree.getItemCount() - 1).getChild(
								tree.getItem(tree.getItemCount() - 1).getChildCount() - 1));
					} else {
						setSelectedItem(tree.getItem(0).getChild(0));
					}
				}
			}
		} catch (Exception e) {
		}
	}

	public void selectNextCard() {
		try {
			TreeItem currentItem = tree.getSelectedItem();
			if (currentItem != null && currentItem.getUserObject() != null) {
				TreeItem resItem = currentItem;
				do {
					resItem = findNextTreeItem(resItem.getParentItem(), resItem);
				} while (!(resItem.getUserObject() instanceof Card));
				setSelectedItem(resItem);
			} else {
				if (tree.getItem(0) != null && tree.getItem(0).getChild(0) != null) {
					setSelectedItem(tree.getItem(0).getChild(0));
				}
			}
		} catch (Exception e) {
		}
	}

	void buildAllTree(List categoriesList)
	{
		CategoryComparator ccomp = new CategoryComparator();
		Collections.sort(categoriesList, ccomp);
		for (Iterator iterator = categoriesList.iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			TreeItem categoryTreeItem = buildTree(categoryItem);
			categoryTreeItem.setState(true, true);
			CategoryTree.tree.addItem(categoryTreeItem);
		}
	}
	TreeItem buildTree(Category category) {
		final TreeItem categoryTreeItem = new TreeItem();
		final HTML categoryHTML = new HTML(category.getName().substring(0, 25) + "&nbsp;");
		categoryHTML.setStyleName("default");
		categoryHTML.addClickListener(new ClickListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				categoryTreeItem.setState(!categoryTreeItem.getState(), true);
			}

		});
		final HorizontalPanel categoryNamePanel = new HorizontalPanel();
		categoryNamePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		categoryNamePanel.add(categoryHTML);
		// String cardNumLabel = (category.getCardList().size()==1)?" card":" cards";
		final Label cardNumberLabel = new Label(" (" + category.getCardList().size() + ")");
		categoryNamePanel.add(cardNumberLabel);
		categoryTreeItem.setWidget(categoryNamePanel);
		categoryTreeItem.setUserObject(category);
		categoryTreeItem.setStyleName("categoryTreeItem");
		cardNumberLabel.setStyleName("cardNameTreeItem");

		for (Iterator iterator = category.getCardList().iterator(); iterator.hasNext();) {
			Card cardItem = (Card) iterator.next();
			categoryTreeItem.addItem(buildCardItemNode(cardItem));
		}

		for (Iterator iterator = category.getChildList().iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			categoryTreeItem.addItem(buildTree(categoryItem));
		}

		return categoryTreeItem;
	}

	private TreeItem buildCardItemNode(Card cardItem) {
		final TreeItem cardTreeItem = new TreeItem();
		cardTreeItem.setStyleName("cardTreeItem");

		cardTreeItem.setWidget(buildCardWidget(cardItem, cardTreeItem));
		return cardTreeItem;
	}

	/**
	 * @param cardItem
	 * @param cardTreeItem
	 * @return
	 */
	private HorizontalPanel buildCardWidget(Card cardItem, final TreeItem cardTreeItem) {
		final HorizontalPanel panel = new HorizontalPanel();
		panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		final Label name = new Label(cardItem.getName().substring(0, 25));
		name.setStyleName("cardTreeItemText");
		name.setTitle(cardItem.getName());
		final Image imgDefault;// = new Image(Utils.getContextPath() + cardItem.getDefaultIcon());
		final Image imgSelected;// = new Image(Utils.getContextPath() + cardItem.getSelectedIcon());
		final Image lock = cardImages.LockIcon().createImage();

		if (cardItem.getSelfIssued().booleanValue()) {
			cardItem.setDefaultIcon(ICMEntryPoint.constant.uriImgIconCardPersona());
			cardItem.setSelectedIcon(ICMEntryPoint.constant.uriImgIconCardPersonaHover());
			imgDefault = cardImages.PCardIcon().createImage();
			imgSelected = cardImages.PCardIconHover().createImage();
		} else {
			cardItem.setDefaultIcon(ICMEntryPoint.constant.uriImgIconCardWebsite());
			cardItem.setSelectedIcon(ICMEntryPoint.constant.uriImgIconCardWebsiteHover());
			imgDefault = cardImages.MCardIcon().createImage();
			imgSelected = cardImages.MCardIconHover().createImage();
		}

		imgDefault.setWidth("17px");
		imgDefault.setHeight("12px");
		imgSelected.setWidth("17px");
		imgSelected.setHeight("12px");

		panel.add(imgDefault);
		panel.add(name);
		if (cardItem.isProtected() || cardItem.isSaveCredential())
			panel.add(lock);
		MouseListener mouseListener = new MouseListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.MouseListener#onMouseDown(com.google.gwt.user.client.ui.Widget, int,
			 *      int)
			 */
			public void onMouseDown(Widget arg0, int arg1, int arg2) {
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.MouseListener#onMouseEnter(com.google.gwt.user.client.ui.Widget)
			 */
			public void onMouseEnter(Widget arg0) {
				panel.remove(0);
				panel.insert(imgSelected, 0);
				cardTreeItem.addStyleName("cardTreeItemPreSelected");
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.MouseListener#onMouseLeave(com.google.gwt.user.client.ui.Widget)
			 */
			public void onMouseLeave(Widget arg0) {
				if (!cardTreeItem.isSelected()) {
					panel.remove(0);
					panel.insert(imgDefault, 0);
				}
				cardTreeItem.removeStyleName("cardTreeItemPreSelected");

			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.MouseListener#onMouseMove(com.google.gwt.user.client.ui.Widget, int,
			 *      int)
			 */
			public void onMouseMove(Widget arg0, int arg1, int arg2) {
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.MouseListener#onMouseUp(com.google.gwt.user.client.ui.Widget, int,
			 *      int)
			 */
			public void onMouseUp(Widget arg0, int arg1, int arg2) {
			}
		};
		name.addMouseListener(mouseListener);
		imgDefault.addMouseListener(mouseListener);
		cardTreeItem.setUserObject(cardItem);
		return panel;
	}

	/**
	 * @return the layoutPanel
	 */
	public VerticalPanel getLayoutPanel() {
		return this.layoutPanel;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.TreeListener#onTreeItemSelected(com.google.gwt.user.client.ui.TreeItem)
	 */
	public void onTreeItemSelected(TreeItem selectedTreeItem) {
		if (selectedTreeItem != null) {
			try {
				for (int i = 0; i < selectedTreeItem.getTree().getItemCount(); i++) {
					resetStyle(selectedTreeItem.getTree().getItem(i));
				}
			} catch (Exception e) {
			}

			if (selectedTreeItem.getUserObject() instanceof Card) {
				selectedTreeItem.addStyleName("cardTreeItemSelected");
				((HorizontalPanel) selectedTreeItem.getWidget()).remove(0);
				Card card = (Card) selectedTreeItem.getUserObject();
				((HorizontalPanel) selectedTreeItem.getWidget()).insert(getCardImageFromBundle(card.getSelectedIcon()), 0);
				ICMEntryPoint.currentState.setSelectedCategory((Category) selectedTreeItem.getParentItem().getUserObject());
				ICMEntryPoint.currentState.setSelectedCard(card);
			}
		}
		// else if (selectedTreeItem.getUserObject() instanceof Category) {
		// ICMEntryPoint.currentState.setSelectedCategory((Category) selectedTreeItem.getUserObject());
		// ICMEntryPoint.currentState.setSelectedCard(null);
		// }
	}

	private void resetStyle(TreeItem treeItem) {
		treeItem.removeStyleName("cardTreeItemSelected");
		try {
			if (treeItem.getUserObject() instanceof Card) {
				treeItem.setWidget(buildCardWidget((Card) treeItem.getUserObject(), treeItem));
			}
		} catch (RuntimeException e) {
		}

		for (int i = 0; i < treeItem.getChildCount(); i++) {
			resetStyle(treeItem.getChild(i));
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.ui.TreeListener#onTreeItemStateChanged(com.google.gwt.user.client.ui.TreeItem)
	 */
	public void onTreeItemStateChanged(TreeItem arg0) {
		// Window.alert(((Card) arg0.getUserObject()).getName()+" state "+arg0.getState());
	}

	void modifyTreeItem(Card card, TreeItem treeItem) {
		if (treeItem != null && treeItem.getChildCount() > 0) {
			for (int i = 0; i < treeItem.getChildCount(); i++) {
				if (treeItem.getChild(i).getUserObject() instanceof Card) {
					Card cardItem = (Card) treeItem.getChild(i).getUserObject();
					try {
						if (cardItem.getCuid() != null && cardItem.getCuid().equals(card.getCuid())) {
							((Label) ((HorizontalPanel) treeItem.getChild(i).getWidget()).getWidget(1)).setText(card.getName());
							if (card.isSaveCredential() || card.isProtected()) {
								((HorizontalPanel) treeItem.getChild(i).getWidget()).remove(2);
								((HorizontalPanel) treeItem.getChild(i).getWidget()).insert(cardImages.LockIcon().createImage(), 2);
							} else
								((HorizontalPanel) treeItem.getChild(i).getWidget()).remove(2);
							treeItem.getChild(i).setUserObject(card);
						}
					} catch (Exception e) {
						// Window.alert(e.getMessage());
					}
				} else if (treeItem.getChild(i).getChildCount() > 0) {
					modifyTreeItem(card, treeItem.getChild(i));
				}

			}
		}
	}

	/**
	 * @return the tree
	 */
	public static Tree getTree() {
		return tree;
	}

	void addNewCard(Card card, Category category) {
		TreeItem cardItem = buildCardItemNode(card);
		int i = 0;
		for (Iterator iterator = ICMEntryPoint.currentState.getCategory().getChildList().iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			if (categoryItem.getId().equals(category.getId())) {
				getTree().getItem(i).addItem(cardItem);
				modifyCategoryItem(categoryItem);
			}
			i += 1;
		}
		setSelectedItem(cardItem);
	}

	// private void deleteItem(TreeItem parent, TreeItem item, Card card) {
	// if (item != null && card != null) {
	// for (int i = 0; i < item.getChildCount(); i++) {
	// deleteItem(item, item.getChild(i), card);
	// }
	// if (item.getUserObject() instanceof Card) {
	// if (card.getCuid().equals(((Card) item.getUserObject()).getCuid())) {
	// parent.removeItem(item);
	// }
	// }
	// }
	// }

	void deleteCard(Card card) {
		int i = 0;
		for (Iterator iterator = ICMEntryPoint.currentState.getCategory().getChildList().iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			int j = 0;
			for (Iterator iterator2 = categoryItem.getCardList().iterator(); iterator2.hasNext();) {
				Card cardItem = (Card) iterator2.next();
				if (cardItem.getCuid().equals(card.getCuid())) {
					getTree().getItem(i).removeItem(getTree().getItem(i).getChild(j));
					categoryItem.getCardList().remove(cardItem);
					modifyCategoryItem(categoryItem);
				}
				j += 1;
			}
			i += 1;

		}
		selectNextCard();
	}

	void removeCard(Card card, TreeItem treeItem) {
		if (treeItem != null && treeItem.getChildCount() > 0) {
			for (int i = 0; i < treeItem.getChildCount(); i++) {
				if (treeItem.getChild(i).getUserObject() instanceof Card) {
					Card cardItem = (Card) treeItem.getChild(i).getUserObject();
					try {
						if (cardItem.getCuid() != null && cardItem.getCuid().equals(card.getCuid())) {
							treeItem.removeItem(treeItem.getChild(i));
						}
					} catch (Exception e) {
						// Window.alert(e.getMessage());
					}
				} else if (treeItem.getChild(i).getChildCount() > 0) {
					removeCard(card, treeItem.getChild(i));
				}

			}
		}
	}

	void modifyCategoryItem(Category category) {
		int ic = this.tree.getItemCount();
		for (int i = 0; i < ic; i++) {
			final TreeItem categoryTreeItem = this.tree.getItem(i);
			Category cat = (Category) categoryTreeItem.getUserObject();
			if (cat.getId().equals(category.getId())) {
				categoryTreeItem.setUserObject(category);
				final HTML categoryHTML = new HTML(category.getName().substring(0, 25) + "&nbsp;");
				categoryHTML.setStyleName("default");
				categoryHTML.addClickListener(new ClickListener() {
					/*
					 * (non-Javadoc)
					 * 
					 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
					 */
					public void onClick(Widget arg0) {
						categoryTreeItem.setState(!categoryTreeItem.getState(), true);
					}

				});
				final HorizontalPanel categoryNamePanel = new HorizontalPanel();
				categoryNamePanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
				categoryNamePanel.add(categoryHTML);
				// String cardNumLabel = (category.getCardList().size()==1)?" card":" cards";
				final Label cardNumberLabel = new Label(" (" + category.getCardList().size() + ")");
				categoryNamePanel.add(cardNumberLabel);
				cardNumberLabel.setStyleName("cardNameTreeItem");
				this.tree.getItem(i).setWidget(categoryNamePanel);
				this.tree.getItem(i).setUserObject(category);

			}
		}
	}

	private Image getCardImageFromBundle(String url) {
		if (url.equals(ICMEntryPoint.constant.uriImgIconCardPersona()))
			return cardImages.PCardIcon().createImage();
		if (url.equals(ICMEntryPoint.constant.uriImgIconCardWebsite()))
			return cardImages.MCardIcon().createImage();
		if (url.equals(ICMEntryPoint.constant.uriImgIconCardPersonaHover()))
			return cardImages.PCardIconHover().createImage();
		if (url.equals(ICMEntryPoint.constant.uriImgIconCardWebsiteHover()))
			return cardImages.MCardIconHover().createImage();
		return cardImages.PCardIcon().createImage();
	}
}
