/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.button;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class NavigationButton extends DialogButton implements INavigationButton{

	/**
	 * @param text
	 * @param clickListener
	 * @param direction
	 */
	public NavigationButton(String text, ClickListener clickListener, String direction) {
		super(text, clickListener);
		final Image image;
		if (direction.equalsIgnoreCase(LEFT_DIRECTION)) {
			image = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgArrowLeftBlue());
			getPanel().insert(image, 0);
		} else {
			image = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgArrowRigthBlue());
			getPanel().add(image);
		}
		image.setStyleName("image_button");
		image.addClickListener(clickListener);
		image.addMouseListener(getMouseListener());

	}

}
