package org.eclipse.higgins.ics.gwt.base.client.editor;

import org.eclipse.higgins.ics.gwt.base.client.util.DatePicker;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;

public class DateEditor extends BaseEditor {
	
	private DatePicker picker = new DatePicker();
	
	public DateEditor() {
		editor = new TextBox();
		setReadOnly(true);
		editor.setStyleName("editorDate");
		add(editor);
		final Image image = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgDatePicker());
		image.addClickListener(new ClickListener() {
			public void onClick(Widget arg0) {
				picker.show((TextBox)editor);
			}
		});
		image.setStyleName("image_button");
		add(image);
	}

	public String getTypeEditor() {
		return DATE_TEXT_BOX_EDITOR;
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#getValue()
	 */
	public String getValue() {
		return ((TextBox) editor).getText();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean isReadOnly) {
		super.setReadOnly(isReadOnly);
		((TextBox) editor).setReadOnly(isReadOnly);
	}
	
	public void setValue(String val) {
		if (val != null) 
			((TextBox) editor).setText(val);
		else ((TextBox) editor).setText("");
	}
	
	/*public String getValue() {
		date = picker.getDate();
		return date!=null?picker.months[date.getMonth()]+" "+date.getDate()+" "+date.getYear():"Unknown";
	}*/

	/*public void setValue(String val) {			//put time in millis here!!
		date.setTime(Integer.parseInt(val));
		((TextBox)editor).setText(this.getValue());
	}*/

}
