/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.model.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class Category extends BaseEntity implements Serializable {

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object obj) {
		return obj instanceof Category && getId() != null
				&& getId().equals(((Category) obj).getId());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return getId().hashCode();
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = -8661995260528990146L;

	/**
	 * @gwt.typeArgs <org.eclipse.higgins.ics.gwt.base.client.model.entity.Card>
	 */
	private List cardList = new ArrayList();

	/**
	 * @gwt.typeArgs <org.eclipse.higgins.ics.gwt.base.client.model.entity.Category>
	 */
	private List childList = new ArrayList();

	private String icon;

	private String id;

	private int idx;

	private String parentId;

	private boolean preDefined = false;

	private String type;

	/**
	 * 
	 */
	public Category() {
		super();
	}

	private String selectedIcon;

	/**
	 * @param id
	 * @param parentId
	 */
	public Category(String id, String parentId) {
		super();
		this.id = id;
		this.parentId = parentId;
	}

	/**
	 * @return the cardList
	 */
	public List getCardList() {
		return this.cardList;
	}

	/**
	 * @return the childList
	 */
	public List getChildList() {
		return this.childList;
	}

	/**
	 * @return the icon
	 */
	public String getIcon() {
		return this.icon;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return this.id;
	}

	/**
	 * @return the parentId
	 */
	public String getParentId() {
		return this.parentId;
	}

	/**
	 * @return the selectedIcon
	 */
	public String getSelectedIcon() {
		return this.selectedIcon;
	}

	/**
	 * @param cardList
	 *            the cardList to set
	 */
	public void setCardList(List cardList) {
		this.cardList = cardList;
	}

	/**
	 * @param childList
	 *            the childList to set
	 */
	public void setChildList(List childList) {
		this.childList = childList;
	}

	/**
	 * @param icon
	 *            the icon to set
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @param parentId
	 *            the parentId to set
	 */
	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	/**
	 * @param selectedIcon
	 *            the selectedIcon to set
	 */
	public void setSelectedIcon(String selectedIcon) {
		this.selectedIcon = selectedIcon;
	}

	/**
	 * @return the preDefined
	 */
	public boolean isPreDefined() {
		return this.preDefined;
	}

	/**
	 * @param preDefined
	 *            the preDefined to set
	 */
	public void setPreDefined(boolean preDefined) {
		this.preDefined = preDefined;
	}

	/**
	 * @return the idx
	 */
	public int getIdx() {
		return this.idx;
	}

	/**
	 * @param idx
	 *            the idx to set
	 */
	public void setIdx(int idx) {
		this.idx = idx;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getType() {
		return this.type;
	}
}
