/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 * */

package org.eclipse.higgins.ics.gwt.base.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class WaitPanel extends Composite {

	// private Image image;

	private HorizontalPanel layoutPanel;

	private final Image progressImage = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgProgress());

	private HTML htmlText;

	public WaitPanel() {
		this.layoutPanel = new HorizontalPanel();
		this.layoutPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.layoutPanel.setSpacing(10);
		this.htmlText = new HTML();
		this.htmlText.setStyleName("default");
		this.layoutPanel.add(this.progressImage);
		this.layoutPanel.add(this.htmlText);
		initWidget(this.layoutPanel);
	}

	/**
	 * @param htmlText
	 *            the text to set
	 */
	public void setText(String htmlText) {
		this.htmlText.setHTML(htmlText);
	}
	
	public WaitPanel(String htmlText)
	{
		this();
		setText(htmlText);
	}
}
