/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.util;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author Alexander Yuhimenko
 * 
 */
public abstract class GWTCallBack implements AsyncCallback {

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.rpc.AsyncCallback#onFailure(java.lang.Throwable)
	 */
	public void onFailure(Throwable arg0) {
		Utils.hideWaiteDialog();
		Utils.showErrorMessage("Error:" + arg0.getMessage());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.google.gwt.user.client.rpc.AsyncCallback#onSuccess(java.lang.Object)
	 */
	public abstract void onSuccess(Object res);
}
