/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 */

package org.eclipse.higgins.ics.gwt.icm.client;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUpdate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;

import com.google.gwt.user.client.rpc.RemoteService;

/**
 * @author Alexander Yuhimenko
 * 
 */

public interface ICMService extends RemoteService {

	/**
	 * @param userId
	 * @param userPassword
	 * @return
	 */
	public GWTResponse getCurrentState(String userId, String userPassword);

	/**
	 * @param card
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse modifyCard(Card card, String userIdentifier, String userPassword);

	/**
	 * @return
	 */
	public GWTResponse getUserProfile();

	/**
	 * @param userProfile
	 * @return
	 */
	public GWTResponse modifyUserProfile(UserProfile userProfile);

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse getPCardTemplate(String userIdentifier, String userPassword);

	/**
	 * @param cardTemplate
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse createICard(CardTemplate cardTemplate, String userIdentifier, String userPassword);

	/**
	 * @param cuid
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse deleteICard(String cuid, String userIdentifier, String userPassword);

	/**
	 * @param card
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse getCardByCredential(Card card, String userIdentifier, String userPassword);

	/**
	 * @param cuid
	 * @param pin
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse resetPinCode(String cuid, String pin, String userIdentifier, String userPassword);
	
	public GWTResponse editPinCode(String userId, String password, String cuid, String oldPinCode, String newPinCode);

	/**
	 * @param cuid
	 * @param pin
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse setPinCode(String cuid, String pin, String userIdentifier, String userPassword);

	/**
	 * @param cuid
	 * @param cardName
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse createDuplicateCard(String cuid, String cardName, String pinCode, String userIdentifier, String userPassword);

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse deleteAllCard(String userIdentifier, String userPassword);

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse createCategory(Category category, String userIdentifier, String userPassword);

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse modifyCategory(Category category, String userIdentifier, String userPassword);

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public GWTResponse deleteCategory(Category category, String userIdentifier, String userPassword);

	public Card[] getImportedCard();
	
	public FormatDescriptor getRestoreData();
	
	public GWTResponse putCredentialForRestore(FormatDescriptor descriptor, String userIdentifier, String userPassword);
	
	public GWTResponse putImageForIE(String image);
	
	public GWTResponse getCardInformation(String cuid, String userIdentifier, String userPassword, int size);
	
	public GWTResponse setUrlsCardRelation(String userId, String password, String cuid, String[] urls);
	
	public GWTResponse deleteUrlsCardRelation(String userId, String password, String cuid, String[] urls);
	
	public GWTResponse clearCardHistory(String userId, String password, String cuid);
	
	public GWTResponse clearCardCredential(String userId, String password, String cuid);
	
	public GWTResponse modifyCategories(String userId, String password, Category[] categories);
	
	public GWTResponse getCardById(String cuid, String userIdentifier, String userPassword);
	
	public GWTResponse setCardCredential(String userId, String password, String cuid, CardCredential tokenCredential);
	
	public GWTResponse getCardHistory(String userId, String password, String cuid, int startFrom, int capacity, String orderBy, String orderDirection);
	
	public GWTResponse exportICards(String userId, String password, String formatID, String[] cards, CardCredential credential);
	
	public GWTResponse getICardsByFormat(String userId, String password, String formatID);
	
	public GWTResponse getOutputFormats(java.lang.String userId, java.lang.String password);
	
	public GWTResponse getMRU(String userId, String password);
	
	public GWTResponse updateClaimAcrossCards(String userId, java.lang.String password, String claimType, String claimValue, CardUpdate[] cardUpdate);
}
