/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 */

package org.eclipse.higgins.ics.gwt.icm.client;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUpdate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author Alexander Yuhimenko
 * 
 */

public interface ICMServiceAsync {

	/**
	 * @param userId
	 * @param userPassword
	 * @param callback
	 */
	public void getCurrentState(String userId, String userPassword, AsyncCallback callback);

	/**
	 * @param callback
	 */
	public void getUserProfile(AsyncCallback callback);

	/**
	 * @param card
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void modifyCard(Card card, String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param userProfile
	 * @param callback
	 */
	public void modifyUserProfile(UserProfile userProfile, AsyncCallback callback);

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void getPCardTemplate(String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param cardTemplate
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void createICard(CardTemplate cardTemplate, String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param cuid
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void deleteICard(String cuid, String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param card
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void getCardByCredential(Card card, String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param cuid
	 * @param pin
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void setPinCode(String cuid, String pin, String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param cuid
	 * @param pin
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void resetPinCode(String cuid, String pin, String userIdentifier, String userPassword, AsyncCallback callback);
	
	public void editPinCode(String userId, String password, String cuid, String oldPinCode, String newPinCode, AsyncCallback callback);

	/**
	 * @param cuid
	 * @param cardName
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void createDuplicateCard(String cuid, String cardName, String pinCode, String userIdentifier, String userPassword,
			AsyncCallback callback);

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void deleteAllCard(String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void createCategory(Category category, String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void modifyCategory(Category category, String userIdentifier, String userPassword, AsyncCallback callback);

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @param callback
	 */
	public void deleteCategory(Category category, String userIdentifier, String userPassword, AsyncCallback callback);

	public void getImportedCard(AsyncCallback callback);
	
	public void getRestoreData(AsyncCallback callback);
	
	public void putCredentialForRestore(FormatDescriptor descriptor, String userIdentifier, String userPassword, AsyncCallback callback);
	
	public void putImageForIE(String image, AsyncCallback callback);
	
	public void getCardInformation(String cuid, String userIdentifier, String userPassword, int size, AsyncCallback callback);
	
	public void setUrlsCardRelation(String userId, String password, String cuid, String[] urls, AsyncCallback callback);
	
	public void deleteUrlsCardRelation(String userId, String password, String cuid, String[] urls, AsyncCallback callback);
	
	public void clearCardHistory(String userId, String password, String cuid, AsyncCallback callback);
	
	public void clearCardCredential(String userId, String password, String cuid, AsyncCallback callback);
	
	public void modifyCategories(String userId, String password, Category[] categories, AsyncCallback callback);
	
	public void getCardById(String cuid, String userIdentifier, String userPassword, AsyncCallback callback);
	
	public void setCardCredential(String userId, String password, String cuid, CardCredential tokenCredential, AsyncCallback callback);
	
	public void getCardHistory(String userId, String password, String cuid, int startFrom, int capacity, String orderBy, String orderDirection, AsyncCallback callback);
	
	public void exportICards(String userId, String password, String formatID, String[] cards, CardCredential credential, AsyncCallback callback);
	
	public void getICardsByFormat(String userId, String password, String formatID, AsyncCallback callback);
	
	public void getOutputFormats(String userId, String password, AsyncCallback callback);
	
	public void getMRU(String userId, String password, AsyncCallback callback);
	
	public void updateClaimAcrossCards(String userId, java.lang.String password, String claimType, String claimValue, CardUpdate[] cardUpdate, AsyncCallback callback);

}
