package org.eclipse.higgins.ics.gwt.icm.client.backup;

import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ListEntity;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class BackupWizardDialog {
	
	private SimpleDialog dialog = null;
	
	private ChooseTypeBackupPanel typePanel = null;
	
	private ChooseCardsBackupPanel cardsPanel = null;
	
	private PasswordBackupPanel passwordPanel = null;
	
	public BackupWizardDialog() {
		Utils.showWaiteDialog("Please wait...");
		ICMEntryPoint.service.getOutputFormats(ICMEntryPoint.getUserProfile().getLoginName(),
				ICMEntryPoint.getUserProfile().getPassword(), new AsyncCallback() {
			public void onSuccess(Object res) {
				Utils.hideWaiteDialog();
				if (res instanceof GWTResponse) {
					GWTResponse response = (GWTResponse) res;
					if (new Integer(0).equals(response.getStatusCode())) {
						ListEntity list = (ListEntity)response.getResult();
						createTypesPanel(list.getList());
					} else {
						Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
								+ response.getStatusMessage());
					}
				}
			}
			
			public void onFailure(Throwable arg0) {
				Utils.hideWaiteDialog();
				Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
						+ arg0);
			}
		});
		
		
		/*dialog = new SimpleDialog(new ChooseCardsBackupPanel(ICMEntryPoint.currentState.getCategory().getChildList()));
		dialog.setText("Choose cards");
		dialog.showDialog();*/
	}

	public void createTypesPanel(List types) {
		if (typePanel == null) {
			typePanel = new ChooseTypeBackupPanel();
		} 
		if (types != null) {
			typePanel.drawTypesTable(types);
		}
		if (dialog != null) {dialog.hide();}
		dialog = new SimpleDialog(typePanel);
		/*} else {
			dialog.setBodyWidget(typePanel);
			dialog.getButtonPanel().remove(3);
			dialog.getButtonPanel().remove(1);
		}*/
		dialog.setText("Step 1 of 3. "+typePanel.getHeader());
		dialog.getButtonPanel().insert(new CardActionButton("Next", new ClickListener() {
			public void onClick(Widget arg0) {
				if (typePanel.getFormat() != null){
					Utils.showWaiteDialog("Please wait...");				
					ICMEntryPoint.service.getICardsByFormat(ICMEntryPoint.getUserProfile().getLoginName(),
						ICMEntryPoint.getUserProfile().getPassword(), typePanel.getFormat().getFormatID(), new AsyncCallback() {
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
								+ arg0);
					}
					
					public void onSuccess(Object arg0) {
						Utils.hideWaiteDialog();
						GWTResponse response = (GWTResponse) arg0;
						if (new Integer(0).equals(response.getStatusCode())) {
							createCardsPanel(((ListEntity)response.getResult()).getList());
						} else {
							Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
									+ response.getStatusMessage());
						}
					}
				});
				} else {
					Utils.showErrorMessage("Please choose a backup type.");
				}
			}
		}), 2);
		dialog.showDialog();
	}
	
	public void createCardsPanel(List cards) {
		dialog.hide();
		if (cardsPanel == null) {
			cardsPanel = new ChooseCardsBackupPanel();
		}
		if (cards != null) {
			cardsPanel.setCards(cards);
			cardsPanel.drawTable();
			//dialog.getButtonPanel().remove(2);			
		} else {
			//dialog.getButtonPanel().remove(3);
			//dialog.getButtonPanel().remove(1);
		}
		dialog = new SimpleDialog(cardsPanel);
		/*ScrollPanel scrollPanel = new ScrollPanel();
		int height = Utils.rootHeight<cardsPanel.getOffsetHeight()?Utils.rootHeight-50:cardsPanel.getOffsetHeight()+50;
		scrollPanel.setSize(cardsPanel.getOffsetWidth()+5+"px", height+"px");
		scrollPanel.add(cardsPanel);*/
		//dialog.setBodyWidget(cardsPanel);
		dialog.setText("Step 2 of 3. "+cardsPanel.getHeader());
		dialog.getButtonPanel().insert(cardsPanel.getSelectAllButton(),1);
		dialog.getButtonPanel().insert(cardsPanel.getDeselectAllButton(),2);
		dialog.getButtonPanel().insert(new CardActionButton("Back", new ClickListener() {
			public void onClick(Widget arg0) {
				createTypesPanel(null);
			}
		}), 3);
		dialog.getButtonPanel().insert(new CardActionButton("Next", new ClickListener() {
			public void onClick(Widget arg0) {
				if (cardsPanel.getCardCount() != 0) {
					createPasswordPanel();
				} else {
					Utils.showErrorMessage("Please choose at least one card.");
				}
			}
		}), 5);
		dialog.showDialog();
	}
	
	public void createPasswordPanel() {
		dialog.hide();
		if (passwordPanel == null) {
			passwordPanel = new PasswordBackupPanel(typePanel.getFormat().getCardCredential());
		}
		dialog = new SimpleDialog(passwordPanel);
		//dialog.getButtonPanel().remove(1);
		dialog.getButtonPanel().insert(new CardActionButton("Back", new ClickListener() {
			public void onClick(Widget arg0) {
				createCardsPanel(null);
			}
		}), 1);
		//dialog.getButtonPanel().remove(3);
		dialog.getButtonPanel().insert(new CardActionButton("Backup", new ClickListener() {
			public void onClick(Widget arg0) {
				if (passwordPanel.getCredentialText0().equals(passwordPanel.getCredentialText1())) {
					Utils.showWaiteDialog("Please wait...");				
					ICMEntryPoint.service.exportICards(ICMEntryPoint.getUserProfile().getLoginName(),
							ICMEntryPoint.getUserProfile().getPassword(), typePanel.getFormat().getFormatID(), cardsPanel.getSelectedCardCuids(), passwordPanel.getCredential(), new AsyncCallback() {
						public void onSuccess(Object arg0) {
							Utils.hideWaiteDialog();				
							GWTResponse response = (GWTResponse) arg0;
							if (new Integer(0).equals(response.getStatusCode())) {
								//Utils.showWaiteDialog("Get a file...");	
								//Window.open("getmyfile.crds", "Get backup file...", "");
								Frame frame = new Frame("getmyfile.crds");
								VerticalPanel panel = new VerticalPanel();
								panel.setSpacing(15);
								panel.add(new Label("Backup succesfully created."));
								panel.add(frame);
								frame.setVisible(false);
								dialog.setText("Success!");
								dialog.setBodyWidget(panel);
								dialog.getButtonPanel().remove(3);
								dialog.getButtonPanel().remove(1);
								dialog.getCancelButton().getText().setText("Close");
								dialog.showDialog();								
							} else {
								Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")
										+ response.getStatusMessage());
							}
						}
						public void onFailure(Throwable arg0) {
							Utils.hideWaiteDialog();				
							Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ServerErrorLabel_HTML")+ arg0);
						}
					});
				} else {
					dialog.setText(ICMEntryPoint.dictionary.get("PasswordsDontMatchLabel_HTML"));
				}
			}
		}), 3);
		dialog.setBodyWidget(passwordPanel);
		dialog.setText("Step 3 of 3. "+passwordPanel.getHeader());		
		dialog.showDialog();
	}
}
