/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.editor.TextBoxEditor;
import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor;
import org.eclipse.higgins.ics.gwt.base.client.editor.EditorBuilder;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplateItem;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.panel.edit.CardEditablePanel;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class NewCardPanel extends Composite {

	private CardTemplate cardTemplate;
	private final FlexTable bodyTable = new FlexTable();
	private ClickListener saveChangesListener;
	private CardActionButton saveChangesButton;
	private DialogBox dialogBox;

	/**
	 * 
	 */
	public NewCardPanel(CardTemplate cardTemplate) {
		this.cardTemplate = cardTemplate;

		getBodyTable().setWidget(0, 0, CardEditablePanel.buildGroupPanel(ICMEntryPoint.dictionary.get("CardSetupGroupPanel_HTML")));
		getBodyTable().getFlexCellFormatter().setColSpan(0, 0, 2);

		for (int i = 0; i < getCardTemplate().getCardTemplateItems().length; i++) {
			buildEditor(getCardTemplate().getCardTemplateItems()[i], i + 1, getBodyTable());
		}

		try {
			((BaseEditor) getBodyTable().getWidget(1, 1)).setValue(ICMEntryPoint.dictionary.get("NewPersonalCardTitle_HTML"));
		} catch (Exception e) {
		}

		getBodyTable().setWidth("100%");
		initWidget(getBodyTable());
		setSaveChangesListener(new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {

				for (int i = 0; i < getCardTemplate().getCardTemplateItems().length; i++) {
					updateCardTemplete(getCardTemplate().getCardTemplateItems()[i], i + 1, getBodyTable());
				}
				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
				ICMEntryPoint.service.createICard(getCardTemplate(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
						.getUserProfile().getPassword(), new GWTCallBack() {

					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						super.onFailure(arg0);
					}

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) res;
							if (response.getStatusCode().equals(new Integer(0))) {
								ICMEntryPoint.currentState.addNewCard((Card) response.getResult());
							} else {
								Utils.showErrorMessage(response.getStatusCode() + response.getStatusMessage());
							}
						}
						if (getDialogBox() != null) {
							getDialogBox().hide();
						}
					}
				});
			}

		});
		setSaveChangesButton(new CardActionButton(ICMEntryPoint.dictionary.get("SaveChangesButton_HTML"), getSaveChangesListener()));

	}

	void updateCardTemplete(CardTemplateItem cardTemplateItem, int idx, FlexTable claimTable) {
		if (cardTemplateItem.getContainerValue() == null || cardTemplateItem.getContainerValue().length == 0) {
			cardTemplateItem.setValue(((BaseEditor) claimTable.getWidget(idx, 1)).getValue());
		} else {
			FlexTable complexClaimTable = (FlexTable) claimTable.getWidget(idx, 0);
			for (int i = 0; i < cardTemplateItem.getContainerValue().length; i++) {
				updateCardTemplete((CardTemplateItem) cardTemplateItem.getContainerValue()[i], i + 1, complexClaimTable);
			}
		}
	}

	private void buildEditor(CardTemplateItem cardTemplateItem, int idx, FlexTable claimTable) {
		// CardTemplateItem[] cardTemplateItems = getCardTemplate().getCardTemplateItems();
		if (cardTemplateItem.getContainerValue() == null || cardTemplateItem.getContainerValue().length == 0) {
			claimTable.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT);
			Label name = new Label(cardTemplateItem.getName());
			name.setStyleName("default");
			claimTable.setWidget(idx, 0, name);

			BaseEditor editor = EditorBuilder.buildByCardTemplateItem(cardTemplateItem);
			if (cardTemplateItem.getName().equalsIgnoreCase(ICMEntryPoint.dictionary.get("CardNameLabel_HTML"))) 
				((TextBoxEditor)editor).disableOptions();
			claimTable.getFlexCellFormatter().setHorizontalAlignment(idx, 1, HasHorizontalAlignment.ALIGN_LEFT);
			claimTable.setWidget(idx, 1, editor);

		} else {
			FlexTable complexClaimTable = new FlexTable();
			complexClaimTable.setWidget(0, 0, CardEditablePanel.buildGroupPanel(cardTemplateItem.getDescription()));

			complexClaimTable.getFlexCellFormatter().setColSpan(0, 0, 2);
			for (int i = 0; i < cardTemplateItem.getContainerValue().length; i++) {
				buildEditor((CardTemplateItem) cardTemplateItem.getContainerValue()[i], i + 1, complexClaimTable);
			}
			claimTable.setWidget(idx, 0, complexClaimTable);
			claimTable.getFlexCellFormatter().setColSpan(idx, 0, 2);

		}

		//		
		// getCardImage().setValue(getCard().getImage());
		// getCardImage().setName("Card image");
		// getCardImage().setChildWidth(getCard().getSelfIssued().booleanValue() ? "80" : "120");
		// getCardImage().setChildHeight("80");
		//
		// getBodyTable().getFlexCellFormatter().setHorizontalAlignment(0, 1, HasHorizontalAlignment.ALIGN_LEFT);
		// getBodyTable().setWidget(0, 1, getCardImage());
		// // getBodyTable().getFlexCellFormatter().setColSpan(0, 0, 2);
		//
		// getBodyTable().getFlexCellFormatter().setHorizontalAlignment(1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
		// getLabelCardName().setStyleName("cardPanel_claim_label");
		// getLabelCardName().setText("Card name");
		//
		// getBodyTable().setWidget(1, 0, getLabelCardName());
		//
		// getCardName().setValue(getCard().getName());
		// getCardName().setName("Card name");
		// getCardName().setInputRegExp("^\\w");
		// getCardName().setCheckValueRunTime(true);
		//
		// getBodyTable().getFlexCellFormatter().setHorizontalAlignment(1, 1, HasHorizontalAlignment.ALIGN_LEFT);
		// getBodyTable().setWidget(1, 1, getCardName());

	}

	/**
	 * @return the saveChangesListener
	 */
	public ClickListener getSaveChangesListener() {
		return this.saveChangesListener;
	}

	/**
	 * @param saveChangesListener
	 *            the saveChangesListener to set
	 */
	public void setSaveChangesListener(ClickListener saveChangesListener) {
		this.saveChangesListener = saveChangesListener;
	}

	/**
	 * @return the dialogBox
	 */
	public DialogBox getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox(DialogBox dialogBox) {
		this.dialogBox = dialogBox;
	}

	/**
	 * @return the bodyTable
	 */
	public FlexTable getBodyTable() {
		return this.bodyTable;
	}

	/**
	 * @return the saveChangesButton
	 */
	public CardActionButton getSaveChangesButton() {
		return this.saveChangesButton;
	}

	/**
	 * @return the cardTemplate
	 */
	public CardTemplate getCardTemplate() {
		return this.cardTemplate;
	}

	/**
	 * @param cardTemplate
	 *            the cardTemplate to set
	 */
	public void setCardTemplate(CardTemplate cardTemplate) {
		this.cardTemplate = cardTemplate;
	}

	/**
	 * @param saveChangesButton
	 *            the saveChangesButton to set
	 */
	public void setSaveChangesButton(CardActionButton saveChangesButton) {
		this.saveChangesButton = saveChangesButton;
	}

}
