/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.button.MenuItemMouseListener;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.RPCUtils;
import org.eclipse.higgins.ics.gwt.icm.client.backup.BackupWizardDialog;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ToolsListPanel extends Composite {

	private FlexTable flexTable = new FlexTable();

	/**
	 * 
	 */
	public ToolsListPanel() {
		// Label preferencesLabel = new Label("Preferences");
		// preferencesLabel.addMouseListener(new MenuItemMouseListener());
		// flexTable.setWidget(0, 0, preferencesLabel);

		HTML importLabel = new HTML(ICMEntryPoint.dictionary.get("ImportCardMenuItem_HTML"));
		importLabel.setStyleName("default");
		importLabel.addClickListener(new ClickListener() {
			public void onClick(Widget arg0) {
				new ImportCardPanel("import", "crd").show(ICMEntryPoint.dictionary.get("ChooseCrdFileMessage_HTML"));
				hideParentPopup();
			}
		});
		importLabel.addMouseListener(new MenuItemMouseListener());
		flexTable.setWidget(1, 0, importLabel);

		HTML backupLabel = new HTML("Backup data...");
		backupLabel.setStyleName("default");
		backupLabel.addClickListener(new ClickListener() {
			public void onClick(Widget arg) {
				new BackupWizardDialog();
				hideParentPopup();
			}
		});
		backupLabel.addMouseListener(new MenuItemMouseListener());
		flexTable.setWidget(2, 0, backupLabel);
		//
		HTML restoreLabel = new HTML("Restore data...");
		restoreLabel.setStyleName("default");
		restoreLabel.addClickListener(new ClickListener() {
			public void onClick(Widget arg0) {
				new RestorePanel("restore", "crds").show("Choose Cardspace backup (*.crds) file to restore");
				hideParentPopup();
			}
		});
		restoreLabel.addMouseListener(new MenuItemMouseListener());
		flexTable.setWidget(3, 0, restoreLabel);

		/*HTML manageCategoriesLabel = new HTML(ICMEntryPoint.dictionary.get("ManageCategoriesMenuItem_HTML"));
		manageCategoriesLabel.setStyleName("default");
		manageCategoriesLabel.addClickListener(new ClickListener() {
			public void onClick(Widget arg0) {
				ManageCategoriesPanel manageCategoriesPanel = new ManageCategoriesPanel();
				manageCategoriesPanel.setDialogBox();
				// dialogBox.getHeaderPanel().add(new HTML(manageCategoriesPanel.getHeader()));
				manageCategoriesPanel.showDialog();
				hideParentPopup();
			}
		});
		manageCategoriesLabel.addMouseListener(new MenuItemMouseListener());
		flexTable.setWidget(4, 0, manageCategoriesLabel);*/

		HTML deleteAllLabel = new HTML(ICMEntryPoint.dictionary.get("DeleteAllCardsMenuItem_HTML"));
		deleteAllLabel.setStyleName("default");
		deleteAllLabel.addClickListener(new ClickListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				RPCUtils.deleteAllCards();
				hideParentPopup();
			}
		});
		deleteAllLabel.addMouseListener(new MenuItemMouseListener());
		this.flexTable.setWidget(4, 0, deleteAllLabel);
		initWidget(this.flexTable);
	}

	/**
	 * 
	 */
	void hideParentPopup() {
		try {
			// TODO refactor that
			((PopupPanel) flexTable.getParent().getParent().getParent().getParent().getParent()).hide();
		} catch (RuntimeException e) {
		}
	}
}
