/**
 * Copyright (c) 2007 Parity Communications, Inc. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * Alexander Yuhimenko - implementation
 */
package org.eclipse.higgins.ics.model.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Response;
import org.eclipse.higgins.ics.model.bean.ManagerBean;
/**
 * @author Alexander Yuhimenko
 * 
 * Servlet implementation for UploadFile
 * 
 */
public class ImportCardServlet extends HttpServlet implements Servlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = -4813567516856793952L;

	public static final int MAX_UPLOAD_LENGTH = 1024 * 1024 * 20;
	
	private ManagerBean bean = new ManagerBean();
	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public ImportCardServlet() {
		super();
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// boolean isMultipart = request.getContentType().equals("");
		// boolean isMultipart = ServletFileUpload.isMultipartContent(request);
		HttpSession session = request.getSession(); 
		try {
			DiskFileItemFactory factory = new DiskFileItemFactory();
			// factory.setSizeThreshold(yourMaxMemorySize);
			// factory.setRepository(yourTempDirectory);
			String login = request.getParameter("ln");
			String password = request.getParameter("pw");	
			byte[] fileData = null;
			ServletFileUpload upload = new ServletFileUpload(factory);
			upload.setSizeMax(MAX_UPLOAD_LENGTH);
			List items = upload.parseRequest(request);
			for (int i=0; i<items.size(); i++) {
				FileItem item = (FileItem)items.get(i);
				if (!item.isFormField()) {
					long sizeInBytes = item.getSize();
					if (MAX_UPLOAD_LENGTH >= sizeInBytes) {
						InputStream uploadedStream = item.getInputStream();
						fileData = new byte[(int) sizeInBytes];
						uploadedStream.read(fileData);
						uploadedStream.close();
					}
				}
				else
				{
					InputStream uploadedStream = item.getInputStream();
					long sizeInBytes = item.getSize();
					byte[] data = new byte[(int) sizeInBytes];
					uploadedStream.read(data);
					if (item.getFieldName().equals("ln")) login = new String(data);
					if (item.getFieldName().equals("pw")) password = new String(data);
					uploadedStream.close();
				}
			}
			Response rppsResponse = bean.importCards(login, password, fileData);
			session.setAttribute("imported", rppsResponse.getResult());
			

		} catch (FileUploadException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}