/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.button;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class DialogButton extends SimpleButton {

	/**
	 * @param text
	 * @param clickListener
	 */
	public DialogButton(String text, ClickListener clickListener) {
		super(text, clickListener, new Image(Utils.getContextPath() + Utils.baseConstant.uriImgButtonSecondaryRt()), new Image(Utils
				.getContextPath()
				+ Utils.baseConstant.uriImgButtonSecondaryRtHover()));
	}

	public String getStyleNameButton() {
		return "navigation_button";
	}

	public String getStyleNameButtonActive() {
		return "navigation_button_active";
	}

}
