/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.dialog;

import org.eclipse.higgins.ics.gwt.base.client.button.DialogButton;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class SimpleDialog extends FadeoutDialogBox {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.base.client.dialog.FadeoutDialogBox#show()
	 */
	public void showDialog() {         //mac fix
		super.setPopupPositionAndShow(setCenterPositionCallback());

		// super.show();
		// try {
		// if (getOffsetHeight() + 160 > Utils.rootHeight) {
		// this.scrollBodyPanel.setPixelSize(getOffsetWidth() + 10, Utils.rootHeight - 160 -
		// this.headerPanel.getOffsetHeight()
		// - this.buttonPanel.getOffsetHeight());
		// }
		// if (getOffsetWidth() > 1000) {
		// this.scrollBodyPanel.setPixelSize(1000, this.scrollBodyPanel.getOffsetHeight());
		// }
		// } catch (RuntimeException e) {
		// }
	}
	
	public PopupPanel.PositionCallback setCenterPositionCallback() {
		return new PopupPanel.PositionCallback() {
			public void setPosition(int offsetWidth, int offsetHeight) {
				try {
					int w = getWidget().getOffsetWidth(), h = getWidget().getOffsetHeight();
					if (w + 100 > Utils.rootWidth)
						w = Utils.rootWidth - 100;
					if (h + 170 > Utils.rootHeight) {
						h = Utils.rootHeight - 170;
					} else {
						w -= 20;
					}
					if (scrollBodyPanel != null) 
						scrollBodyPanel.setPixelSize(w + 20, h - buttonPanel.getOffsetHeight());
					else innerPanel.setPixelSize(w + 20, h - buttonPanel.getOffsetHeight());
					setPopupPosition(((Utils.rootWidth - w) / 2), (Utils.rootHeight - h) / 2);
				} catch (Exception e) {
					// Window.alert("Err" + e.getMessage());
				}
			}
		};
	}

	private final VerticalPanel bodyPanel = new VerticalPanel();
	private final VerticalPanel headerPanel = new VerticalPanel();
	private final HorizontalPanel buttonPanel = new HorizontalPanel();
	private DialogButton cancelButton;
	private ScrollPanel scrollBodyPanel = null;
	private HorizontalPanel innerPanel = new HorizontalPanel();

	/**
	 * 
	 */
	
	public SimpleDialog(Widget bodyWidget) {
		this(bodyWidget, true);
	}
	
	public SimpleDialog(Widget bodyWidget, boolean isScrolledDialog) {
		// this.scrollBodyPanel.setWidth("100%");

		/*this.headerPanel.setStyleName("simpleDialog_headerPanel");
		this.headerPanel.setWidth("100%");
		this.headerPanel.setHeight("15px");
		this.headerPanel.setSpacing(5);
		this.headerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		this.headerPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);*/

		this.cancelButton = new DialogButton("Cancel", new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				SimpleDialog.this.hide();
			}
		});

		Image emptyImageBegin = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgEmpty());
		emptyImageBegin.setWidth("35px");
		Image emptyImageEnd = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgEmpty());
		emptyImageEnd.setWidth("10px");
		this.buttonPanel.setSpacing(5);
		this.buttonPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		this.buttonPanel.add(emptyImageBegin);
		this.buttonPanel.add(this.cancelButton);
		this.buttonPanel.add(emptyImageEnd);

		// this.bodyPanel.add(this.headerPanel);
		//this.scrollBodyPanel.setHorizontalAlignment();
		
		if (isScrolledDialog)
		{
			this.scrollBodyPanel = new ScrollPanel();
			//this.scrollBodyPanel.add(bodyWidget);	
			innerPanel.setSpacing(10);
			innerPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
			innerPanel.add(bodyWidget);
			innerPanel.setHeight("100%");
			this.scrollBodyPanel.add(innerPanel);		
			this.bodyPanel.add(scrollBodyPanel);
		}
		else 
			//this.bodyPanel.add(innerPanel);
			this.bodyPanel.add(bodyWidget);
		HorizontalPanel bottomPanel = new HorizontalPanel();
		bottomPanel.setStyleName("simpleDialog_buttonPanel");
		bottomPanel.setWidth("100%");
		bottomPanel.setHeight("31px");
		//bottomPanel.setSpacing(0);
		bottomPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		bottomPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
		bottomPanel.add(this.buttonPanel);
		this.bodyPanel.add(bottomPanel);
		// scrollBodyPanel.add(this.bodyPanel);
		// setWidget(new RoundedPanelDialog(this.bodyPanel));
		setWidget(this.bodyPanel);
		// center();
	}

	/**
	 * @return the buttonPanel
	 */
	public HorizontalPanel getButtonPanel() {
		return this.buttonPanel;
	}

	/**
	 * @return the cancelButton
	 */
	public DialogButton getCancelButton() {
		return this.cancelButton;
	}

	/**
	 * @return the headerPanel
	 */
	public VerticalPanel getHeaderPanel() {
		return this.headerPanel;
	}
	
	public void setCancelButton(DialogButton button) {
		this.cancelButton = button;
	}
	
	public HorizontalPanel getInnerPanel() {
		return this.innerPanel;
	}
	
	public void setBodyWidget(Widget widget) {
		if (this.scrollBodyPanel != null) {
			innerPanel.clear();
			innerPanel.add(widget);
		} else {
			this.bodyPanel.remove(0);
			this.bodyPanel.insert(widget, 0);		
		}
	}
}
