package org.eclipse.higgins.ics.gwt.icm.client.panel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor;
import org.eclipse.higgins.ics.gwt.base.client.listener.SaveValueListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUpdate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ListEntity;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class CrossCardClaimEditorPanel {
	
	private class CrossCardEditorPanelItem extends HorizontalPanel {
		
		CheckBox checkBox = new CheckBox();
		PasswordTextBox pinBox = new PasswordTextBox();
		//String cuid = new String();
		//CardCredential credential = null;
		Card card;
		
		public CrossCardEditorPanelItem(final Card card) {
			super();
			setWidth("80px");
			setSpacing(2);
			setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
			setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
			this.card = card;
			//pinBox.setText("Enter PIN here");
			pinBox.addClickListener(new ClickListener(){
				public void onClick(Widget arg0) {
					pinBox.setText("");
				}
			});
			checkBox.setChecked(false);
			checkBox.addClickListener(new ClickListener() {
				public void onClick(Widget arg) {
					if (!card.isValueAvailable() && !card.isSaveCredential() && checkBox.isChecked()) {
						
						add(pinBox);
					}
					if (!card.isValueAvailable() && !card.isSaveCredential() && !checkBox.isChecked()) {
						
						remove(pinBox);
					}
				}
			});
			add(checkBox);
			add(new Label(card.getName().substring(0, 20)));
			
		}

		public CheckBox getCheckBox() {
			return checkBox;
		}

		public void setCheckBox(CheckBox checkBox) {
			this.checkBox = checkBox;
		}

		public PasswordTextBox getPinBox() {
			return pinBox;
		}

		public void setPinBox(PasswordTextBox pinBox) {
			this.pinBox = pinBox;
		}

		public Card getCard() {
			return card;
		}

		public void setCard(Card card) {
			this.card = card;
		}
	}
	
	private VerticalPanel layoutPanel = new VerticalPanel();
	private HorizontalPanel mainPanel = new HorizontalPanel();
	private VerticalPanel radioButtonPanel = new VerticalPanel();
	private VerticalPanel cardsTablePanel = new VerticalPanel();
	private HorizontalPanel cardOptions = new HorizontalPanel();
	private final FlexTable cardsTable = new FlexTable();
	private RadioButton rb0;
	private RadioButton rb1;
	private Label moreOptions = new Label();
	private Label lessOptions = new Label();
	private Label checkAll = new Label("Check All");
	private Label checkNone = new Label("Check None");
	private final HTML cardCounter = new HTML();	
	//private int cardCount = 0;	
	private List cards = new ArrayList();	
	private Label update = new Label("Update:");
	private int tableWidthCount = 1;
	private SimpleDialog dialog;
	private BaseEditor editor;
	private CardActionButton saveButton;
	private String oldValue;
	private List saveValueListenerCollection = new ArrayList();
	private ClickListener moreOptionsListener = new ClickListener(){
		public void onClick(Widget arg0) {
			dialog.hide();
			rb0.setVisible(false);
			rb1.setVisible(false);
			update.setText("Update selected cards:");
			moreOptions.setVisible(false);
			lessOptions.setVisible(true);
		    cardsTablePanel.setVisible(true);
			//dialog.setPixelSize(dialog.getOffsetWidth(), cardsTable.getOffsetHeight()+220);
			dialog = new SimpleDialog(layoutPanel, false);
			setDialogBoxProperties();
			//dialog.setPixelSize(dialog.getOffsetWidth(), cardsTable.getOffsetHeight()+22);
		    dialog.showDialog();
		}
	};
	
	private ClickListener lessOptionsListener = new ClickListener(){
		public void onClick(Widget arg0) {
			dialog.hide();
			rb0.setVisible(true);
			rb1.setVisible(true);
			update.setText("Update:");
			moreOptions.setVisible(true);
			lessOptions.setVisible(false);
		    cardsTablePanel.setVisible(false);
		    //layoutPanel.setPixelSize(layoutPanel.getOffsetWidth(), mainPanel.getOffsetHeight()+20);
		    //dialog.setPixelSize(dialog.getOffsetWidth(), mainPanel.getOffsetHeight()-20);
		    dialog = new SimpleDialog(layoutPanel, false);
		    setDialogBoxProperties();
		    //dialog.setPixelSize(dialog.getOffsetWidth(), mainPanel.getOffsetHeight()+22);
		    dialog.showDialog();
		}
	};
	
	private void addCards(Category category) {
		for (Iterator iterator = category.getCardList().iterator(); iterator.hasNext();) {
			Card cardItem = (Card) iterator.next();
			if (cardItem.getSelfIssued().booleanValue()) {cards.add(cardItem); // && !cardItem.isProtected()
			 //Window.alert(cardItem+"");
				}
		}

		for (Iterator iterator = category.getChildList().iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			addCards(categoryItem);
		} 
	}
	
	public void drawTable() {
		//cardCount = 0;
		cardCounter.setHTML("");
		int row = 0;
		int col = 0;
		for (int i=0; i<cards.size(); i++) {
			CrossCardEditorPanelItem item = new CrossCardEditorPanelItem((Card)cards.get(i));
			cardsTable.setWidget(row, col, item);			
			col++;
			if (col>tableWidthCount) {
				row++;
				col=0;
			}
		}
		cardsTable.setSize("100%", "100%");
	}
	
	public void setDialogBoxProperties() {
		dialog.setStyleName("simpleDialog_noBorder");
		//dialog.setText(this.getHeader());
		dialog.getInnerPanel().setSpacing(0);
		//dialog.getButtonPanel().insert(this.getSaveChangesButton(), 2);
		//dialog.getButtonPanel().remove(1);
		dialog.getButtonPanel().insert(saveButton, 1);
		//dialog.getButtonPanel().insert(this.getCancelButton(), 1);
	}
	
	public CrossCardClaimEditorPanel(BaseEditor ed) {
		mainPanel.setSpacing(5);
		mainPanel.setWidth("100%");
		oldValue = new String(ed.getOldValue());
		editor = ed;
		mainPanel.add(editor);
		
		/*tableWidthCount = (Utils.rootWidth/160) - 2;
		if (tableWidthCount<1) tableWidthCount=3;	*/	
		List categories = ICMEntryPoint.currentState.getCategory().getChildList();
	    for (Iterator iterator = categories.iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			addCards(categoryItem);
		}
		drawTable();
		
		layoutPanel.setStyleName("crossEditor");
		layoutPanel.setSpacing(7);
		radioButtonPanel.add(update);
		rb0 = new RadioButton("myRadioGroup", "This Card Only");
	    rb1 = new RadioButton("myRadioGroup", "All cards with the same prior value");
	    rb0.setChecked(true);
	    radioButtonPanel.add(rb0);
	    radioButtonPanel.add(rb1);
	    moreOptions.setText("More options");
	    moreOptions.setStyleName("moreoptions");
		moreOptions.addClickListener(moreOptionsListener);
		lessOptions.setText("Less options");
		lessOptions.setStyleName("moreoptions");
		lessOptions.addClickListener(lessOptionsListener);
		checkAll.setStyleName("moreOptions");
		checkNone.setStyleName("moreOptions");
		checkAll.addClickListener(new ClickListener(){
			public void onClick(Widget arg0){
				int row = 0;
				int col = 0;
				for (int i=0; i<cards.size(); i++) {
					CrossCardEditorPanelItem item = (CrossCardEditorPanelItem)cardsTable.getWidget(row, col);
					item.getCheckBox().setChecked(true);
					if (!item.getCard().isValueAvailable() && !item.getCard().isSaveCredential()) {
						
						item.add(item.pinBox);
					}
					col++;
					if (col>tableWidthCount) {
						row++;
						col=0;
					}
				}
			}
		});
		checkNone.addClickListener(new ClickListener(){
			public void onClick(Widget arg0){
				int row = 0;
				int col = 0;
				for (int i=0; i<cards.size(); i++) {
					CrossCardEditorPanelItem item = (CrossCardEditorPanelItem)cardsTable.getWidget(row, col);
					item.getCheckBox().setChecked(false);
					if (!item.getCard().isValueAvailable() && !item.getCard().isSaveCredential()) {
						
						item.remove(item.pinBox);
					}
					col++;
					if (col>tableWidthCount) {
						row++;
						col=0;
					}
				}
			}
		});
		radioButtonPanel.add(lessOptions);
	    radioButtonPanel.add(moreOptions);
	    moreOptions.setVisible(true);
		lessOptions.setVisible(false);
	    mainPanel.add(radioButtonPanel);
	    layoutPanel.add(mainPanel);
	    layoutPanel.add(cardsTablePanel);
	    
	    Image separator = new Image(Utils.getContextPath() + ICMEntryPoint.constant.uriImgBgHeaderOverlayForm());
		separator.setHeight("1px");
		separator.setWidth("95%");
	    cardsTablePanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
	    cardsTablePanel.add(cardOptions);
	    cardsTablePanel.add(separator);
	    cardsTablePanel.add(cardsTable);
	    cardsTablePanel.setSize("100%", "100%");
	    cardsTable.setSize("100%", "100%");
	    cardsTablePanel.setVisible(false);
	    cardsTablePanel.setStyleName("simpleDialog_noBorder");
	    cardOptions.setSpacing(3);
	    cardOptions.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
	    cardOptions.add(new Label("Cards to update:"));
	    cardOptions.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
	    cardOptions.add(new Label("Checked:"));
	    cardOptions.add(checkAll);
	    cardOptions.add(checkNone);
		dialog = new SimpleDialog(layoutPanel, false);
		saveButton = new CardActionButton("Save", new ClickListener() {
			public void onClick(Widget arg0){
				List list = new ArrayList();
				if (cardsTablePanel.isVisible()){
					int row = 0;
					int col = 0;
					for (int i=0; i<cards.size(); i++) {
						CrossCardEditorPanelItem item = (CrossCardEditorPanelItem)cardsTable.getWidget(row, col);
						if (item != null && item.getCheckBox().isChecked()) {
							CardUpdate update = new CardUpdate();
							update.setCuid(item.getCard().getCuid());
							if (item.getCard().getCardCredential()!= null && item.getCard().getCardCredential().length>0) {
								update.setCredential(item.getCard().getCardCredential()[0]);
								update.getCredential().setPinCode(item.getPinBox().getText());
							}
							list.add(update);
						}
						col++;
						if (col>tableWidthCount) {
							row++;
							col=0;
						}
					}
				} else {
					if (rb1.isChecked()) {
						for (int i=0; i<cards.size(); i++) {
							Card card = (Card)cards.get(i);
							if (card.isValueAvailable()) {
								for (int j=0; j<card.getClaimItems().length; j++) {
									if (card.getClaimItems()[j].getClaimType()==editor.getClaimType() && card.getClaimItems()[j].getValue()==oldValue) {
										CardUpdate update = new CardUpdate();
										update.setCuid(card.getCuid());
										list.add(update);
									}
								}
							}
						}
					} else {
						CardUpdate update = new CardUpdate();
						update.setCuid(ICMEntryPoint.currentState.getSelectedCard().getCuid());
						Card card = ICMEntryPoint.currentState.getSelectedCard();
						if (card.getCardCredential()!= null && card.getCardCredential().length>0) 
							update.setCredential(card.getCardCredential()[0]);
						list.add(update);
					}
				
				}
				CardUpdate[] updates = new CardUpdate[list.size()]; 
				for (int i=0; i<updates.length; i++) {
					updates[i] = (CardUpdate)list.get(i);
				}
				Utils.showWaiteDialog("Please wait. Updating...");
				
				ICMEntryPoint.service.updateClaimAcrossCards(ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile().getPassword(), editor.getClaimType(), editor.getValue(), updates, new AsyncCallback(){
					public void onFailure(Throwable arg) {
						Utils.hideWaiteDialog();
						Utils.showErrorMessage("Error: "+arg);
					}
					public void onSuccess(Object arg) {
						Utils.hideWaiteDialog();
						dialog.hide();
						if (arg instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) arg;
							if (response.getStatusCode().equals(new Integer(0))) {
								ListEntity entity = (ListEntity)response.getResult();
								List cuids = entity.getList();
								//List cardNames = new ArrayList();
								String info = new String("The following cards were updated:<br>");
								for (int i=0; i<cards.size(); i++) {
									for (int j=0; j<cuids.size(); j++) {
										Card card = (Card)cards.get(i);
										if (card.getCuid()==(String)cuids.get(j)) {
											//cardNames.add(((Card)cards.get(i)).getName());
											info = info+"<br>"+"<b>"+card.getName()+"</b>";
											for (int k=0; k<card.getClaimItems().length; k++) {
												if (card.getClaimItems()[k].getClaimType().equals(editor.getClaimType()) && card.isValueAvailable()) {
													card.getClaimItems()[k].setValue(editor.getValue());
													ICMEntryPoint.currentState.modifySelectedCard(card);
													Utils.addValueToMRU(editor.getClaimType(), editor.getValue());
													for (Iterator iter = getSaveValueListenerCollection().iterator(); iter.hasNext();) {
														SaveValueListener listener = (SaveValueListener)iter.next();
														listener.onSave(editor.getValue());
													}
												}
											}
											
										}
									}
								}
								HTML html = new HTML();
								html.setHTML(info.toString());
								SimpleDialog end = new SimpleDialog(html);
								end.getCancelButton().setText("Close");
								end.showDialog();
							}
						}
					}
				});
			}
		});
		setDialogBoxProperties();
		dialog.showDialog();
		
	}
	
	public BaseEditor getBaseEditor() {
		return editor;
	}
	
	public SimpleDialog getDialog() {
		return dialog;
	}

	public List getSaveValueListenerCollection() {
		return saveValueListenerCollection;
	}

	public void setSaveValueListenerCollection(List saveValueListenerCollection) {
		this.saveValueListenerCollection = saveValueListenerCollection;
	}
}
