package org.eclipse.higgins.ics.gwt.icm.client.panel;

import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;
import org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.RestoreDataCredentialPanel;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FormSubmitCompleteEvent;
import com.google.gwt.user.client.ui.FormSubmitEvent;

public class RestorePanel extends ImportFilePanel {
	
	public RestorePanel(String actionUrl, String fileMask) {
		super(actionUrl, fileMask);
	}

	public void onSubmit(FormSubmitEvent event) {
		if (getUpload().getFilename() != null
				&& (getUpload().getFilename().toLowerCase().endsWith(getFileMask()))) {
			Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("ImportingLabel_HTML"));
		} else {
			event.setCancelled(true);
			Utils.showErrorMessage("<b>*."+getFileMask()+"</b>"+ICMEntryPoint.dictionary.get("FileSupportMessage_HTML"));
		}
	}

	public void onSubmitComplete(FormSubmitCompleteEvent event) {
		ICMEntryPoint.service.getRestoreData(new AsyncCallback(){
			public void onFailure(Throwable arg) {
				Utils.hideWaiteDialog();
				Utils.showErrorMessage("Network Error");
			}
			
			public void onSuccess(Object arg) {
				Utils.hideWaiteDialog();
				FormatDescriptor fd = (FormatDescriptor)arg;
				if (fd.getCardCredential() != null) {
					RestoreDataCredentialPanel credentialPanel = new RestoreDataCredentialPanel(fd);
					SimpleDialog dialog = new SimpleDialog(credentialPanel);
					dialog.setText("This file is protected by password. Enter it please");
					credentialPanel.setDialogBox(dialog);
					dialog.getButtonPanel().insert(credentialPanel.getRetrieveButton(), 2);
					credentialPanel.showDialog();
					credentialPanel.setFocus(true);
				}
				/*else {
					ICMEntryPoint.service.putCredentialForRestore(fd, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
							.getUserProfile().getPassword(), new AsyncCallback() {
						
						 * (non-Javadoc)
						 * 
						 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
						 
						public void onFailure(Throwable arg0) {
							Utils.hideWaiteDialog();
						}

						
						 * (non-Javadoc)
						 * 
						 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
						 
						public void onSuccess(Object res) {
							Utils.hideWaiteDialog();
							Utils.hideWaiteDialog();
							if (res instanceof GWTResponse) {
								GWTResponse response = (GWTResponse) res;
								if (new Integer(0).equals(response.getStatusCode())) {
									ArrayList cards = ((ListEntity) response.getResult()).getList();
									getDialogBox().hide();
									for (int i = 0; i < cards.size(); i++)
										ICMEntryPoint.currentState.addNewCard((Card)cards.get(i));
								} else if (ErrorKeys.ERROR_CODE_RemoteException.equals(response.getStatusCode())) {
									String errorDescr = ICMEntryPoint.dictionary.get("IncorrectPasswordErrorLabel_HTML");
									((SimpleDialog)getDialogBox()).setText(errorDescr);
									
								} else {
									getDialogBox().hide();
									String errorDescr = ICMEntryPoint.dictionary.get("ErrorRetrievingClaimsLabel_HTML")+ICMEntryPoint.dictionary.get("TryAgainLabel_HTML");
									Utils.showErrorMessage(errorDescr);							
								}
							}
						}
					});
				}*/
			}
		});
		

	}

}
