/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.card;

import org.eclipse.higgins.ics.gwt.base.client.button.NavigationButton;
import org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CardPanelHeader extends VerticalPanel {

	private final HorizontalPanel headerButtonPanel = new HorizontalPanel();
	private final Label categoryName = new Label();
	private final Label cardName = new Label();
	private final HorizontalPanel tabPanel = new HorizontalPanel();
	final HorizontalPanel tabPanelCardDetails;
	final HorizontalPanel tabPanelHistory;

	private final ChangeSelectedCardListener selectedCardListener = new ChangeSelectedCardListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.higgins.ics.gwt.base.client.listener.ChangeSelectedCardListener#onChangeSelectedCard(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
		 *      org.eclipse.higgins.ics.gwt.base.client.model.entity.Category)
		 */
		public void onChangeSelectedCard(Card card, Category category) {
			if (card != null) {
				cardName.setText(card.getName());
				categoryName.setText(category.getName());
				getTabPanelCardDetails().getWidget(0).setStyleName("tabBarItem-selected");
				getTabPanelHistory().getWidget(0).setStyleName("tabBarItem");
				setVisible(true);
			} else {
				setVisible(false);
			}

		}

	};

	/**
	 * 
	 */
	public CardPanelHeader() {
		setWidth("100%");
		// setHeight("99px");

		setStyleName("cardPanel_header");
		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);

		this.categoryName.setStyleName("cardPanel_categoryName");
		add(this.categoryName);

		this.cardName.setStyleName("cardPanel_cardName");
		add(this.cardName);

		this.headerButtonPanel.setWidth("200px");
		this.headerButtonPanel.setHeight("22px");
		this.headerButtonPanel.setSpacing(5);

		this.headerButtonPanel.add(new NavigationButton(ICMEntryPoint.dictionary.get("DetailsPreviousCardButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				ICMEntryPoint.mainPanel.getCategoryTree().selectPriorCard();
			}

		}, NavigationButton.LEFT_DIRECTION));

		this.headerButtonPanel.add(new NavigationButton(ICMEntryPoint.dictionary.get("DetailsNextCardButton_HTML"), new ClickListener() {

			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				ICMEntryPoint.mainPanel.getCategoryTree().selectNextCard();
			}

		}, NavigationButton.RIGHT_DIRECTION));

		setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		this.tabPanel.setSpacing(0);
		this.tabPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		this.tabPanelCardDetails = buildTabBar(ICMEntryPoint.dictionary.get("CardDetailsTabTitle_HTML"));
		this.tabPanelHistory = buildTabBar(ICMEntryPoint.dictionary.get("HistoryTabTitle_HTML"));
		this.tabPanel.add(this.tabPanelCardDetails);
		Image empty = new Image(Utils.getContextPath() + ICMEntryPoint.constant.uriImgEmpty());
		empty.setWidth("5px");
		this.tabPanel.add(empty);
		//TODO unimplement 
		this.tabPanel.add(this.tabPanelHistory);

		HorizontalPanel panel = new HorizontalPanel();
		panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		panel.setWidth("100%");
		panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_LEFT);
		panel.add(this.tabPanel);
		/*panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		panel.add(this.headerButtonPanel);*/

		setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		add(panel);

		ICMEntryPoint.currentState.addChangeSelectedCardListener(this.selectedCardListener);
		setVisible(false);

	}

	private HorizontalPanel buildTabBar(String name) {
		final Label nameLabel = new Label(name);
		final HorizontalPanel tabBarPanel = new HorizontalPanel();
		tabBarPanel.add(nameLabel);
		final Image imageSel = new Image(Utils.getContextPath() + ICMEntryPoint.constant.uriImgTabRt());
		imageSel.setSize("2px", "21px");

		tabBarPanel.add(imageSel);

		nameLabel.addMouseListener(new MouseListener() {
			public void onMouseDown(Widget arg0, int arg1, int arg2) {
			}

			public void onMouseEnter(Widget arg0) {
				if (arg0.getStyleName().indexOf("tabBarItem-selected ") > 0) {
					arg0.addStyleName("tabBarItem-black");
				} else {
					arg0.addStyleName("tabBarItem-preselected");
				}
			}

			public void onMouseLeave(Widget arg0) {
				if (arg0.getStyleName().indexOf("tabBarItem-selected ") > 0) {
					arg0.removeStyleName("tabBarItem-black");
				} else {
					arg0.removeStyleName("tabBarItem-preselected");
				}
			}

			public void onMouseMove(Widget arg0, int arg1, int arg2) {
			}

			public void onMouseUp(Widget arg0, int arg1, int arg2) {
			}
		});
		nameLabel.setStyleName("tabBarItem");
		return tabBarPanel;
	}

	/**
	 * @return the tabPanelCardDetails
	 */
	public HorizontalPanel getTabPanelCardDetails() {
		return this.tabPanelCardDetails;
	}

	/**
	 * @return the tabPanelHistory
	 */
	public HorizontalPanel getTabPanelHistory() {
		return this.tabPanelHistory;
	}

}
