/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.dialog.SimpleDialog;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ErrorKeys;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CardCredentialPanel extends Composite {

	private final Card card;
	
	private boolean canShow = true;

	private final VerticalPanel bodyPanel = new VerticalPanel();

	private DialogBox dialogBox;

	private final CardActionButton retrieveButton = new CardActionButton(ICMEntryPoint.dictionary.get("RetrieveButton_HTML"), new ClickListener() {

		/*
		 * (non-Javadoc)
		 * 
		 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
		 */
		public void onClick(Widget arg0) {
			Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("RetrievingClaimValueLabel_HTML"));
			ICMEntryPoint.service.getCardByCredential(getCard(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
					.getUserProfile().getPassword(), new GWTCallBack() {
				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
				 */
				public void onFailure(Throwable arg0) {
					Utils.hideWaiteDialog();
					super.onFailure(arg0);

				}

				/*
				 * (non-Javadoc)
				 * 
				 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
				 */
				public void onSuccess(Object res) {
					Utils.hideWaiteDialog();
					if (res instanceof GWTResponse) {
						GWTResponse response = (GWTResponse) res;
						if (new Integer(0).equals(response.getStatusCode())) {
							ICMEntryPoint.currentState.modifySelectedCard((Card) response.getResult());
							if (getDialogBox() != null) {
								getDialogBox().hide();
								
							}
						} else if (ErrorKeys.ERROR_CODE_RemoteException.equals(response.getStatusCode())) {
							//Utils.showErrorMessage("Sorry, server don't return claim value.<br> You might type wrong password. ");
							//((SimpleDialog)getDialogBox()).getHeaderPanel().remove(0);
							String errorDescr = ICMEntryPoint.dictionary.get("IncorrectPasswordErrorLabel_HTML");
							//if (!getCard().getSelfIssued().booleanValue())
							//errorDescr = ICMEntryPoint.dictionary.get("ErrorRetrievingClaimsLabel_HTML")+ICMEntryPoint.dictionary.get("TryAgainLabel_HTML");
								((SimpleDialog)getDialogBox()).setText(errorDescr);
							//Utils.showErrorMessage(errorDescr);
							/*if (getDialogBox() != null) {
								getDialogBox().show();
							}*/
						} else {
							String errorDescr = ICMEntryPoint.dictionary.get("ErrorRetrievingClaimsLabel_HTML")+ICMEntryPoint.dictionary.get("TryAgainLabel_HTML");
							((SimpleDialog)getDialogBox()).setText(errorDescr);
						}
					}
				}
			});
		}
	});

	/**
	 * 
	 */
	public CardCredentialPanel(Card card) {
		this.card = card;
		this.bodyPanel.setSpacing(7);
		initWidget(this.bodyPanel);
		for (int i = 0; i < card.getCardCredential().length; i++) {
			addCredential(card.getCardCredential()[i]);
		}		
	}

	private void addCredential(CardCredential cardCredential) {
		if (cardCredential != null) {
			if (CardCredentialEditor.USERNAME_PASSWORD_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
				this.bodyPanel.add(new UserNamePasswordCredentialPanel(cardCredential));
			} else if (CardCredentialEditor.PIN_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
				this.bodyPanel.add(new PinCredentialPanel(cardCredential));
			} else if (CardCredentialEditor.SELFISSUED_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
				this.bodyPanel.add(new SelfIssuedCredentialPanel(cardCredential));
			} else if (CardCredentialEditor.SELFISSUED_NONPIN_CRIDENTIAL_TYPE.equals(cardCredential.getType())) {
				useSelfSignedNonPinCredential();
			} else {
				this.bodyPanel.add(new HTML("Unsupported credential type" + cardCredential.getType()));
			}
		}
	}

	/**
	 * @return the card
	 */
	public Card getCard() {
		for (int i = 0; i < card.getCardCredential().length; i++) {
			// addCredential(card.getCardCredential()[i]);
			Widget w = bodyPanel.getWidget(i);
			if (w instanceof CardCredentialEditor) {
				CardCredential cardCredential = ((CardCredentialEditor) w).getCardCredential();
				card.getCardCredential()[i] = cardCredential;
			}
		}
		return this.card;
	}

	/**
	 * @return the dialogBox
	 */
	public DialogBox getDialogBox() {
		return this.dialogBox;
	}

	/**
	 * @param dialogBox
	 *            the dialogBox to set
	 */
	public void setDialogBox(DialogBox dialogBox) {
		this.dialogBox = dialogBox;
	}

	/**
	 * @return the retrieveButton
	 */
	public CardActionButton getRetrieveButton() {
		return this.retrieveButton;
	}

	public void setFocus(boolean focused) {
		try {
			((CardCredentialEditor) bodyPanel.getWidget(0)).setFocus(focused);
		} catch (RuntimeException e) {
		}
	}
	
	public void useSelfSignedNonPinCredential()
	{
		canShow = false;
		Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("RetrievingClaimValueLabel_HTML"));
		ICMEntryPoint.service.getCardByCredential(this.card, ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint
				.getUserProfile().getPassword(), new GWTCallBack() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
			 */
			public void onFailure(Throwable arg0) {
				
				Utils.hideWaiteDialog();
				super.onFailure(arg0);
			}

			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
			 */
			public void onSuccess(Object res) {
				Utils.hideWaiteDialog();
				if (res instanceof GWTResponse) {
					GWTResponse response = (GWTResponse) res;
					if (new Integer(0).equals(response.getStatusCode())) {
						ICMEntryPoint.currentState.modifySelectedCard((Card) response.getResult());
					} else {
						Utils.showErrorMessage(ICMEntryPoint.dictionary.get("ErrorRetrievingClaimsLabel_HTML"));
					}
				}
			}
		});
	}
	
	public void showDialog() {
		if (canShow) {
			if (this.dialogBox instanceof SimpleDialog)
				((SimpleDialog)dialogBox).showDialog();
			else
				dialogBox.show();
		}
	}

}
