/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class PinCredentialPanel extends Composite implements CardCredentialEditor {

	private CardCredential cardCredential;

	private VerticalPanel bodyPanel = new VerticalPanel();
	private PasswordTextBox pinTextBox = new PasswordTextBox();
	private HTML pinLabel = new HTML();
	
	public PinCredentialPanel(CardCredential cardCredential) 
	{
		this(cardCredential, ICMEntryPoint.dictionary.get("PasswordLabel_HTML")+": ");
	}
	/**
	 * 
	 */
	public PinCredentialPanel(CardCredential cardCredential, String labelText) {
		if (cardCredential != null && (CardCredentialEditor.PIN_CRIDENTIAL_TYPE.equals(cardCredential.getType())||CardCredentialEditor.PASSWORD_CRIDENTIAL_TYPE.equals(cardCredential.getType()))) {
			this.pinLabel.setStyleName("cardCredentialLabel");
			this.pinLabel.setHTML(labelText);
			this.cardCredential = cardCredential;
			this.bodyPanel.add(this.pinLabel);
			this.bodyPanel.add(this.pinTextBox);
			this.pinTextBox.setText(cardCredential.getPinCode());
		}
		initWidget(this.bodyPanel);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialEditor#setCardCredential(org.eclipse.higgins.ics.gwt.icm.client.panel.cardcredential.CardCredentialEditor)
	 */
	public CardCredential getCardCredential() {
		if (this.cardCredential != null) {
			if (CardCredentialEditor.PIN_CRIDENTIAL_TYPE.equals(this.cardCredential.getType())) {
				this.cardCredential.setPinCode(getPinTextBox().getText());
			}
			if (CardCredentialEditor.PASSWORD_CRIDENTIAL_TYPE.equals(this.cardCredential.getType())) {
				this.cardCredential.setPassword(getPinTextBox().getText());
			}
		}
		return this.cardCredential;
	}

	/**
	 * @return the pinTextBox
	 */
	public PasswordTextBox getPinTextBox() {
		return this.pinTextBox;
	}

	/**
	 * @param focused
	 * @see com.google.gwt.user.client.ui.FocusWidget#setFocus(boolean)
	 */
	public void setFocus(boolean focused) {
		this.pinTextBox.setFocus(focused);
	}
	
	public String getPinLabel()
	{
		return this.pinLabel.getHTML();
	}
	
	public void setPinLabel(String html)
	{
		this.pinLabel.setHTML(html);
	}
}
