/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.icm.client.panel.edit;

import org.eclipse.higgins.ics.gwt.base.client.button.CardActionButton;
import org.eclipse.higgins.ics.gwt.base.client.editor.BaseEditor;
import org.eclipse.higgins.ics.gwt.base.client.editor.EditorBuilder;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack;
import org.eclipse.higgins.ics.gwt.base.client.util.Utils;
import org.eclipse.higgins.ics.gwt.icm.client.ICMEntryPoint;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class PCardEditablePanel extends CardEditablePanel {

	/**
	 * 
	 */
	public PCardEditablePanel(Card pcard) {
		super(pcard);
		this.getLabelCardImage().setText(ICMEntryPoint.dictionary.get("CardImageLabel_HTML"));
		// getBodyTable().getColumnFormatter().setWidth(0, "160px");

		getBodyTable().setWidget(this.dimRowTable, 0, buildGroupPanel(ICMEntryPoint.dictionary.get("Level1ClaimTitle_HTML")));
		getBodyTable().getFlexCellFormatter().setColSpan(this.dimRowTable, 0, 2);
		this.dimRowTable = this.dimRowTable + 1;

		for (int i = 0; i < getCard().getClaimItems().length; i++) {
			getBodyTable().getFlexCellFormatter().setHorizontalAlignment(this.dimRowTable + i, 0, HasHorizontalAlignment.ALIGN_RIGHT);
			Label label = new Label(getCard().getClaimItems()[i].getName() + ": ");
			label.setStyleName("cardPanel_claim_label");
			getBodyTable().setWidget(this.dimRowTable + i, 0, label);

			BaseEditor editor = EditorBuilder.buildByClaimItem(getCard().getClaimItems()[i]);
			editor.setChildHeight("80");
			editor.setWidth("80");
			getBodyTable().getFlexCellFormatter().setHorizontalAlignment(this.dimRowTable + i, 1, HasHorizontalAlignment.ALIGN_LEFT);
			getBodyTable().setWidget(this.dimRowTable + i, 1, editor);
			if (!getCard().getClaimItems()[i].isVisible()){
				getBodyTable().getFlexCellFormatter().setVisible(this.dimRowTable + i, 1, false);
	//			getBodyTable().getFlexCellFormatter().setVisible(this.dimRowTable + i, 1, false);
			}
		}
		setSaveChangesListener(new ClickListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see com.google.gwt.user.client.ui.ClickListener#onClick(com.google.gwt.user.client.ui.Widget)
			 */
			public void onClick(Widget arg0) {
				getCard().setName(getCardName().getValue());
				getCard().setImage(getCardImage().getValue());
				getCard().setImageType("image/jpeg");
				for (int i = 0; i < getCard().getClaimItems().length; i++) {
					try {
						BaseEditor editor = (BaseEditor) getBodyTable().getWidget(PCardEditablePanel.this.dimRowTable + i, 1);
						getCard().getClaimItems()[i].setValue(editor.getValue());
					} catch (RuntimeException e) {
					}
				}

				Utils.showWaiteDialog(ICMEntryPoint.dictionary.get("SendChangesLabel_HTML"));
				ICMEntryPoint.service.modifyCard(getCard(), ICMEntryPoint.getUserProfile().getLoginName(), ICMEntryPoint.getUserProfile()
						.getPassword(), new GWTCallBack() {

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onFailure(java.lang.Throwable)
					 */
					public void onFailure(Throwable arg0) {
						Utils.hideWaiteDialog();
						super.onFailure(arg0);
					}

					/*
					 * (non-Javadoc)
					 * 
					 * @see org.eclipse.higgins.ics.gwt.base.client.util.GWTCallBack#onSuccess(java.lang.Object)
					 */
					public void onSuccess(Object res) {
						Utils.hideWaiteDialog();
						if (res instanceof GWTResponse) {
							GWTResponse response = (GWTResponse) res;
							if (response.getStatusCode().equals(new Integer(0))) {
								ICMEntryPoint.currentState.modifySelectedCard((Card) response.getResult());
							} else {
								Utils.showErrorMessage(response.getStatusMessage());
							}
						}
						if (getDialogBox() != null) {
							getDialogBox().hide();
						}
					}
				});

			}
		});
		setSaveChangesButton(new CardActionButton(ICMEntryPoint.dictionary.get("SaveButton_HTML"), getSaveChangesListener()));
	}

}
