package org.eclipse.higgins.ics.model.bean;

import java.util.ArrayList;
import java.util.Iterator;

import javax.servlet.http.HttpSession;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUpdate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CurrentState;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ErrorKeys;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Response;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserData;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;
import org.eclipse.higgins.ics.model.Messages;
import org.eclipse.higgins.ics.ws.client.Utils;
import org.eclipse.higgins.ics.ws.client.WSClient;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class ManagerBean {

	private WSClient wsClient = new WSClient();

	/**
	 * @param userId
	 * @param userPassword
	 * @return Card[]
	 * @see org.eclipse.higgins.ics.ws.client.WSClient#getCards(java.lang.String, java.lang.String)
	 */
//	public Response getCards(String userId, String userPassword) {
//		return wsClient.getCards(userId, userPassword);
//	}

	/**
	 * @param userId
	 * @param userPassword
	 * @return rootCategory
	 * @see org.eclipse.higgins.ics.ws.client.wsClient#getCategories(java.lang.String, java.lang.String)
	 */
	// public static Response getCategories(String userId, String userPassword) {
	// Response response = wsClient.getCategories(userId, userPassword);
	//
	// if (response.getStatusCode().equals(new Integer(0))) {
	// Category[] categories;
	// if (response.getResult() == null) {
	// categories = getPredefinedCategories();
	// } else if (response.getResult() instanceof Category[]) {
	// categories = (Category[]) response.getResult();
	// } else {
	// response.setStatusCode(ErrorKeys.ERROR_CODE_Exception);
	// return response;
	// }
	// response.setResult(buildCategoryTree(new Category(Messages.getString("ManagerBean.0"),
	// Messages.getString("ManagerBean.0")),
	// categories));
	// }
	// return response;
	// }
	/**
	 * @param rootCategory
	 * @param categories
	 * @return rootCategory
	 */
	private static Category buildCategoryTree(Category rootCategory, ArrayList categories) {
		if (rootCategory == null)
			throw new NullPointerException();
		for (Iterator iterator = categories.iterator(); iterator.hasNext();) {
			Category categoryItem = (Category) iterator.next();
			if (categoryItem.getParentId() != null
					&& (categoryItem.getParentId().equals(rootCategory.getId()) && !categoryItem.getParentId().equals(categoryItem.getId()))) {
				rootCategory.getChildList().add(buildCategoryTree(categoryItem, categories));
			}
		}
		return rootCategory;
	}

	/**
	 * @return two predefined category
	 */
	private Category getPredefinedCategoryPersonas(String userId, String userPassword) {
		
		Category categories0 = new Category();
		categories0.setIdx(-3);
		categories0.setType(Messages.getString("ManagerBean.1"));
		categories0.setParentId("0");
		categories0.setPreDefined(true);
		categories0.setName(Messages.getString("ManagerBean.MyPersonas"));
		categories0.setIcon("personas_category_icon");
		categories0.setSelectedIcon("personas_category_selected_icon");
		Response resp0 = createCategory(categories0, userId, userPassword);
		if (resp0.getStatusCode().intValue()==0) return (Category)resp0.getResult();		

		return null;
	}
	
	private Category getPredefinedCategoryPasswords(String userId, String userPassword) {
		
		Category categories0 = new Category();
		categories0.setIdx(-1);
		categories0.setType(Messages.getString("ManagerBean.3"));
		categories0.setParentId("0");
		categories0.setPreDefined(true);
		categories0.setName(Messages.getString("ManagerBean.SavedPass"));
		categories0.setIcon("personas_category_icon");
		categories0.setSelectedIcon("personas_category_selected_icon");
		Response resp0 = createCategory(categories0, userId, userPassword);
		if (resp0.getStatusCode().intValue()==0) return (Category)resp0.getResult();		

		return null;
	}
	
	private Category getPredefinedCategoryWebsites(String userId, String userPassword) {
		
		Category categories1 = new Category();
		categories1.setIdx(-2);
		categories1.setType(Messages.getString("ManagerBean.2"));
		categories1.setParentId("0");
		categories1.setPreDefined(true);
		categories1.setName(Messages.getString("ManagerBean.FromWebSite"));
		categories1.setIcon("website_category_icon");
		categories1.setSelectedIcon("website_category_selected_icon");
		Response resp1 =createCategory(categories1, userId, userPassword);
		if (resp1.getStatusCode().intValue()==0) return (Category) resp1.getResult();
		
		return null;
	}

	/**
	 * @param rootCategory
	 * @param cards
	 * @return rootCategory
	 */
	private static Category allocateCardByCategory(Category rootCategory, Card[] cards) {
		ArrayList cardList = new ArrayList();
		for (Iterator iterator = rootCategory.getCardList().iterator(); iterator.hasNext();) {
			String cardCUID = (String) iterator.next();
			for (int i = 0; i < cards.length; i++) {
				if ((cards[i].getCuid().equals(cardCUID)) && (!cards[i].isRelationCatagory().booleanValue())) {
					cards[i].setRelationCatagory(new Boolean(true));
					cardList.add(cards[i]);
				}
			}
		}
		rootCategory.setCardList(cardList);

		for (Iterator iterator = rootCategory.getChildList().iterator(); iterator.hasNext();) {
			Category category = (Category) iterator.next();
			//if (!category.isPreDefined()) 
				category = allocateCardByCategory(category, cards);
		}
		return rootCategory;
	}

	/**
	 * @param rootCategory
	 * @param cards
	 * @return rootCategory
	 */
	private static Category allocateOtherCardToPredefinedCategory(Category rootCategory, Card[] cards, String personalCategoryId, String websitesCategoryId, String passwordsCategoryId) {

		for (Iterator iterator = rootCategory.getChildList().iterator(); iterator.hasNext();) {
			Category category = (Category) iterator.next();
			// search personas cards
			if (category.getId().equals(personalCategoryId)) {

				for (int i = 0; i < cards.length; i++) {

					if (!cards[i].isRelationCatagory().booleanValue()) {
						if (cards[i].getCardType().equals("IPersonalInformationCard")) {
							category.getCardList().add(cards[i]);
							cards[i].setRelationCatagory(new Boolean(true));
						}
					}
				}

				// search cards from web site
			} else if (category.getId().equals(websitesCategoryId)) {
				for (int i = 0; i < cards.length; i++) {

					if (!cards[i].isRelationCatagory().booleanValue()) {
						if (cards[i].getCardType().equals("IManagedInformationCard")) {
							category.getCardList().add(cards[i]);
							cards[i].setRelationCatagory(new Boolean(true));
						}
					}
				}
			} else if (category.getId().equals(passwordsCategoryId)) {
				for (int i = 0; i < cards.length; i++) {

					if (!cards[i].isRelationCatagory().booleanValue()) {
						if (cards[i].getCardType().equals("IPwmCard")) {
							category.getCardList().add(cards[i]);
							cards[i].setRelationCatagory(new Boolean(true));
						}
					} //implement!
				}
			}
		}

		return rootCategory;
	}

	/**
	 * @param userId
	 * @param userPassword
	 * @return CurrentState
	 */
	public Response getCurrentState(String userId, String userPassword) {
		Response response = new Response();
		Response userDataResponse = wsClient.getUserData(userId, userPassword);
		if (!new Integer(0).equals(userDataResponse.getStatusCode())) {
			response.setStatusCode(userDataResponse.getStatusCode());
			return response;
		}

		ArrayList categoryList = new ArrayList();
		ArrayList serverCategoryList = ((UserData) userDataResponse.getResult()).getCategoryList();
		Card[] cards = ((UserData) userDataResponse.getResult()).getCards();
		//checking for existing predefined categories
		String personasExists = null;
		String websitesExists = null;
		String passwordsExists = null;
		
			for (int i=0; i<serverCategoryList.size(); i++)
			{
				if (Messages.getString("ManagerBean.1").equals(((Category)serverCategoryList.get(i)).getType()))
					if (personasExists == null) 
						personasExists = ((Category)serverCategoryList.get(i)).getId();
					else
						deleteCategory((Category)serverCategoryList.get(i), userId, userPassword);
				if (Messages.getString("ManagerBean.2").equals(((Category)serverCategoryList.get(i)).getType()))
					if (websitesExists == null) 
						websitesExists = ((Category)serverCategoryList.get(i)).getId();
					else
						deleteCategory((Category)serverCategoryList.get(i), userId, userPassword);
				if (Messages.getString("ManagerBean.3").equals(((Category)serverCategoryList.get(i)).getType()))
					if (passwordsExists == null) 
						passwordsExists = ((Category)serverCategoryList.get(i)).getId();
					else
						deleteCategory((Category)serverCategoryList.get(i), userId, userPassword);
			}
			
			if (personasExists == null)
				{
					Category personasCategory = getPredefinedCategoryPersonas(userId, userPassword);
					personasExists = personasCategory.getId();
					categoryList.add(personasCategory);
				}
			if (websitesExists == null)
				{
					Category websitesCategory = getPredefinedCategoryWebsites(userId, userPassword);
					websitesExists = websitesCategory.getId();
					categoryList.add(websitesCategory);
				}
			if (passwordsExists == null)
			{
				Category passwordsCategory = getPredefinedCategoryPasswords(userId, userPassword);
				passwordsExists = passwordsCategory.getId();
				categoryList.add(passwordsCategory);
			}
			
		categoryList.addAll(serverCategoryList);		
		Category rootCategory = buildCategoryTree(new Category(Messages.getString("ManagerBean.0"), Messages.getString("ManagerBean.0")),
				categoryList);

		rootCategory = allocateCardByCategory(rootCategory, cards);
		rootCategory = allocateOtherCardToPredefinedCategory(rootCategory, cards, personasExists, websitesExists, passwordsExists);		

		CurrentState currentState = new CurrentState();
		currentState.setCategory(rootCategory);

		response.setResult(currentState);
		response.setStatusCode(new Integer(0));
		return response;
	}

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response processLogon(String userIdentifier, String userPassword) {
		return wsClient.getUserProfile(userIdentifier, userPassword);
		// return wsClient.getUserProfile("Shelty_ash", "password");
	}

	/**
	 * @param userProfile
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response modifyUserProfile(UserProfile userProfile, String userIdentifier, String userPassword) {
		return wsClient.modifyUserProfile(userProfile, userIdentifier, userPassword);
	}

	/**
	 * @param card
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response modifyICard(Card card, String userIdentifier, String userPassword) {
		return wsClient.modifyICard(card, userIdentifier, userPassword);
	}

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response getICardTemplate(String userIdentifier, String userPassword) {
		return wsClient.getICardTemplate(userIdentifier, userPassword);
	}

	/**
	 * @param cardTemplate
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response createICard(CardTemplate cardTemplate, String userIdentifier, String userPassword) {
		return wsClient.createICard(cardTemplate, userIdentifier, userPassword);
	}

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response createCategory(Category category, String userIdentifier, String userPassword) {
		return wsClient.createCategory(category, userIdentifier, userPassword);
	}

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response modifyCategory(Category category, String userIdentifier, String userPassword) {
		return wsClient.modifyCategory(category, userIdentifier, userPassword);
	}

	/**
	 * @param category
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response deleteCategory(Category category, String userIdentifier, String userPassword) {
		return wsClient.deleteCategory(category.getId(), userIdentifier, userPassword);
	}

	/**
	 * @param cuid
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response deleteICard(String cuid, String userIdentifier, String userPassword) {
		return wsClient.deleteICard(cuid, userIdentifier, userPassword);
	}

	/**
	 * @param card
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response getCardByCredential(Card card, String userIdentifier, String userPassword) {
		return wsClient.getCardByCredential(card, userIdentifier, userPassword);
	}

	/**
	 * @param cuid
	 * @param pin
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response setPinCode(String cuid, String pin, String userIdentifier, String userPassword) {
		return wsClient.setPinCode(cuid, pin, userIdentifier, userPassword);
	}
	
	public Response editPinCode(String userId, String password, String cuid, String oldPinCode, String newPinCode) {
		return wsClient.editPinCode(userId, password, cuid, oldPinCode, newPinCode);
	}

	/**
	 * @param cuid
	 * @param pin
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response resetPinCode(String cuid, String pin, String userIdentifier, String userPassword) {
		return wsClient.resetPinCode(cuid, pin, userIdentifier, userPassword);
	}

	/**
	 * @param cuid
	 * @param cardName
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response createDuplicateCard(String cuid, String cardName, String pinCode, String userIdentifier, String userPassword) {
		return wsClient.createDuplicateICard(cuid, cardName, pinCode, userIdentifier, userPassword);
	}

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @return
	 */
	public Response deleteAllCard(String userIdentifier, String userPassword) {
		return wsClient.deleteAllCard(userIdentifier, userPassword);
	}

	/**
	 * @param userIdentifier
	 * @param userPassword
	 * @param fileData
	 * @return
	 */
	public Response importCards(String userIdentifier, String userPassword, byte[] fileData) {
		return wsClient.importICards(userIdentifier, userPassword, fileData);
	}

	public Response getCardInformation(String cuid, String userIdentifier, String userPassword, int size) {
		return wsClient.getCardInformation(cuid, userIdentifier, userPassword, size);
	}

	public Response clearCardHistory(String userId, String password, String cuid) {
		return wsClient.clearCardHistory(userId, password, cuid);
	}

	public Response setUrlsCardRelation(String userId, String password, String cuid, String[] urls) {
		return wsClient.setUrlsCardRelation(userId, password, cuid, urls);
	}

	public Response deleteUrlsCardRelation(String userId, String password, String cuid, String[] urls) {
		return wsClient.deleteUrlsCardRelation(userId, password, cuid, urls);
	}

	public Response clearCardCredential(String userId, String password, String cuid) {
		return wsClient.clearCardCredential(userId, password, cuid);
	}

	public Response putImageForIE(String image, HttpSession session) {
		Response response = new Response();
		try {
			String key = image.substring(image.length() - 20).replace('+','_').replace('=','_');
			session.setAttribute(key, image);
			response.setStatusCode(new Integer(0));
		} catch (Exception e) {
			response.setStatusCode(ErrorKeys.ERROR_CODE_Exception);
			response.setStatusMessage(e.getMessage());
		}
		return response;
	}
	
	public Response putFileToSession(byte[] file, HttpSession session) {
		Response response = new Response();
		try {
			session.setAttribute("backupfile", file);
			response.setStatusCode(new Integer(0));
		} catch (Exception e) {
			response.setStatusCode(ErrorKeys.ERROR_CODE_Exception);
			response.setStatusMessage(e.getMessage());
		}
		return response;
	}
	
	public byte[] getFileFromSession(HttpSession session) {
		return (byte[])session.getAttribute("backupfile");
	}
	
	public Response modifyCategories(String userId, String password, Category[] categories)
	{
		return wsClient.modifyCategories(userId, password, categories);
	}
	
	public Response setCardCredential(String userId, String password, String cuid, CardCredential tokenCredential) {
		return wsClient.setCardCredential(userId, password, cuid, tokenCredential);
	}
	
	public Response getCardById(String cuid, String userIdentifier, String userPassword)
	{
		return wsClient.getCardById(cuid, userIdentifier, userPassword);
	}
	
	public Response checkImportStream(String userId, String password, byte[] crd) {
		return wsClient.checkImportStream(userId, password, crd);
	}
	
	public Response putCredentialForRestore(String userIdentifier, String userPassword, byte[] fileData, FormatDescriptor descriptor) {
		return wsClient.getICardsFromRestoreAndFormatDescriptor(userIdentifier, userPassword, descriptor.getFormatID(), fileData, Utils.cardCredential2UITokenServiceCredentialTO(descriptor.getCardCredential()));
	}
	
	public Response getCardHistory(String userId, String password, String cuid, int startFrom, int capacity, String orderBy, String orderDirection) {
		return wsClient.getCardHistory(userId, password, cuid, startFrom, capacity, orderBy, orderDirection);
	}
	
	public Response getOutputFormats(String userId, String password) {
		return wsClient.getOutputFormats(userId, password);
	}
	
	public Response getICardsByFormat(String userId, String password, String formatID) {
		return wsClient.getICardsByFormat(userId, password, formatID);		
	}
	
	public Response exportICards(String userId, String password, String formatID, String[] cards, CardCredential credential) {
		return wsClient.exportICards(userId, password, formatID, cards, credential);
	}
	
	public Response getMRU(String userId, String password) {
		return wsClient.getMRU(userId, password);
	}
	
	public Response updateClaimAcrossCards(String userId, String password, String claimType, String claimValue, CardUpdate[] cardUpdate) {
		return wsClient.updateClaimAcrossCards(userId, password, claimType, claimValue, cardUpdate);
	}

	/**
	 * @return the wsClient
	 */
	public WSClient getWsClient() {
		return this.wsClient;
	}
}
