package org.eclipse.higgins.ics.model.bean;

import javax.servlet.http.HttpSession;

import org.apache.axis.handlers.SimpleSessionHandler;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.BaseEntity;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUpdate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ErrorKeys;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.GWTResponse;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Response;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;
import org.eclipse.higgins.ics.gwt.icm.client.ICMService;
import org.eclipse.higgins.ics.util.WebKeys;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public class RPCBean extends RemoteServiceServlet implements ICMService {

	private static final long serialVersionUID = 1L;

	private ManagerBean managerBean = new ManagerBean();

	private HttpSession getHttpSession() {
		return getThreadLocalRequest().getSession();
	}

	private void getAxisSessionId() {
		Long asid = this.managerBean.getWsClient().getService().getEngine().getOption(SimpleSessionHandler.SESSION_ID) != null ? (Long) this.managerBean
				.getWsClient().getService().getEngine().getOption(SimpleSessionHandler.SESSION_ID)
				: new Long(0);
		getHttpSession().setAttribute(WebKeys.AXIS_SESSION_ID, asid);
	}

	private void setAxisSessionId() {
		Long asid = getHttpSession().getAttribute(WebKeys.AXIS_SESSION_ID) != null ? new Long(getHttpSession().getAttribute(
				WebKeys.AXIS_SESSION_ID).toString()) : new Long(0);
		this.managerBean.getWsClient().getService().getEngine().setOption(SimpleSessionHandler.SESSION_ID, asid);
	}

	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#getCurrentState(java.lang.String, java.lang.String)
	 */
	public GWTResponse getCurrentState(String userId, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.getCurrentState(userId, userPassword));
	}

	private  GWTResponse response2GWTResponse(Response response) {
		getAxisSessionId();
		GWTResponse gwtResponse = new GWTResponse();
		if (response.getResult() != null) {
			if (response.getResult() instanceof BaseEntity) {
				gwtResponse.setResult((BaseEntity) response.getResult());
				gwtResponse.setStatusCode(response.getStatusCode());
				gwtResponse.setStatusMessage(response.getStatusMessage());
			} else if (response.getResult() instanceof BaseEntity[]) {
				BaseEntity[] entities = (BaseEntity[]) response.getResult();
				// for (int i = 0; i < entities.length; i++) {
				// }
				gwtResponse.setResult(entities[0]);
				gwtResponse.setStatusCode(response.getStatusCode());
				gwtResponse.setStatusMessage(response.getStatusMessage());
			} else {
				gwtResponse.setStatusCode(ErrorKeys.ERROR_CODE_UnserializableResult);
			}
		} else {
			gwtResponse.setStatusCode(response.getStatusCode());
			gwtResponse.setStatusMessage(response.getStatusMessage());
		}
		return gwtResponse;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#modifyUserProfile(org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile)
	 */
	public GWTResponse modifyUserProfile(UserProfile userProfile) {
		String ip = getThreadLocalRequest().getRemoteHost();
		userProfile.setUsedFrom(ip);
		return response2GWTResponse(managerBean.modifyUserProfile(userProfile, userProfile.getLoginName(), userProfile.getPassword()));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#modifyCard(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
	 *      java.lang.String, java.lang.String)
	 */
	public GWTResponse modifyCard(Card card, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.modifyICard(card, userIdentifier, userPassword));
	}

	public GWTResponse createICard(CardTemplate cardTemplate, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.createICard(cardTemplate, userIdentifier, userPassword));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#getPCardTemplate(java.lang.String, java.lang.String)
	 */
	public GWTResponse getPCardTemplate(String userIdentifier, String userPassword) {
		// Only first template will be returned.
		// Needs rules for choosing correct one.
		setAxisSessionId();
		return response2GWTResponse(managerBean.getICardTemplate(userIdentifier, userPassword));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#deleteICard(java.lang.String, java.lang.String,
	 *      java.lang.String)
	 */
	public GWTResponse deleteICard(String cuid, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.deleteICard(cuid, userIdentifier, userPassword));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#getCardByCredential(org.eclipse.higgins.ics.gwt.base.client.model.entity.Card,
	 *      java.lang.String, java.lang.String)
	 */
	public GWTResponse getCardByCredential(Card card, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.getCardByCredential(card, userIdentifier, userPassword));
	}
	
	public GWTResponse setCardCredential(String userId, String password, String cuid, CardCredential tokenCredential) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.setCardCredential(userId, password, cuid, tokenCredential));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#setPinCode(java.lang.String, java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public GWTResponse setPinCode(String cuid, String pin, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.setPinCode(cuid, pin, userIdentifier, userPassword));
	}
	
	public GWTResponse editPinCode(String userId, String password, String cuid, String oldPinCode, String newPinCode) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.editPinCode(userId, password, cuid, oldPinCode, newPinCode));
	}

	public GWTResponse resetPinCode(String cuid, String pin, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.resetPinCode(cuid, pin, userIdentifier, userPassword));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#createDuplicateCard(java.lang.String, java.lang.String,
	 *      java.lang.String, java.lang.String)
	 */
	public GWTResponse createDuplicateCard(String cuid, String cardName, String pinCode, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.createDuplicateCard(cuid, cardName, pinCode, userIdentifier, userPassword));
	}

	/*
	 * http://graceland.parityinc.net/svn/parity/config/rh155.sohosmart.net/tomcat/conf (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#deleteAllCard(java.lang.String, java.lang.String)
	 */
	public GWTResponse deleteAllCard(String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.deleteAllCard(userIdentifier, userPassword));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#getUserProfile()
	 */
	public GWTResponse getUserProfile() {
		GWTResponse gwtResponse = new GWTResponse();
		Object userProfileObject = getHttpSession().getAttribute(WebKeys.USER_PROFILE);
		if (userProfileObject instanceof UserProfile) {
			UserProfile userProfile = (UserProfile) userProfileObject;
			gwtResponse.setResult(userProfile);
			gwtResponse.setStatusCode(new Integer(0));
			// getHttpSession().removeAttribute(WebKeys.USER_PROFILE);
		} else {
			gwtResponse.setStatusCode(ErrorKeys.ERROR_CODE_UnauthorizationResult);
		}
		return gwtResponse;
	}

	public Card[] getImportedCard() {
		return (Card[]) getHttpSession().getAttribute("imported");
	}
	
	public FormatDescriptor getRestoreData() {
		return (FormatDescriptor) getHttpSession().getAttribute("forestore");
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#createCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category,
	 *      java.lang.String, java.lang.String)
	 */
	public GWTResponse createCategory(Category category, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.createCategory(category, userIdentifier, userPassword));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#modifyCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category,
	 *      java.lang.String, java.lang.String)
	 */
	public GWTResponse modifyCategory(Category category, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.modifyCategory(category, userIdentifier, userPassword));
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.higgins.ics.gwt.icm.client.ICMService#deleteCategory(org.eclipse.higgins.ics.gwt.base.client.model.entity.Category,
	 *      java.lang.String, java.lang.String)
	 */
	public GWTResponse deleteCategory(Category category, String userIdentifier, String userPassword) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.deleteCategory(category, userIdentifier, userPassword));
	}

	public GWTResponse putImageForIE(String image) {
		return response2GWTResponse(managerBean.putImageForIE(image, getHttpSession()));
	}

	public GWTResponse getCardInformation(String cuid, String userIdentifier, String userPassword, int size) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.getCardInformation(cuid, userIdentifier, userPassword, size));
	}

	//TODO ask Sergey
	public GWTResponse setUrlsCardRelation(String userId, String password, String cuid, String[] urls) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.setUrlsCardRelation(userId, password, cuid, urls));
	}
	
	public GWTResponse deleteUrlsCardRelation(String userId, String password, String cuid, String[] urls) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.deleteUrlsCardRelation(userId, password, cuid, urls));
	}

	public GWTResponse clearCardHistory(String userId, String password, String cuid) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.clearCardHistory(userId, password, cuid));
	}

	public GWTResponse clearCardCredential(String userId, String password, String cuid) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.clearCardCredential(userId, password, cuid));
	}
	public GWTResponse modifyCategories(String userId, String password, Category[] categories)
	{
		setAxisSessionId();
		return response2GWTResponse(managerBean.modifyCategories(userId, password, categories));
	}
	
	public GWTResponse getCardById(String cuid, String userIdentifier, String userPassword)
	{
		setAxisSessionId();
		return response2GWTResponse(managerBean.getCardById(cuid, userIdentifier, userPassword));
	}
	
	public GWTResponse putCredentialForRestore(FormatDescriptor descriptor, String userIdentifier, String userPassword) {
		byte[] restoreFile = (byte[])getHttpSession().getAttribute("restoredfile");
		//getHttpSession().removeAttribute("restoredfile");
		return response2GWTResponse(managerBean.putCredentialForRestore(userIdentifier, userPassword, restoreFile, descriptor));
	}
	
	public GWTResponse getCardHistory(String userId, String password, String cuid, int startFrom, int capacity, String orderBy, String orderDirection) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.getCardHistory(userId, password, cuid, startFrom, capacity, orderBy, orderDirection));
	}
	
	public GWTResponse getOutputFormats(java.lang.String userId, java.lang.String password) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.getOutputFormats(userId, password));
	}
	
	public GWTResponse getICardsByFormat(String userId, String password, String formatID) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.getICardsByFormat(userId, password, formatID));
	}
	
	public GWTResponse exportICards(String userId, String password, String formatID, String[] cards, CardCredential credential) {
		setAxisSessionId();
		Response response = managerBean.exportICards(userId, password, formatID, cards, credential);
		managerBean.putFileToSession((byte[])response.getResult(), getHttpSession());
		GWTResponse gwtResponse = new GWTResponse();
		gwtResponse.setStatusCode(response.getStatusCode());
		gwtResponse.setStatusMessage(response.getStatusMessage());
		return gwtResponse;
	}
	
	public GWTResponse getMRU(String userId, String password) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.getMRU(userId, password));
	}
	
	public GWTResponse updateClaimAcrossCards(String userId, java.lang.String password, String claimType, String claimValue, CardUpdate[] cardUpdate) {
		setAxisSessionId();
		return response2GWTResponse(managerBean.updateClaimAcrossCards(userId, password, claimType, claimValue, cardUpdate));
	}
}
