package org.eclipse.higgins.ics.model.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.eclipse.higgins.ics.gwt.base.client.model.entity.Response;
import org.eclipse.higgins.ics.model.bean.ManagerBean;
import org.eclipse.higgins.ics.util.WebKeys;

/**
 * Servlet implementation class for Servlet: LogonServlet
 * 
 */
public class LogonServlet extends javax.servlet.http.HttpServlet implements javax.servlet.Servlet {
	static final long serialVersionUID = 1L;
	
	private ManagerBean bean = new ManagerBean();

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#HttpServlet()
	 */
	public LogonServlet() {
		super();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
		doPost(req, resp);
	}

	/*
	 * (non-Java-doc)
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		try {
			HttpSession session = request.getSession();
			if (session != null) {
				session.removeAttribute(WebKeys.USER_PROFILE);
			}
			/*String s = (String)session.getServletContext().getAttribute("U");
			session.getServletContext().removeAttribute("U");
			if (s == null) 
				session.getServletContext().setAttribute("U", "uuu");
			*/// String xmlToken = request.getParameter("xmlToken");
			String login = request.getParameter("login");
			String password0 = request.getParameter("password");
			String password1 = request.getParameter("password1");
			if (login != null && 
					password0 != null && 
					request.getParameter("authbycookie")!= null) {
				String[] str = new String[] {login, password0, password1};
				String sid = request.getAttribute("javax.servlet.request.ssl_session")!=null?request.getAttribute("javax.servlet.request.ssl_session").toString():"";
				session.getServletContext().setAttribute(sid, str);
				/*Cookie cookie1 = new Cookie("hlogin", login);
				cookie1.setMaxAge(300);
				cookie1.setSecure(true);
				response.addCookie(cookie1);
				Cookie cookie2 = new Cookie("hpassword0", password0);
				cookie2.setMaxAge(300);
				cookie1.setSecure(true);
				response.addCookie(cookie2);
				Cookie cookie3 = new Cookie("hpassword1", password1);
				cookie3.setMaxAge(300);
				cookie1.setSecure(true);
				response.addCookie(cookie3);*/
				response.getOutputStream().print(sid);
				return;
			} 
			if (request.getParameter("autologin")!=null) {
				/*Cookie[] cookies = request.getCookies();
				for (int i=0; i<cookies.length; i++) {
					if (cookies[i].getName().equals("hlogin")) 
						login = cookies[i].getValue();
					if (cookies[i].getName().equals("hpassword0")) 
						password0 = cookies[i].getValue();
					if (cookies[i].getName().equals("hpassword1")) 
						password1 = cookies[i].getValue();
				}*/
				String autologin = request.getParameter("autologin");
				String[] str = (String[])session.getServletContext().getAttribute(autologin);
				if (str != null) {
					login = str[0];
					password0 = str[1];
					password1 = str[2];
				}
				session.getServletContext().removeAttribute(autologin);
			}
				String password = ((password0 != null && password0.length() > 0) ? password0 : "")
				+ ((password1 != null && password1.length() > 0) ? password1 : "");
		int logType = Integer.parseInt(request.getParameter("logtype") != null ? request.getParameter("logtype") : "0");
		Response resp = bean.processLogon(login, password);
		if (resp.getStatusCode().equals(new Integer(0))) {
			session.setAttribute(WebKeys.USER_PROFILE, resp.getResult());
			response.sendRedirect(WebKeys.URI_MAIN);
		} else {
			response.sendRedirect(WebKeys.URI_ERROR);
		}
			
		} catch (Exception e) {
			e.printStackTrace();
			response.sendRedirect(WebKeys.URI_ERROR);
		}

	}
}