/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.ws.client;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

import javax.imageio.ImageIO;

import org.apache.axis.encoding.Base64;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Card;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardCredential;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardInformation;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardTemplateItem;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUpdate;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.CardUsage;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.Category;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.ClaimItem;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.FormatDescriptor;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.MRU;
import org.eclipse.higgins.ics.gwt.base.client.model.entity.UserProfile;
import org.eclipse.higgins.ics.model.Messages;
import org.eclipse.higgins.ics.ws.wsdl.CardInformationTO;
import org.eclipse.higgins.ics.ws.wsdl.CardUsageTO;
import org.eclipse.higgins.ics.ws.wsdl.CategoryTO;
import org.eclipse.higgins.ics.ws.wsdl.FormatDescriptorTO;
import org.eclipse.higgins.ics.ws.wsdl.ICardTO;
import org.eclipse.higgins.ics.ws.wsdl.ICardTemplateTO;
import org.eclipse.higgins.ics.ws.wsdl.ICardUpdateTO;
import org.eclipse.higgins.ics.ws.wsdl.ITemplateElementTO;
import org.eclipse.higgins.ics.ws.wsdl.MapTO;
import org.eclipse.higgins.ics.ws.wsdl.PropertyTO;
import org.eclipse.higgins.ics.ws.wsdl.UITokenServiceCredentialTO;
import org.eclipse.higgins.ics.ws.wsdl.UserProfileTO;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class Utils {

	/**
	 * @param cardTemplate
	 * @param cardTemplateTO
	 * @return
	 */
	public static ICardTemplateTO cardTemplate2cardTemplateTO(final CardTemplate cardTemplate) {
		ICardTemplateTO cardTemplateTO = new ICardTemplateTO();
		if (cardTemplate != null && cardTemplateTO != null) {
			try {
				cardTemplateTO.setId(cardTemplate.getId());
				cardTemplateTO.setName(cardTemplate.getName());
				cardTemplateTO.setDescription(cardTemplate.getDescription());
				cardTemplateTO.setProviderID(cardTemplate.getProviderID());
				cardTemplateTO.setCardType(cardTemplate.getCardType());
				cardTemplateTO.setProviderName(cardTemplate.getProviderName());
				if (cardTemplate.getCardTemplateItems() != null && cardTemplate.getCardTemplateItems().length > 0) {
					ITemplateElementTO[] templateElementTOs = new ITemplateElementTO[cardTemplate.getCardTemplateItems().length];
					for (int i = 0; i < cardTemplate.getCardTemplateItems().length; i++) {
						templateElementTOs[i] = cardTemplateItem2templateElementTO(new ITemplateElementTO(), cardTemplate
								.getCardTemplateItems()[i]);

					}
					cardTemplateTO.setElements(templateElementTOs);
				}
			} catch (RuntimeException e) {
				e.printStackTrace();
			}
		}
		return cardTemplateTO;
	}

	/**
	 * @param elementTO
	 * @param cardTemplateItem
	 * @return elementTO
	 */
	public static ITemplateElementTO cardTemplateItem2templateElementTO(ITemplateElementTO elementTO,
			final CardTemplateItem cardTemplateItem) {
		if (elementTO != null) {
			elementTO.setId(cardTemplateItem.getId());
			elementTO.setDescription(cardTemplateItem.getDescription());
			elementTO.setName(cardTemplateItem.getName());
			elementTO.setType(cardTemplateItem.getValueType());
			elementTO.setPattern(cardTemplateItem.getPattern());
			elementTO.setInputMask(cardTemplateItem.getInputMask());
			if (cardTemplateItem.getContainerValue() != null && cardTemplateItem.getContainerValue().length > 0) {
				ITemplateElementTO[] templateElementTOs = new ITemplateElementTO[cardTemplateItem.getContainerValue().length];
				for (int i = 0; i < cardTemplateItem.getContainerValue().length; i++) {
					try {
						templateElementTOs[i] = cardTemplateItem2templateElementTO(new ITemplateElementTO(),
								(CardTemplateItem) cardTemplateItem.getContainerValue()[i]);
					} catch (RuntimeException e) {
					}
				}
				elementTO.setContainerValue(templateElementTOs);

			} else {
				elementTO.setValue(cardTemplateItem.getValue());
			}
		}
		return elementTO;
	}

	/**
	 * @param cardTemplateTO
	 * @return
	 */
	public static CardTemplate cardTemplateTO2cardTemplate(final ICardTemplateTO cardTemplateTO) {
		final CardTemplate cardTemplate = new CardTemplate();
		if (cardTemplateTO != null) {
			cardTemplate.setId(cardTemplateTO.getId());
			cardTemplate.setName(cardTemplateTO.getName());
			cardTemplate.setCardType(cardTemplateTO.getCardType());
			cardTemplate.setProviderID(cardTemplateTO.getProviderID());
			cardTemplate.setProviderName(cardTemplateTO.getProviderName());
			try {
				if (cardTemplateTO.getElements() != null && cardTemplateTO.getElements().length > 0) {
					final CardTemplateItem[] cardTemplateItems = new CardTemplateItem[cardTemplateTO.getElements().length];
					for (int i = 0; i < cardTemplateTO.getElements().length; i++) {
						cardTemplateItems[i] = templateElementTO2cardTemplateItem(cardTemplateTO.getElements()[i]);
					}
					cardTemplate.setCardTemplateItems(cardTemplateItems);
				}
			} catch (RuntimeException e) {
				e.printStackTrace();
			}
		}
		return cardTemplate;
	}

	public static CardInformation cardInformationTO2CardInformation(final CardInformationTO ciTO, CardInformation ci) {
		if (ciTO != null) {
			final CardUsageTO[] cuTOs = ciTO.getCardHistory();
			if (cuTOs != null) {
				final CardUsage[] cus = new CardUsage[cuTOs.length];
				for (int i = 0; i < cuTOs.length; i++) {
					if (cuTOs[i] != null)
						cus[i] = cardUsageTO2CardUsage(cuTOs[i], cus[i]);
				}
				ci.setCardHistory(cus);
			}
			ci.setHistorySize(ciTO.getSizeHistory());
			ci.setSortBy("date");
			ci.setSortOrder("ASC");
			ci.setStartsFrom(0);
		}
		return ci;
	}

	public static CardUsage cardUsageTO2CardUsage(final CardUsageTO cuTO, CardUsage cu) {
		Calendar cdate = cuTO.getDate();
		SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy 'at' hh:mm a");
		String date = cdate != null ? formatter.format(cdate.getTime()) : "Unknown";
		CardUsage ccu = new CardUsage(date, cuTO.getSite(), cuTO.isUseAlways());
		return ccu;
	}

	/**
	 * @param cardTO
	 * @param card
	 * @return
	 */
	public static Card ICardTO2Card(final ICardTO cardTO, Card card) {
		// card.setIcardTO(cardTO);
		// TODO rename
		card.setId(cardTO.getId());
		card.setCardType(cardTO.getType());
		card.setCuid(cardTO.getCuid());
		card.setName(cardTO.getName());
		card.setExpiredTime(cardTO.getExpiredTime() != null ? cardTO.getExpiredTime().getTime() : null);
		card.setImageType(cardTO.getImageType());
		card.setIssuerName(cardTO.getIssuerName());
		card.setSelfIssued(new Boolean(cardTO.isSelfIssued()));
		try {
			InputStream is = new ByteArrayInputStream(cardTO.getImage());
			BufferedImage cardImage = ImageIO.read(is);
			int[] dim = Utils.getOptimalPictureSize(cardImage.getHeight(), cardImage.getWidth());

			if (cardTO.isSelfIssued()) {
				try {
					if (cardImage.getHeight() > 120 || cardImage.getWidth() > 120)
						card.setImage(Base64.encode(getScaledImg(dim[1], dim[0], cardImage)));
					else
						card.setImage(Base64.encode(cardTO.getImage()));
				} catch (Exception e) {

					card.setImage(Base64.encode(cardTO.getImage()));

				}
			} else {
				try {
					card.setImage(Base64.encode(getScaledImg(dim[1], dim[0], cardImage)));
					is.close();

				} catch (Exception e) {
					try {
						card.setImage(Base64.encode(cardTO.getImage()));
					} catch (Exception ex) {
					}
				}
			}

		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		if (cardTO.getProperties() != null) {
			ClaimItem[] claimItems = new ClaimItem[cardTO.getProperties().length];
			for (int j = 0; j < cardTO.getProperties().length; j++) {
				PropertyTO prop = cardTO.getProperties()[j];
				String pVal = "";
				if (prop.getValue() != null) {
					if (prop.getValue().length > 0) {
						for (int k = 0; k < prop.getValue().length; k++) {
							pVal += prop.getValue()[k];
						}
					}
				}
				claimItems[j] = propertyTO2ClaimItem(prop);
			}

			card.setClaimItems(claimItems);
		}
		if (cardTO.getTokenServiceCredentials() != null && cardTO.getTokenServiceCredentials().length > 0) {
			CardCredential[] cardCredentials = new CardCredential[cardTO.getTokenServiceCredentials().length];
			boolean isSaveCredential = false;
			for (int i = 0; i < cardTO.getTokenServiceCredentials().length; i++) {
				cardCredentials[i] = uiTokenServiceCredentialTO2CardCredential(cardTO.getTokenServiceCredentials()[i]);
				isSaveCredential = isSaveCredential || cardTO.getTokenServiceCredentials()[i].isSaveCredential();
			}
			if (!card.getSelfIssued().booleanValue())
				card.setIsSaveCredential(isSaveCredential);
			else
				card.setIsSaveCredential(false);
			card.setCardCredential(cardCredentials);
			card.setProtected(true);
			card.setValueAvailable(false);
		} else {
			card.setProtected(false);
			if (cardTO.isSelfIssued())
				card.setValueAvailable(true);
			else
				card.setValueAvailable(false);
		}
		return card;
	}

	public static int[] getOptimalPictureSize(int height, int width) {
		int[] res = { 0, 0 };
		final float MAX_LENGTH = 120;
		float ratio = 1f;
		if (height > width) {
			if (height >= MAX_LENGTH) {
				ratio = (float) height / MAX_LENGTH;
				res[0] = java.lang.Math.round(MAX_LENGTH);
				res[1] = java.lang.Math.round((float) width / ratio);
			} else {

				res[0] = height;
				res[1] = width;
			}
		} else {
			if (width >= MAX_LENGTH) {
				ratio = (float) width / MAX_LENGTH;
				res[0] = java.lang.Math.round((float) height / ratio);
				res[1] = java.lang.Math.round(MAX_LENGTH);
			} else {
				res[0] = height;
				res[1] = width;
			}
		}

		return res;
	}

	/**
	 * @param card
	 * @param cardTO
	 * @return
	 */
	public static ICardTO card2ICardTO(final Card card, final ICardTO cardTO) {
		// card.setIcardTO(cardTO);
		cardTO.setId(card.getId());
		cardTO.setType(card.getCardType());
		cardTO.setCuid(card.getCuid());
		cardTO.setName(card.getName());
		// card.setExpiredTime(cardTO.getExpiredTime() != null ?
		// GregorianCalendar.getInstance()
		// cardTO.getExpiredTime().getTime() : null);
		cardTO.setImageType(card.getImageType());
		cardTO.setIssuerName(card.getIssuerName());
		if (card.getImage()!=null) cardTO.setImage(Base64.decode(card.getImage()));
		cardTO.setSelfIssued(card.getSelfIssued().booleanValue());
		if (card.getSelfIssued().booleanValue()) {
			ClaimItem[] claimItems = card.getClaimItems();
			PropertyTO[] properties = new PropertyTO[claimItems.length];
			for (int i = 0; i < claimItems.length; i++) {
				ClaimItem claimItem = claimItems[i];
				properties[i] = claimItem2propertyTO(claimItem);
			}
			cardTO.setProperties(properties);
		}

		// if (cardTO.getProperties() != null) {
		// ClaimItem[] claimItems = new
		// ClaimItem[cardTO.getProperties().length];
		// for (int j = 0; j < cardTO.getProperties().length; j++) {
		// PropertyTO prop = cardTO.getProperties()[j];
		// String pVal = "";
		// if (prop.getValue() != null) {
		// if (prop.getValue().length > 0) {
		// for (int k = 0; k < prop.getValue().length; k++) {
		// pVal += prop.getValue()[k];
		// }
		// }
		// }
		// claimItems[j] = propertyTO2ClaimItem(prop);
		// }
		// card.setClaimItems(claimItems);
		// }

		if (card.getCardCredential() != null) {
			UITokenServiceCredentialTO[] responseTokenServices = new UITokenServiceCredentialTO[card.getCardCredential().length];
			for (int i = 0; i < card.getCardCredential().length; i++) {
				responseTokenServices[i] = cardCredential2UITokenServiceCredentialTO(card.getCardCredential()[i]);
			}
			cardTO.setTokenServiceCredentials(responseTokenServices);
		}
		return cardTO;
	}

	/**
	 * @param propertyTO
	 * @return
	 */
	public static ClaimItem propertyTO2ClaimItem(final PropertyTO propertyTO) {
		ClaimItem claimItem = new ClaimItem();
		claimItem.setName(propertyTO.getName());
		claimItem.setClaimType(propertyTO.getClaimType());
		claimItem.setValueType(propertyTO.getType());
		claimItem.setDescription(propertyTO.getName());
		claimItem.setValueTypeProperty(propertyTO.getValueType());

		String pVal = "";
		if (propertyTO.getValue() != null) {
			if (propertyTO.getValue().length > 0) {
				for (int k = 0; k < propertyTO.getValue().length; k++) {
					pVal += propertyTO.getValue()[k];
				}
			}
		}
		claimItem.setValue(pVal);
		if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(propertyTO.getClaimType())) {
			claimItem.setVisible(false);
		}

		// claimItem.setContainerValue(containerValue)
		return claimItem;
	}

	public static PropertyTO claimItem2propertyTO(final ClaimItem claimItem) {
		PropertyTO propertyTO = new PropertyTO();
		propertyTO.setName(claimItem.getName());
		propertyTO.setClaimType(claimItem.getClaimType());
		propertyTO.setType(claimItem.getValueType());
		propertyTO.setValueType(claimItem.getValueTypeProperty());
		propertyTO.setComplexValue(null);

		// if (claimItem.getValue() != null) {
		// if (claimItem.getValue().length > 0) {
		// for (int k = 0; k < claimItem.getValue().length; k++) {
		// pVal += claimItem.getValue()[k];
		// }
		// }
		// }
		propertyTO.setValue(new String[] { claimItem.getValue() });
		return propertyTO;
	}

	/**
	 * @param elementTO
	 * @return
	 */
	public static CardTemplateItem templateElementTO2cardTemplateItem(final ITemplateElementTO elementTO) {
		final CardTemplateItem cardTemplateItem = new CardTemplateItem();
		if (elementTO != null) {
			cardTemplateItem.setId(elementTO.getId());
			cardTemplateItem.setName(elementTO.getName());
			cardTemplateItem.setDescription(elementTO.getDescription());
			cardTemplateItem.setInputMask(elementTO.getInputMask());
			cardTemplateItem.setOptionalValues(elementTO.getOptionalValues());
			cardTemplateItem.setPattern(elementTO.getPattern());
			cardTemplateItem.setClaimType(elementTO.getId());
			cardTemplateItem.setValue(elementTO.getValue());
			cardTemplateItem.setValueRequired(elementTO.isIsValueRequired());
			cardTemplateItem.setValueType(elementTO.getType());
			if (elementTO.getContainerValue() != null && elementTO.getContainerValue().length > 0) {
				final CardTemplateItem[] cardTemplateItems = new CardTemplateItem[elementTO.getContainerValue().length];
				for (int i = 0; i < elementTO.getContainerValue().length; i++) {
					cardTemplateItems[i] = templateElementTO2cardTemplateItem(elementTO.getContainerValue()[i]);
				}
				cardTemplateItem.setContainerValue(cardTemplateItems);
			}
		}
		return cardTemplateItem;
	}

	// /**
	// * @param userCredentialTO
	// * @param userCredential
	// * @return
	// */
	// public static UserCredentialTO
	// userCredential2userCredentialTO(UserCredentialTO userCredentialTO,
	// UserCredential
	// userCredential) {
	// // UserCredentialTO userCredentialTO = new UserCredentialTO
	//
	// return userCredentialTO;
	// }

	public static CardCredential uiTokenServiceCredentialTO2CardCredential(final UITokenServiceCredentialTO tokenServiceCredentialTO) {
		CardCredential cardCredential = new CardCredential();
		cardCredential.setUsername(tokenServiceCredentialTO.getUsername());
		cardCredential.setPassword(tokenServiceCredentialTO.getPassword());
		cardCredential.setType(tokenServiceCredentialTO.getType());
		cardCredential.setAddress(tokenServiceCredentialTO.getAddress());
		cardCredential.setPinCode(tokenServiceCredentialTO.getPinCode());
		cardCredential.setMetadataAddress(tokenServiceCredentialTO.getMetadataAddress());

		return cardCredential;
	}

	public static FormatDescriptor formatDescriptorTO2FormatDescriptor(final FormatDescriptorTO formatTO) {
		FormatDescriptor formatDescriptor = new FormatDescriptor();
		formatDescriptor.setCardCredential(uiTokenServiceCredentialTO2CardCredential(formatTO.getCredential()));
		formatDescriptor.setFileExtension(formatTO.getFileExtension());
		formatDescriptor.setFormatID(formatTO.getFormatID());
		formatDescriptor.setName(formatTO.getName());
		return formatDescriptor;
	}

	public static UITokenServiceCredentialTO cardCredential2UITokenServiceCredentialTO(final CardCredential cardCredential) {
		UITokenServiceCredentialTO tokenServiceCredentialTO = new UITokenServiceCredentialTO();
		tokenServiceCredentialTO.setUsername(cardCredential.getUsername());
		tokenServiceCredentialTO.setPassword(cardCredential.getPassword());
		tokenServiceCredentialTO.setType(cardCredential.getType());
		tokenServiceCredentialTO.setAddress(cardCredential.getAddress());
		tokenServiceCredentialTO.setPinCode(cardCredential.getPinCode());
		tokenServiceCredentialTO.setMetadataAddress(cardCredential.getMetadataAddress());
		return tokenServiceCredentialTO;
	}

	/**
	 * @param userProfileTO
	 * @return
	 */
	public static UserProfile UserProfileTO2UserProfile(final UserProfileTO userProfileTO) {
		UserProfile profile = new UserProfile();
		profile.setLoginName(userProfileTO.getLoginName());
		profile.setStatus(userProfileTO.getStatus());
		profile.setUsedFrom(userProfileTO.getUsedFrom());

		// disable by isap
		// profile.setPassword(userProfileTO.getPassword());
		profile.setEmail(userProfileTO.getEmail());
		profile.setFirstName(userProfileTO.getFirstName());
		profile.setLastName(userProfileTO.getLastName());

		profile.setModified(userProfileTO.getModified() != null ? userProfileTO.getModified().getTime() : null);
		profile.setCreated(userProfileTO.getCreated() != null ? userProfileTO.getCreated().getTime() : null);
		return profile;
	}

	/**
	 * @param userProfile
	 * @return
	 */
	public static UserProfileTO UserProfile2UserProfileTO(final UserProfile userProfile) {
		UserProfileTO userProfileTO = new UserProfileTO();
		userProfileTO.setLoginName(userProfile.getLoginName());
		userProfileTO.setEmail(userProfile.getEmail());
		userProfileTO.setFirstName(userProfile.getFirstName());
		userProfileTO.setLastName(userProfile.getLastName());
		userProfileTO.setStatus(userProfile.getStatus());
		userProfileTO.setUsedFrom(userProfile.getUsedFrom());
		// userProfileTO.setPassword(userProfile.getPassword());

		return userProfileTO;
	}

	public static byte[] getScaledImg(int scaledW, int scaledH, BufferedImage cardImage) throws IOException {
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		Image scaledImage = cardImage.getScaledInstance(scaledW, scaledH, Image.SCALE_SMOOTH);
		BufferedImage image = new BufferedImage(scaledW, scaledH, BufferedImage.TYPE_INT_RGB);
		Graphics2D gr = image.createGraphics();
		gr.drawImage(scaledImage, 0, 0, null);
		gr.dispose();
		ImageIO.write(image, "jpeg", os);
		return os.toByteArray();
	}

	public static Category categoryTO2category(final CategoryTO categoryTO) {
		Category category = new Category();
		if (categoryTO != null) {
			ArrayList cardList = new ArrayList();
			for (int i = 0; i < categoryTO.getCardList().length; i++) {
				cardList.add(categoryTO.getCardList()[i]);
			}
			category.setCardList(cardList);
			category.setIdx(categoryTO.getIdx());
			category.setIcon(categoryTO.getIcon());
			category.setId(categoryTO.getId());
			category.setName(categoryTO.getName());
			category.setType(categoryTO.getType());
			category.setPreDefined(categoryTO.getType() != null && categoryTO.getType().length() > 2
					&& categoryTO.getType().substring(0, 3).equals(Messages.getString("PreDefinedCategory.Prefix")));
			category.setParentId(categoryTO.getParentId());
			category.setSelectedIcon(categoryTO.getSelectedIcon());
		}
		return category;
	}

	public static CategoryTO category2categoryTO(final Category category) {
		CategoryTO categoryTO = new CategoryTO();
		if (category != null) {
			String[] cardList = new String[category.getCardList().size()];
			int i = 0;
			for (Iterator iterator = category.getCardList().iterator(); iterator.hasNext();) {
				try {
					cardList[i] = ((Card) iterator.next()).getCuid();
				} catch (Exception e) {
				}
				i += 1;
			}
			categoryTO.setType(category.getType());
			categoryTO.setCardList(cardList);
			categoryTO.setIdx(category.getIdx());
			categoryTO.setIcon(category.getIcon());
			categoryTO.setId(category.getId());
			categoryTO.setName(category.getName());
			categoryTO.setParentId(category.getParentId());
			categoryTO.setSelectedIcon(category.getSelectedIcon());
		}
		return categoryTO;
	}

	public static MRU MRUTO2MRU(MapTO mruto) {
		MRU mru = new MRU();
		mru.setKey(mruto.getKey());
		for (int i = 0; i < mruto.getValues().length; i++) {
			mru.getValues().add(mruto.getValues()[i]);
		}
		return mru;
	}

	public static ICardUpdateTO cardUpdate2ICardUpdateTO(CardUpdate update) {
		ICardUpdateTO upTO = new ICardUpdateTO();
		upTO.setCuid(update.getCuid());
		if (update.getCredential() != null)
			upTO.setTokenServiceCredential(cardCredential2UITokenServiceCredentialTO(update.getCredential()));
		return upTO;
	}

}
