/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 * Alexander Yuhimenko - implementation 
 * 
 */
package org.eclipse.higgins.ics.gwt.base.client.button;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;

/**
 * @author Alexander Yuhimenko
 * 
 */
public class CardActionButton extends SimpleButton {

	/**
	 * @param text
	 * @param clickListener
	 * @param imageBorderRt
	 * @param imageBorderRtHover
	 */
	public CardActionButton(String text, ClickListener clickListener) {
		super(text, clickListener, new Image(Utils.getContextPath() + Utils.baseConstant.uriImgButtonPrimaryRt()), new Image(Utils
				.getContextPath()
				+ Utils.baseConstant.uriImgButtonPrimaryRtHover()));

		// super(text, clickListener, imageBorderRt, imageBorderRtHover);
	}

	public String getStyleNameButton() {
		return "cardAction_button";
	}

	public String getStyleNameButtonActive() {
		return "cardAction_button_active";
	}

}
