package org.eclipse.higgins.ics.gwt.base.client.button;

import org.eclipse.higgins.ics.gwt.base.client.util.Utils;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Image;

public class DisabledNavigationButton extends SimpleButton implements INavigationButton{
	
	public DisabledNavigationButton(String text, ClickListener clickListener, String direction)
	{
		super(text, clickListener, new Image(Utils.getContextPath() + Utils.baseConstant.uriImgButtonToolbarRt()), new Image(Utils
				.getContextPath()
				+ Utils.baseConstant.uriImgButtonToolbarRtHover()));
		final Image image;
		if (direction.equalsIgnoreCase(LEFT_DIRECTION)) {
			image = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgArrowLeftGray());
			getPanel().insert(image, 0);
		} else {
			image = new Image(Utils.getContextPath() + Utils.baseConstant.uriImgArrowRightGray());
			getPanel().add(image);
		}
		image.setStyleName("image_button");
		if (clickListener != null) image.addClickListener(clickListener);
		else this.getText().removeClickListener(clickListener);
		image.addMouseListener(getMouseListener());
		this.setVisible(false);
	}

}
